/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing;

import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.BatchProcessor;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Batch;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.BatchFactory;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.json.JsonBatchFactory;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart.MultipartFactory;
import de.fraunhofer.iosb.ilt.frostserver.service.Service;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ServiceBatchProcessing {
    public static final String PATH_POST_BATCH = "/$batch";
    public static final String REQUEST_TYPE_BATCH = "batchProcess";
    private static final Map<String, BatchFactory<?>> CONTENT_TYPE_TO_FACTORY = new HashMap();
    private final CoreSettings settings;

    public ServiceBatchProcessing(CoreSettings settings) {
        this.settings = settings;
    }

    public ServiceResponse<String> executeBatchOperation(Service service, ServiceRequest request) {
        BatchFactory<?> batchFactory = CONTENT_TYPE_TO_FACTORY.get(request.getContentType().split(";", 2)[0].toLowerCase());
        if (batchFactory == null) {
            throw new IllegalArgumentException("Invalid Content-Type: " + request.getContentType());
        }
        Batch<?> batch = batchFactory.createBatch(request.getVersion(), this.settings, false);
        batch.parse(request);
        Batch<?> resultContent = new BatchProcessor(batchFactory).processBatch(request, service, batch);
        return this.sendResponse(resultContent);
    }

    private ServiceResponse<String> sendResponse(Batch batch) {
        ServiceResponse response = new ServiceResponse();
        response.setCode(200);
        batch.getHeaders().entrySet().forEach(x -> response.addHeader((String)x.getKey(), (String)x.getValue()));
        response.setResultFormatted(batch.getContent(false));
        return response;
    }

    static {
        for (BatchFactory factory : Arrays.asList(new MultipartFactory(), new JsonBatchFactory())) {
            CONTENT_TYPE_TO_FACTORY.put(factory.getContentType(), factory);
        }
    }
}

