/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing;

import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.ServiceBatchProcessing;
import de.fraunhofer.iosb.ilt.frostserver.service.Plugin;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginRootDocument;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginService;
import de.fraunhofer.iosb.ilt.frostserver.service.Service;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueBoolean;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class PluginBatchProcessing
implements PluginService,
PluginRootDocument,
ConfigDefaults {
    @DefaultValueBoolean(value=true)
    public static final String TAG_ENABLE_BATCH_PROCESSING = "batchProcessing.enable";
    private static final String REQUIREMENT_BATCH_PROCESSING = "http://www.opengis.net/spec/iot_sensing/1.1/req/batch-request/batch-request";
    private CoreSettings settings;

    public void init(CoreSettings settings) {
        this.settings = settings;
        Settings pluginSettings = settings.getPluginSettings();
        boolean enabled = pluginSettings.getBoolean(TAG_ENABLE_BATCH_PROCESSING, this.getClass());
        if (enabled) {
            settings.getPluginManager().registerPlugin((Plugin)this);
        }
    }

    public void modifyServiceDocument(ServiceRequest request, Map<String, Object> result) {
        Map serverSettings = (Map)result.get("serverSettings");
        if (serverSettings == null) {
            return;
        }
        Set extensionList = (Set)serverSettings.get("conformance");
        extensionList.add(REQUIREMENT_BATCH_PROCESSING);
    }

    public Collection<String> getUrlPaths() {
        return Arrays.asList("/$batch");
    }

    public Collection<String> getRequestTypes() {
        return Arrays.asList("batchProcess");
    }

    public String getRequestTypeFor(String path, HttpMethod method) {
        if (method.equals((Object)HttpMethod.POST) && path.equals("/$batch")) {
            return "batchProcess";
        }
        throw new IllegalArgumentException("Method " + method + "not valid for path " + path);
    }

    public ServiceResponse execute(Service service, ServiceRequest request) {
        return new ServiceBatchProcessing(this.settings).executeBatchOperation(service, request);
    }
}

