/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.actuation;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManagerFactory;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PostgresPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTableAbstract;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.TableCollection;
import de.fraunhofer.iosb.ilt.frostserver.plugin.actuation.ActuationModelSettings;
import de.fraunhofer.iosb.ilt.frostserver.plugin.actuation.TableImpActuators;
import de.fraunhofer.iosb.ilt.frostserver.plugin.actuation.TableImpTaskingCapabilities;
import de.fraunhofer.iosb.ilt.frostserver.plugin.actuation.TableImpTasks;
import de.fraunhofer.iosb.ilt.frostserver.plugin.coremodel.PluginCoreModel;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostserver.service.Plugin;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginModel;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginRootDocument;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUser;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.UpgradeFailedException;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.time4j.Moment;
import org.jooq.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginActuation
implements PluginRootDocument,
PluginModel,
ConfigDefaults,
LiquibaseUser {
    private static final String LIQUIBASE_CHANGELOG_FILENAME = "liquibase/pluginactuation/tables.xml";
    private static final String ACTUATOR = "Actuator";
    private static final String ACTUATORS = "Actuators";
    private static final String TASK = "Task";
    private static final String TASKS = "Tasks";
    private static final String TASKING_CAPABILITY = "TaskingCapability";
    private static final String TASKING_CAPABILITIES = "TaskingCapabilities";
    public static final String LIQUIBASE_NAME_TASKING_CAP = "TaskingCap";
    public static final String LIQUIBASE_NAME_TASK = "Task";
    public static final String LIQUIBASE_NAME_ACTUATOR = "Actuator";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PluginActuation.class.getName());
    public final EntityPropertyMain<Map<String, Object>> epTaskingParameters = new EntityPropertyMain("taskingParameters", (PropertyType)TypeComplex.STA_MAP, true, false);
    private EntityPropertyMain<?> epIdActuator;
    private EntityPropertyMain<?> epIdTask;
    private EntityPropertyMain<?> epIdTaskingCap;
    public final NavigationPropertyMain.NavigationPropertyEntity npActuatorTaskCap = new NavigationPropertyMain.NavigationPropertyEntity("Actuator", true);
    public final NavigationPropertyMain.NavigationPropertyEntity npThingTaskCap = new NavigationPropertyMain.NavigationPropertyEntity("Thing", true);
    public final NavigationPropertyMain.NavigationPropertyEntitySet npTasksTaskCap = new NavigationPropertyMain.NavigationPropertyEntitySet("Tasks");
    public final NavigationPropertyMain.NavigationPropertyEntity npTaskingCapabilityTask = new NavigationPropertyMain.NavigationPropertyEntity("TaskingCapability", (NavigationPropertyMain)this.npTasksTaskCap, true);
    public final NavigationPropertyMain.NavigationPropertyEntitySet npTaskingCapabilitiesActuator = new NavigationPropertyMain.NavigationPropertyEntitySet("TaskingCapabilities", (NavigationPropertyMain)this.npActuatorTaskCap);
    public final NavigationPropertyMain.NavigationPropertyEntitySet npTaskingCapabilitiesThing = new NavigationPropertyMain.NavigationPropertyEntitySet("TaskingCapabilities", (NavigationPropertyMain)this.npThingTaskCap);
    public final EntityType etActuator = new EntityType("Actuator", "Actuators");
    public final EntityType etTask = new EntityType("Task", "Tasks");
    public final EntityType etTaskingCapability = new EntityType("TaskingCapability", "TaskingCapabilities");
    private static final List<String> REQUIREMENTS_ACTUATION = Arrays.asList("http://www.opengis.net/spec/iot_tasking/1.0/req/tasking-capability", "http://www.opengis.net/spec/iot_tasking/1.0/req/task", "http://www.opengis.net/spec/iot_tasking/1.0/req/actuator", "http://www.opengis.net/spec/iot_tasking/1.0/req/create-tasks", "http://www.opengis.net/spec/iot_tasking/1.0/req/create-tasks-via-mqtt", "http://www.opengis.net/spec/iot_tasking/1.0/req/receive-updates-via-mqtt");
    private CoreSettings settings;
    private ActuationModelSettings modelSettings;
    private boolean enabled;
    private boolean fullyInitialised;

    public PluginActuation() {
        LOGGER.info("Creating new Actuation Plugin.");
    }

    public void init(CoreSettings settings) {
        this.settings = settings;
        Settings pluginSettings = settings.getPluginSettings();
        this.enabled = pluginSettings.getBoolean("actuation.enable", ActuationModelSettings.class);
        if (this.enabled) {
            this.modelSettings = new ActuationModelSettings(settings);
            settings.getPluginManager().registerPlugin((Plugin)this);
        }
    }

    public boolean isFullyInitialised() {
        return this.fullyInitialised;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void modifyServiceDocument(ServiceRequest request, Map<String, Object> result) {
        Map serverSettings = (Map)result.get("serverSettings");
        if (serverSettings == null) {
            return;
        }
        Set extensionList = (Set)serverSettings.get("conformance");
        extensionList.addAll(REQUIREMENTS_ACTUATION);
    }

    public void registerEntityTypes() {
        LOGGER.info("Initialising Actuation Types...");
        ModelRegistry mr = this.settings.getModelRegistry();
        mr.registerEntityType(this.etActuator);
        mr.registerEntityType(this.etTask);
        mr.registerEntityType(this.etTaskingCapability);
        this.epIdActuator = new EntityPropertyMain("@iot.id", mr.getPropertyType(this.modelSettings.idTypeActuator)).setAliases(new String[]{"id"});
        this.epIdTask = new EntityPropertyMain("@iot.id", mr.getPropertyType(this.modelSettings.idTypeTask)).setAliases(new String[]{"id"});
        this.epIdTaskingCap = new EntityPropertyMain("@iot.id", mr.getPropertyType(this.modelSettings.idTypeTaskingCap)).setAliases(new String[]{"id"});
    }

    public boolean linkEntityTypes(PersistenceManager pm) {
        LOGGER.info("Linking Actuation Types...");
        PluginCoreModel pluginCoreModel = (PluginCoreModel)this.settings.getPluginManager().getPlugin(PluginCoreModel.class);
        if (pluginCoreModel == null || !pluginCoreModel.isFullyInitialised()) {
            return false;
        }
        this.etActuator.registerProperty(this.epIdActuator).registerProperty((Property)pluginCoreModel.epName).registerProperty((Property)pluginCoreModel.epDescription).registerProperty((Property)ModelRegistry.EP_ENCODINGTYPE).registerProperty((Property)pluginCoreModel.epMetadata).registerProperty((Property)ModelRegistry.EP_PROPERTIES).registerProperty((Property)this.npTaskingCapabilitiesActuator);
        this.etTask.registerProperty(this.epIdTask).registerProperty((Property)pluginCoreModel.epCreationTime).registerProperty(this.epTaskingParameters).registerProperty((Property)this.npTaskingCapabilityTask).addCreateValidator("AC-Task-CrationTime", (entity, entityPropertiesOnly) -> {
            if (entity.getProperty((Property)pluginCoreModel.epCreationTime) == null) {
                entity.setProperty((Property)pluginCoreModel.epCreationTime, (Object)new TimeInstant(Moment.nowInSystemTime()));
            }
        });
        this.etTaskingCapability.registerProperty(this.epIdTaskingCap).registerProperty((Property)pluginCoreModel.epName).registerProperty((Property)pluginCoreModel.epDescription).registerProperty((Property)ModelRegistry.EP_PROPERTIES).registerProperty(this.epTaskingParameters).registerProperty((Property)this.npActuatorTaskCap).registerProperty((Property)this.npTasksTaskCap).registerProperty((Property)this.npThingTaskCap);
        pluginCoreModel.etThing.registerProperty((Property)this.npTaskingCapabilitiesThing);
        if (pm instanceof PostgresPersistenceManager) {
            PostgresPersistenceManager ppm = (PostgresPersistenceManager)pm;
            TableCollection tableCollection = ppm.getTableCollection();
            DataType dataTypeActr = ppm.getDataTypeFor(this.modelSettings.idTypeActuator);
            DataType dataTypeTask = ppm.getDataTypeFor(this.modelSettings.idTypeTask);
            DataType dataTypeTCap = ppm.getDataTypeFor(this.modelSettings.idTypeTaskingCap);
            DataType dataTypeThng = tableCollection.getTableForType(pluginCoreModel.etThing).getId().getDataType();
            tableCollection.registerTable(this.etActuator, (StaTableAbstract)new TableImpActuators(dataTypeActr, this, pluginCoreModel));
            tableCollection.registerTable(this.etTask, (StaTableAbstract)new TableImpTasks(dataTypeTask, dataTypeTCap, this, pluginCoreModel));
            tableCollection.registerTable(this.etTaskingCapability, (StaTableAbstract)new TableImpTaskingCapabilities(dataTypeTCap, dataTypeActr, dataTypeThng, this, pluginCoreModel));
        }
        this.fullyInitialised = true;
        return true;
    }

    public Map<String, Object> createLiqibaseParams(PostgresPersistenceManager ppm, Map<String, Object> target) {
        if (target == null) {
            target = new LinkedHashMap<String, Object>();
        }
        PluginCoreModel pCoreModel = (PluginCoreModel)this.settings.getPluginManager().getPlugin(PluginCoreModel.class);
        pCoreModel.createLiqibaseParams(ppm, target);
        ppm.generateLiquibaseVariables(target, "Actuator", this.modelSettings.idTypeActuator);
        ppm.generateLiquibaseVariables(target, "Task", this.modelSettings.idTypeTask);
        ppm.generateLiquibaseVariables(target, LIQUIBASE_NAME_TASKING_CAP, this.modelSettings.idTypeTaskingCap);
        return target;
    }

    public String checkForUpgrades() {
        try (PersistenceManager pm = PersistenceManagerFactory.getInstance((CoreSettings)this.settings).create();){
            if (pm instanceof PostgresPersistenceManager) {
                PostgresPersistenceManager ppm = (PostgresPersistenceManager)pm;
                String string = ppm.checkForUpgrades(LIQUIBASE_CHANGELOG_FILENAME, this.createLiqibaseParams(ppm, null));
                return string;
            }
            String string = "Unknown persistence manager class";
            return string;
        }
    }

    public boolean doUpgrades(Writer out) throws UpgradeFailedException, IOException {
        try (PersistenceManager pm = PersistenceManagerFactory.getInstance((CoreSettings)this.settings).create();){
            if (pm instanceof PostgresPersistenceManager) {
                PostgresPersistenceManager ppm = (PostgresPersistenceManager)pm;
                boolean bl = ppm.doUpgrades(LIQUIBASE_CHANGELOG_FILENAME, this.createLiqibaseParams(ppm, null), out);
                return bl;
            }
            out.append("Unknown persistence manager class");
            boolean bl = false;
            return bl;
        }
    }
}

