/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver;

import de.fraunhofer.iosb.ilt.frostserver.http.common.AbstractContextListener;
import de.fraunhofer.iosb.ilt.frostserver.messagebus.MessageBusFactory;
import de.fraunhofer.iosb.ilt.frostserver.messagebus.MessageListener;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.MqttManager;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.annotation.WebListener;
import org.slf4j.bridge.SLF4JBridgeHandler;

@WebListener
public class ContextListener
extends AbstractContextListener {
    MqttManager mqttManager;

    public void contextInitialized(ServletContextEvent sce) {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        super.contextInitialized(sce);
        if (sce != null && sce.getServletContext() != null) {
            CoreSettings coreSettings = this.getCoreSettings();
            this.mqttManager = new MqttManager(coreSettings);
            MessageBusFactory.createMessageBus((CoreSettings)coreSettings);
            coreSettings.getMessageBus().addMessageListener((MessageListener)this.mqttManager);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.mqttManager != null) {
            this.mqttManager.shutdown();
        }
        super.contextDestroyed(sce);
    }
}

