/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver;

import de.fraunhofer.iosb.ilt.frostserver.messagebus.MessageBusFactory;
import de.fraunhofer.iosb.ilt.frostserver.messagebus.MessageListener;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.MqttManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManagerFactory;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.GitVersionInfo;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class FrostMqttServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrostMqttServer.class);
    private static final String KEY_WAIT_FOR_ENTER = "WaitForEnter";
    private static final String CONFIG_FILE_NAME = "FrostMqtt.properties";
    private final CoreSettings coreSettings;
    private MqttManager mqttManager;
    private Thread shutdownHook;

    public FrostMqttServer(CoreSettings coreSettings) {
        this.coreSettings = coreSettings;
    }

    private synchronized void addShutdownHook() {
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(() -> {
                LOGGER.info("Shutting down...");
                try {
                    this.stop();
                }
                catch (Exception ex) {
                    LOGGER.warn("Exception stopping listeners.", (Throwable)ex);
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    public void start() {
        this.addShutdownHook();
        PersistenceManagerFactory.init((CoreSettings)this.coreSettings);
        MessageBusFactory.createMessageBus((CoreSettings)this.coreSettings);
        this.mqttManager = new MqttManager(this.coreSettings);
        this.coreSettings.getMessageBus().addMessageListener((MessageListener)this.mqttManager);
    }

    public void stop() {
        LOGGER.info("Shutting down threads...");
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException ex) {
            LOGGER.trace("Already shutting down.", (Throwable)ex);
        }
        this.mqttManager.shutdown();
        this.coreSettings.getMessageBus().stop();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            LOGGER.debug("Rude wakeup?", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        LOGGER.info("Done shutting down threads.");
    }

    private static CoreSettings loadCoreSettings(String configFileName) throws IOException {
        Properties defaults = new Properties();
        defaults.setProperty("tempPath", System.getProperty("java.io.tmpdir"));
        Properties properties = new Properties(defaults);
        try (FileInputStream input = new FileInputStream(configFileName);){
            properties.load(input);
            LOGGER.info("Read {} properties from {}.", (Object)properties.size(), (Object)configFileName);
        }
        catch (IOException exc) {
            LOGGER.info("Could not read properties from file: {}.", (Object)exc.getMessage());
        }
        return new CoreSettings(properties);
    }

    public static void main(String[] args) throws IOException {
        GitVersionInfo.logGitInfo();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        String configFileName = CONFIG_FILE_NAME;
        if (args.length > 0) {
            configFileName = args[0];
        }
        CoreSettings coreSettings = FrostMqttServer.loadCoreSettings(configFileName);
        FrostMqttServer server = new FrostMqttServer(coreSettings);
        server.start();
        boolean waitForEnter = coreSettings.getMqttSettings().getCustomSettings().getBoolean(KEY_WAIT_FOR_ENTER, false);
        if (waitForEnter) {
            try (BufferedReader input = new BufferedReader(new InputStreamReader(System.in, StringHelper.UTF8));){
                LOGGER.warn("Press Enter to exit.");
                String read = input.readLine();
                LOGGER.warn("Exiting due to input {}...", (Object)read);
                server.stop();
            }
        }
    }
}

