/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.auth.keycloak;

import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.util.AuthUtils;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static String getKeycloakConfig(CoreSettings coreSettings) {
        Settings authSettings = coreSettings.getAuthSettings();
        String keycloakConfig = authSettings.get("keycloakConfig", "");
        if (!StringHelper.isNullOrEmpty((String)keycloakConfig)) {
            return keycloakConfig;
        }
        keycloakConfig = Utils.getKeycloakConfigFromFile(authSettings);
        if (!StringHelper.isNullOrEmpty((String)keycloakConfig)) {
            return keycloakConfig;
        }
        keycloakConfig = Utils.getKeycloakConfigFromServer(authSettings);
        return keycloakConfig;
    }

    private static String getKeycloakConfigFromFile(Settings authSettings) {
        String keycloakConfigFile = authSettings.get("keycloakConfigFile", "");
        if (StringHelper.isNullOrEmpty((String)keycloakConfigFile)) {
            return "";
        }
        try {
            return FileUtils.readFileToString((File)FileUtils.getFile((String[])new String[]{keycloakConfigFile}), (Charset)StringHelper.UTF8);
        }
        catch (IOException exc) {
            LOGGER.error("Failed to read keycloak config file.", (Throwable)exc);
            return "";
        }
    }

    private static String getKeycloakConfigFromServer(Settings authSettings) {
        String string;
        block10: {
            String keycloakConfigUrl = authSettings.get("keycloakConfigUrl", "");
            if (StringHelper.isNullOrEmpty((String)keycloakConfigUrl)) {
                return "";
            }
            String keycloakConfigSecret = authSettings.get("keycloakConfigSecret", "");
            LOGGER.info("Fetching Keycloak config from server: {}", (Object)keycloakConfigUrl);
            CloseableHttpClient client = HttpClients.createSystem();
            try {
                HttpGet httpGet = new HttpGet(keycloakConfigUrl);
                if (!StringHelper.isNullOrEmpty((String)keycloakConfigSecret)) {
                    String clientId = keycloakConfigUrl.substring(keycloakConfigUrl.lastIndexOf(47) + 1);
                    String encoded = clientId + ":" + keycloakConfigSecret;
                    httpGet.addHeader("Authorization", "basic " + Base64.encodeBase64String((byte[])encoded.getBytes()));
                }
                CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpGet);
                String configString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StringHelper.UTF8);
                LOGGER.info("Fetched Keycloak config from server. Size {}", (Object)configString.length());
                string = configString;
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exc) {
                    LOGGER.error("Failed to read keycloak config file.", (Throwable)exc);
                    return "";
                }
            }
            client.close();
        }
        return string;
    }

    public static KeycloakDeployment resolveDeployment(CoreSettings coreSettings) {
        String keycloakConfig = Utils.getKeycloakConfig(coreSettings);
        ByteArrayInputStream input = new ByteArrayInputStream(keycloakConfig.getBytes(StringHelper.UTF8));
        return KeycloakDeploymentBuilder.build((InputStream)input);
    }

    public static interface MethodRoleMapper {
        public AuthUtils.Role findRole(HttpMethod var1);
    }
}

