/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.auth.keycloak;

import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

class RequestWrapper
extends HttpServletRequestWrapper {
    private final PrincipalExtended userPrincipal;
    private final HttpServletRequest wrapped;

    RequestWrapper(HttpServletRequest wrapped, PrincipalExtended userPrincipal) {
        super(wrapped);
        this.wrapped = wrapped;
        this.userPrincipal = userPrincipal;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal == null ? this.wrapped.getUserPrincipal() : this.userPrincipal;
    }

    public boolean isUserInRole(String role) {
        return this.userPrincipal.getRoles().contains(role);
    }
}

