/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.auth.keycloak;

import de.fraunhofer.iosb.ilt.frostserver.auth.keycloak.DatabaseHandler;
import de.fraunhofer.iosb.ilt.frostserver.auth.keycloak.KeycloakAuthProvider;
import de.fraunhofer.iosb.ilt.frostserver.auth.keycloak.RequestWrapper;
import de.fraunhofer.iosb.ilt.frostserver.auth.keycloak.Utils;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.util.AuthUtils;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AuthenticatedActionsHandler;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.PreAuthActionsHandler;
import org.keycloak.adapters.servlet.FilterRequestAuthenticator;
import org.keycloak.adapters.servlet.OIDCFilterSessionStore;
import org.keycloak.adapters.servlet.OIDCServletHttpFacade;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.InMemorySessionIdMapper;
import org.keycloak.adapters.spi.KeycloakAccount;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.UserSessionManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakFilter.class);
    private final Map<String, Utils.MethodRoleMapper> roleMappersByPath = new HashMap<String, Utils.MethodRoleMapper>();
    private Map<AuthUtils.Role, String> roleMappings;
    private String roleAdmin;
    private boolean authenticateOnly;
    private boolean registerUserLocally;
    private DatabaseHandler databaseHandler;
    private AdapterDeploymentContext deploymentContext;
    private NodesRegistrationManagement nodesRegistrationManagement;
    private UserSessionManagement sessionCleaner;
    private final SessionIdMapper idMapper = new InMemorySessionIdMapper();

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext context = filterConfig.getServletContext();
        Object attribute = context.getAttribute("CoreSettings");
        if (!(attribute instanceof CoreSettings)) {
            throw new IllegalArgumentException("Could not load core settings.");
        }
        CoreSettings coreSettings = (CoreSettings)attribute;
        Settings authSettings = coreSettings.getAuthSettings();
        this.roleMappings = AuthUtils.loadRoleMapping((Settings)authSettings);
        this.roleAdmin = authSettings.get("role.admin", CoreSettings.class);
        this.authenticateOnly = authSettings.getBoolean("authenticateOnly", CoreSettings.class);
        this.registerUserLocally = authSettings.getBoolean("registerUserLocally", KeycloakAuthProvider.class);
        if (this.registerUserLocally) {
            this.databaseHandler = DatabaseHandler.getInstance(coreSettings);
        }
        boolean anonRead = authSettings.getBoolean("allowAnonymousRead", CoreSettings.class);
        this.roleMappersByPath.put("/Data", method -> AuthUtils.Role.ADMIN);
        this.roleMappersByPath.put("/keyc", method -> AuthUtils.Role.ADMIN);
        Utils.MethodRoleMapper roleMapperSta = method -> {
            switch (method) {
                case DELETE: {
                    return AuthUtils.Role.DELETE;
                }
                case GET: {
                    if (anonRead) {
                        return AuthUtils.Role.NONE;
                    }
                    return AuthUtils.Role.READ;
                }
                case HEAD: {
                    return AuthUtils.Role.NONE;
                }
                case PATCH: {
                    return AuthUtils.Role.UPDATE;
                }
                case POST: {
                    return AuthUtils.Role.CREATE;
                }
                case PUT: {
                    return AuthUtils.Role.UPDATE;
                }
                case OPTIONS: {
                    return AuthUtils.Role.NONE;
                }
            }
            LOGGER.error("Unknown method: {}", (Object)method);
            return AuthUtils.Role.ERROR;
        };
        for (String version : coreSettings.getPluginManager().getVersions().keySet()) {
            this.roleMappersByPath.put("/" + version, roleMapperSta);
        }
        try {
            this.deploymentContext = new AdapterDeploymentContext(Utils.resolveDeployment(coreSettings));
        }
        catch (RuntimeException exc) {
            LOGGER.error("Failed to initialise Keycloak. There is a problem with the configuration.");
            throw new IllegalArgumentException("Exception initialising keycloak.", exc);
        }
        this.nodesRegistrationManagement = new NodesRegistrationManagement();
        this.sessionCleaner = new UserSessionManagement(){

            public void logoutAll() {
                KeycloakFilter.this.idMapper.clear();
            }

            public void logoutHttpSessions(List<String> ids) {
                LOGGER.debug("Logging out Http Sessions");
                for (String id : ids) {
                    LOGGER.debug("Removed session: {}", (Object)id);
                    KeycloakFilter.this.idMapper.removeSession(id);
                }
            }
        };
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        AuthChallenge challenge;
        LOGGER.trace("FROST Keycloak Filter - Filtering request...");
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        AuthUtils.Role requiredRole = this.findRequiredRoleForRequest(httpRequest);
        if (requiredRole == AuthUtils.Role.NONE) {
            chain.doFilter(request, response);
            return;
        }
        if (requiredRole == AuthUtils.Role.ERROR) {
            this.throwHttpError(400, httpResponse);
            return;
        }
        OIDCServletHttpFacade facade = new OIDCServletHttpFacade(httpRequest, httpResponse);
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (deployment == null || !deployment.isConfigured()) {
            LOGGER.error("Deployment not found");
            this.throwHttpError(403, httpResponse);
            return;
        }
        PreAuthActionsHandler preActions = new PreAuthActionsHandler(this.sessionCleaner, this.deploymentContext, (HttpFacade)facade);
        if (preActions.handleRequest()) {
            LOGGER.debug("Request handled by preActions.");
            return;
        }
        this.nodesRegistrationManagement.tryRegister(deployment);
        OIDCFilterSessionStore tokenStore = new OIDCFilterSessionStore(httpRequest, (HttpFacade)facade, 100000, deployment, this.idMapper);
        tokenStore.checkCurrentToken();
        FilterRequestAuthenticator authenticator = new FilterRequestAuthenticator(deployment, (AdapterTokenStore)tokenStore, (OIDCHttpFacade)facade, httpRequest, 8443);
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            LOGGER.debug("User is authenticated...");
            if (facade.isEnded()) {
                LOGGER.debug("Facade is ended.");
                return;
            }
            AuthenticatedActionsHandler actions = new AuthenticatedActionsHandler(deployment, (OIDCHttpFacade)facade);
            if (actions.handledRequest()) {
                LOGGER.debug("Request handled by authentication actions.");
                return;
            }
            KeycloakAccount account = this.findKeycloakAccount(httpRequest);
            Principal principalBasic = account.getPrincipal();
            Set roles = account.getRoles();
            String userName = principalBasic.getName();
            PrincipalExtended pe = new PrincipalExtended(userName, roles.contains(this.roleAdmin), roles);
            if (this.registerUserLocally) {
                this.databaseHandler.enureUserInUsertable(userName);
            }
            if (this.authenticateOnly) {
                chain.doFilter((ServletRequest)new RequestWrapper(httpRequest, pe), response);
                return;
            }
            if (roles.contains(this.roleMappings.get(requiredRole))) {
                LOGGER.debug("User has correct role.");
                chain.doFilter((ServletRequest)new RequestWrapper(httpRequest, pe), response);
                return;
            }
        }
        if ((challenge = authenticator.getChallenge()) != null) {
            LOGGER.debug("Challenge.");
            try {
                challenge.challenge((HttpFacade)facade);
                return;
            }
            catch (IllegalStateException ex) {
                LOGGER.debug("Challenge failed.", (Throwable)ex);
            }
        }
        LOGGER.debug("User is not allowed.");
        this.throwHttpError(403, httpResponse);
    }

    private KeycloakAccount findKeycloakAccount(HttpServletRequest httpRequest) {
        HttpSession session = httpRequest.getSession(false);
        KeycloakAccount account = null;
        if (session != null && (account = (KeycloakAccount)session.getAttribute(KeycloakAccount.class.getName())) == null) {
            account = (KeycloakAccount)httpRequest.getAttribute(KeycloakAccount.class.getName());
        }
        if (account == null) {
            account = (KeycloakAccount)httpRequest.getAttribute(KeycloakAccount.class.getName());
        }
        return account;
    }

    public void destroy() {
    }

    private AuthUtils.Role findRequiredRoleForRequest(HttpServletRequest httpRequest) {
        String pathInfo;
        HttpMethod method;
        try {
            method = HttpMethod.valueOf((String)httpRequest.getMethod().toUpperCase());
        }
        catch (IllegalArgumentException exc) {
            LOGGER.debug("Rejecting request: Unknown method: {}.", (Object)httpRequest.getMethod());
            return AuthUtils.Role.ERROR;
        }
        String requestURI = httpRequest.getRequestURI();
        String contextPath = httpRequest.getContextPath();
        String servletPath = httpRequest.getServletPath();
        String preVersionPath = contextPath + servletPath;
        if (requestURI.startsWith(preVersionPath)) {
            pathInfo = StringHelper.urlDecode((String)requestURI.substring(preVersionPath.length()));
        } else if (!servletPath.isEmpty()) {
            pathInfo = servletPath;
        } else {
            throw new IllegalArgumentException("Path oddness!");
        }
        if (pathInfo.isEmpty()) {
            pathInfo = servletPath;
        }
        LOGGER.trace("\nrequestURI: {}\ncontextPath: {}\nservletPath: {}\nfullPath: {}\npathInfo: {}", new Object[]{requestURI, contextPath, servletPath, preVersionPath, pathInfo});
        Utils.MethodRoleMapper mapper = this.roleMappersByPath.get(pathInfo.substring(0, 5));
        if (mapper == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("No role mapper for servletPath: {}", (Object)StringHelper.cleanForLogging((String)servletPath));
            }
            return AuthUtils.Role.ERROR;
        }
        AuthUtils.Role requiredRole = mapper.findRole(method);
        LOGGER.debug("Role {} required for request {} {}", new Object[]{requiredRole, httpRequest.getMethod(), httpRequest.getRequestURI()});
        return requiredRole;
    }

    private void throwHttpError(int code, HttpServletResponse response) {
        try {
            response.sendError(code);
        }
        catch (IOException exc) {
            LOGGER.error("Exception sending back error.", (Throwable)exc);
        }
    }
}

