/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.auth.keycloak;

import de.fraunhofer.iosb.ilt.frostserver.auth.keycloak.BearerTokenLoginModuleFrost;
import de.fraunhofer.iosb.ilt.frostserver.auth.keycloak.DatabaseHandler;
import de.fraunhofer.iosb.ilt.frostserver.auth.keycloak.DirectAccessGrantsLoginModuleFrost;
import de.fraunhofer.iosb.ilt.frostserver.auth.keycloak.KeycloakFilterHelper;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueBoolean;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueInt;
import de.fraunhofer.iosb.ilt.frostserver.util.AuthProvider;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUser;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.UpgradeFailedException;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import de.fraunhofer.iosb.ilt.frostserver.util.user.UserClientInfo;
import de.fraunhofer.iosb.ilt.frostserver.util.user.UserData;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import org.keycloak.adapters.jaas.AbstractKeycloakLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakAuthProvider
implements AuthProvider,
LiquibaseUser,
ConfigDefaults {
    @DefaultValue(value="")
    public static final String TAG_KEYCLOAK_CONFIG = "keycloakConfig";
    @DefaultValue(value="")
    public static final String TAG_KEYCLOAK_CONFIG_FILE = "keycloakConfigFile";
    @DefaultValue(value="")
    public static final String TAG_KEYCLOAK_CONFIG_URL = "keycloakConfigUrl";
    @DefaultValue(value="")
    public static final String TAG_KEYCLOAK_CONFIG_SECRET = "keycloakConfigSecret";
    @DefaultValueInt(value=10)
    public static final String TAG_MAX_CLIENTS_PER_USER = "maxClientsPerUser";
    @DefaultValueBoolean(value=false)
    public static final String TAG_REGISTER_USER_LOCALLY = "registerUserLocally";
    @DefaultValue(value="USERS")
    public static final String TAG_USER_TABLE = "userTable";
    @DefaultValue(value="USER_NAME")
    public static final String TAG_USERNAME_COLUMN = "usernameColumn";
    @DefaultValueInt(value=128)
    public static final String TAG_MAX_PASSWORD_LENGTH = "maxPasswordLength";
    @DefaultValueInt(value=128)
    public static final String TAG_MAX_USERNAME_LENGTH = "maxUsernameLength";
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakAuthProvider.class);
    private static final String FROST_SERVER_KEYCLOAKJSON = "FROST-Server-Keycloak.json";
    private static final int CUTOFF_HOURS = 24;
    private CoreSettings coreSettings;
    private String roleAdmin;
    private int maxClientsPerUser;
    private boolean registerUserLocally;
    private DatabaseHandler databaseHandler;
    private int maxPassLength = 128;
    private int maxNameLength = 128;
    private final Map<String, UserClientInfo> clientidToUserinfo = new ConcurrentHashMap<String, UserClientInfo>();
    private final Map<String, UserClientInfo> usernameToUserinfo = new ConcurrentHashMap<String, UserClientInfo>();
    private static final Map<String, Client> CLIENTMAP = new ConcurrentHashMap<String, Client>();
    private static final Map<String, Object> SHARED_STATE = new ConcurrentHashMap<String, Object>();
    private static final Map<String, Object> OPTIONS = new HashMap<String, Object>();

    public void init(CoreSettings coreSettings) {
        this.coreSettings = coreSettings;
        OPTIONS.put("keycloak-config-file", FROST_SERVER_KEYCLOAKJSON);
        Settings authSettings = coreSettings.getAuthSettings();
        this.roleAdmin = authSettings.get("role.admin", CoreSettings.class);
        this.maxClientsPerUser = authSettings.getInt(TAG_MAX_CLIENTS_PER_USER, this.getClass());
        this.maxPassLength = authSettings.getInt(TAG_MAX_PASSWORD_LENGTH, this.getClass());
        this.maxNameLength = authSettings.getInt(TAG_MAX_USERNAME_LENGTH, this.getClass());
        this.registerUserLocally = authSettings.getBoolean(TAG_REGISTER_USER_LOCALLY, KeycloakAuthProvider.class);
        if (this.registerUserLocally) {
            DatabaseHandler.init(coreSettings);
            this.databaseHandler = DatabaseHandler.getInstance(coreSettings);
        }
    }

    public void addFilter(Object context, CoreSettings coreSettings) {
        KeycloakFilterHelper.createFilters(context, coreSettings);
    }

    public boolean isValidUser(String clientId, String username, String password) {
        Object loginModule;
        if (password.length() > 50) {
            LOGGER.debug("Using BearerTokenLoginModule...");
            loginModule = new BearerTokenLoginModuleFrost(this.coreSettings);
        } else {
            LOGGER.debug("Using DirectAccessGrantsLoginModule...");
            loginModule = new DirectAccessGrantsLoginModuleFrost(this.coreSettings);
        }
        UserData userData = new UserData(username, this.maxNameLength, password, this.maxPassLength);
        this.clientMapCleanup();
        boolean validUser = this.checkLogin((AbstractKeycloakLoginModule)loginModule, userData, clientId);
        if (!validUser) {
            return false;
        }
        boolean admin = userData.roles.contains(this.roleAdmin);
        PrincipalExtended userPrincipal = new PrincipalExtended(userData.userName, admin, userData.roles);
        UserClientInfo userInfo = this.usernameToUserinfo.computeIfAbsent(userData.userName, t -> new UserClientInfo());
        userInfo.setUserPrincipal(userPrincipal);
        String oldClientId = userInfo.addClientId(clientId, this.maxClientsPerUser);
        if (oldClientId != null) {
            this.clientidToUserinfo.remove(oldClientId);
        }
        this.clientidToUserinfo.put(clientId, userInfo);
        return validUser;
    }

    private boolean checkLogin(AbstractKeycloakLoginModule loginModule, UserData userData, String clientId) {
        try {
            LOGGER.debug("Login for user {} ({})", (Object)userData.userName, (Object)clientId);
            Subject subject = new Subject();
            loginModule.initialize(subject, callbacks -> {
                ((NameCallback)callbacks[0]).setName(userData.userName);
                ((PasswordCallback)callbacks[1]).setPassword(userData.userPass.toCharArray());
            }, SHARED_STATE, OPTIONS);
            boolean login = loginModule.login();
            if (login) {
                loginModule.commit();
                Client client = new Client(userData.userName);
                client.setLastSeen(Instant.now());
                client.setSubject(subject);
                CLIENTMAP.put(clientId, client);
                client.getSubject().getPrincipals().stream().forEach(t -> userData.roles.add(t.getName()));
                if (this.registerUserLocally) {
                    this.databaseHandler.enureUserInUsertable(userData.userName);
                }
            }
            return login;
        }
        catch (LoginException ex) {
            LOGGER.error("Login failed with exception: {}", (Object)ex.getMessage());
            LOGGER.debug("Exception:", (Throwable)ex);
            return false;
        }
    }

    public boolean userHasRole(String clientId, String userName, String roleName) {
        Client client = CLIENTMAP.get(clientId);
        if (client == null) {
            return false;
        }
        client.setLastSeen(Instant.now());
        boolean hasRole = client.getSubject().getPrincipals().stream().anyMatch(p -> p.getName().equalsIgnoreCase(roleName));
        LOGGER.trace("User {} has role {}: {}", new Object[]{userName, roleName, hasRole});
        return hasRole;
    }

    public PrincipalExtended getUserPrincipal(String clientId) {
        UserClientInfo userInfo = this.clientidToUserinfo.get(clientId);
        if (userInfo == null) {
            return PrincipalExtended.ANONYMOUS_PRINCIPAL;
        }
        return userInfo.getUserPrincipal();
    }

    public String checkForUpgrades() {
        return "";
    }

    public boolean doUpgrades(Writer out) throws UpgradeFailedException, IOException {
        return true;
    }

    private void clientMapCleanup() {
        try {
            Instant cutoff = Instant.now();
            cutoff = cutoff.plus(-24L, ChronoUnit.HOURS);
            LOGGER.debug("Cleaning up client map... Current size: {}.", (Object)CLIENTMAP.size());
            Iterator<Map.Entry<String, Client>> i = CLIENTMAP.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Client> entry = i.next();
                if (!entry.getValue().getLastSeen().isBefore(cutoff)) continue;
                i.remove();
            }
            LOGGER.debug("Done cleaning up client map. Current size: {}.", (Object)CLIENTMAP.size());
        }
        catch (Exception e) {
            LOGGER.warn("Exception while cleaning up client map.", (Throwable)e);
        }
    }

    private class Client {
        public final String userName;
        private Instant lastSeen;
        private Subject subject;

        public Client(String userName) {
            this.userName = userName;
        }

        public Instant getLastSeen() {
            return this.lastSeen;
        }

        public void setLastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public void setSubject(Subject subject) {
            this.subject = subject;
        }
    }
}

