/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.auth.keycloak;

import de.fraunhofer.iosb.ilt.frostserver.auth.keycloak.KeycloakAuthProvider;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.ConnectionUtils;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record1;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseHandler.class);
    private static final Map<CoreSettings, DatabaseHandler> INSTANCES = new HashMap<CoreSettings, DatabaseHandler>();
    private final Settings authSettings;
    private final String connectionUrl;
    private final String userTable;
    private final String usernameColumn;

    public static void init(CoreSettings coreSettings) {
        if (INSTANCES.get(coreSettings) == null) {
            DatabaseHandler.createInstance(coreSettings);
        }
    }

    private static synchronized DatabaseHandler createInstance(CoreSettings coreSettings) {
        return INSTANCES.computeIfAbsent(coreSettings, s -> {
            LOGGER.info("Initialising DatabaseHandler.");
            return new DatabaseHandler(coreSettings);
        });
    }

    public static DatabaseHandler getInstance(CoreSettings coreSettings) {
        DatabaseHandler instance = INSTANCES.get(coreSettings);
        if (instance == null) {
            LOGGER.error("DatabaseHandler not initialised.");
        }
        return instance;
    }

    private DatabaseHandler(CoreSettings coreSettings) {
        this.authSettings = coreSettings.getAuthSettings();
        this.connectionUrl = this.authSettings.get("db.url", ConnectionUtils.class, false);
        this.userTable = this.authSettings.get("userTable", KeycloakAuthProvider.class);
        this.usernameColumn = this.authSettings.get("usernameColumn", KeycloakAuthProvider.class);
    }

    public void enureUserInUsertable(String username) {
        try (ConnectionUtils.ConnectionWrapper connectionProvider = new ConnectionUtils.ConnectionWrapper(this.authSettings, this.connectionUrl);){
            DSLContext dslContext = DSL.using((Connection)connectionProvider.get(), (SQLDialect)SQLDialect.POSTGRES);
            Field usernameField = DSL.field((Name)DSL.name((String)this.usernameColumn), String.class);
            Table table = DSL.table((Name)DSL.name((String)this.userTable));
            long count = ((Integer)((Record1)dslContext.selectCount().from((TableLike)table).where(usernameField.eq((Object)username)).fetchOne()).component1()).intValue();
            if (count == 0L) {
                dslContext.insertInto(table).set(usernameField, (Object)username).execute();
                connectionProvider.commit();
            }
        }
        catch (RuntimeException | SQLException exc) {
            LOGGER.error("Failed to register user locally.", (Throwable)exc);
        }
    }
}

