/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.auth.keycloak;

import de.fraunhofer.iosb.ilt.frostserver.auth.keycloak.BearerTokenLoginModuleFrost;
import de.fraunhofer.iosb.ilt.frostserver.auth.keycloak.DirectAccessGrantsLoginModuleFrost;
import de.fraunhofer.iosb.ilt.frostserver.auth.keycloak.KeycloakFilterHelper;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.frostserver.util.AuthProvider;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUser;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.UpgradeFailedException;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import org.keycloak.adapters.jaas.AbstractKeycloakLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakAuthProvider
implements AuthProvider,
LiquibaseUser,
ConfigDefaults {
    @DefaultValue(value="")
    public static final String TAG_KEYCLOAK_CONFIG = "keycloakConfig";
    @DefaultValue(value="")
    public static final String TAG_KEYCLOAK_CONFIG_FILE = "keycloakConfigFile";
    @DefaultValue(value="")
    public static final String TAG_KEYCLOAK_CONFIG_URL = "keycloakConfigUrl";
    @DefaultValue(value="")
    public static final String TAG_KEYCLOAK_CONFIG_SECRET = "keycloakConfigSecret";
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakAuthProvider.class);
    private static final String FROST_SERVER_KEYCLOAKJSON = "FROST-Server-Keycloak.json";
    private static final int CUTOFF_HOURS = 24;
    private CoreSettings coreSettings;
    private static final Map<String, Client> CLIENTMAP = new ConcurrentHashMap<String, Client>();
    private static final Map<String, Object> SHARED_STATE = new ConcurrentHashMap<String, Object>();
    private static final Map<String, Object> OPTIONS = new HashMap<String, Object>();

    public void init(CoreSettings coreSettings) {
        this.coreSettings = coreSettings;
        OPTIONS.put("keycloak-config-file", FROST_SERVER_KEYCLOAKJSON);
    }

    public void addFilter(Object context, CoreSettings coreSettings) {
        KeycloakFilterHelper.createFilters(context, coreSettings);
    }

    public boolean isValidUser(String clientId, String username, String password) {
        Object loginModule;
        if (password.length() > 50) {
            LOGGER.debug("Using BearerTokenLoginModule...");
            loginModule = new BearerTokenLoginModuleFrost(this.coreSettings);
        } else {
            LOGGER.debug("Using DirectAccessGrantsLoginModule...");
            loginModule = new DirectAccessGrantsLoginModuleFrost(this.coreSettings);
        }
        this.clientMapCleanup();
        return this.checkLogin((AbstractKeycloakLoginModule)loginModule, username, password, clientId);
    }

    private boolean checkLogin(AbstractKeycloakLoginModule loginModule, String username, String password, String clientId) {
        try {
            LOGGER.debug("Login for user {} ({})", (Object)username, (Object)clientId);
            Subject subject = new Subject();
            loginModule.initialize(subject, callbacks -> {
                ((NameCallback)callbacks[0]).setName(username);
                ((PasswordCallback)callbacks[1]).setPassword(password.toCharArray());
            }, SHARED_STATE, OPTIONS);
            boolean login = loginModule.login();
            if (login) {
                loginModule.commit();
                Client client = new Client(username);
                client.setLastSeen(Instant.now());
                client.setSubject(subject);
                CLIENTMAP.put(clientId, client);
            }
            return login;
        }
        catch (LoginException ex) {
            LOGGER.error("Login failed with exception: {}", (Object)ex.getMessage());
            LOGGER.debug("Exception:", (Throwable)ex);
            return false;
        }
    }

    public boolean userHasRole(String clientId, String userName, String roleName) {
        Client client = CLIENTMAP.get(clientId);
        if (client == null) {
            return false;
        }
        client.setLastSeen(Instant.now());
        boolean hasRole = client.getSubject().getPrincipals().stream().anyMatch(p -> p.getName().equalsIgnoreCase(roleName));
        LOGGER.trace("User {} has role {}: {}", new Object[]{userName, roleName, hasRole});
        return hasRole;
    }

    public String checkForUpgrades() {
        return "";
    }

    public boolean doUpgrades(Writer out) throws UpgradeFailedException, IOException {
        return true;
    }

    private void clientMapCleanup() {
        try {
            Instant cutoff = Instant.now();
            cutoff = cutoff.plus(-24L, ChronoUnit.HOURS);
            LOGGER.debug("Cleaning up client map... Current size: {}.", (Object)CLIENTMAP.size());
            Iterator<Map.Entry<String, Client>> i = CLIENTMAP.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Client> entry = i.next();
                if (!entry.getValue().getLastSeen().isBefore(cutoff)) continue;
                i.remove();
            }
            LOGGER.debug("Done cleaning up client map. Current size: {}.", (Object)CLIENTMAP.size());
        }
        catch (Exception e) {
            LOGGER.warn("Exception while cleaning up client map.", (Throwable)e);
        }
    }

    private class Client {
        public final String userName;
        private Instant lastSeen;
        private Subject subject;

        public Client(String userName) {
            this.userName = userName;
        }

        public Instant getLastSeen() {
            return this.lastSeen;
        }

        public void setLastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public void setSubject(Subject subject) {
            this.subject = subject;
        }
    }
}

