/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.auth.basic;

import de.fraunhofer.iosb.ilt.frostserver.auth.basic.BasicAuthFilter;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.util.AuthUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;

public class BasicAuthFilterHelper {
    private BasicAuthFilterHelper() {
    }

    public static void createFilters(Object context, CoreSettings coreSettings) {
        if (!(context instanceof ServletContext)) {
            throw new IllegalArgumentException("Context must be a ServletContext to add Filters.");
        }
        ServletContext servletContext = (ServletContext)context;
        Settings authSettings = coreSettings.getAuthSettings();
        Map roleMapping = AuthUtils.loadRoleMapping((Settings)authSettings);
        String filterClass = BasicAuthFilter.class.getName();
        Map versions = coreSettings.getPluginManager().getVersions();
        ArrayList<CallSite> urlPatterns = new ArrayList<CallSite>();
        for (Version version : versions.values()) {
            urlPatterns.add((CallSite)((Object)("/" + version.urlPart)));
            urlPatterns.add((CallSite)((Object)("/" + version.urlPart + "/*")));
        }
        String filterName = "AuthFilterSta";
        FilterRegistration.Dynamic authFilterSta = servletContext.addFilter(filterName, filterClass);
        boolean anonRead = authSettings.getBoolean("allowAnonymousRead", CoreSettings.class);
        authFilterSta.setInitParameter("allowAnonymousRead", anonRead ? "T" : "F");
        authFilterSta.setInitParameter("roleGet", (String)roleMapping.get(AuthUtils.Role.READ));
        authFilterSta.setInitParameter("rolePatch", (String)roleMapping.get(AuthUtils.Role.UPDATE));
        authFilterSta.setInitParameter("rolePost", (String)roleMapping.get(AuthUtils.Role.CREATE));
        authFilterSta.setInitParameter("rolePut", (String)roleMapping.get(AuthUtils.Role.UPDATE));
        authFilterSta.setInitParameter("roleDelete", (String)roleMapping.get(AuthUtils.Role.DELETE));
        authFilterSta.setInitParameter("roleAdmin", (String)roleMapping.get(AuthUtils.Role.ADMIN));
        authFilterSta.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), true, (String[])urlPatterns.toArray(String[]::new));
        filterName = "AuthFilterAdmin";
        FilterRegistration.Dynamic authFilterAdmin = servletContext.addFilter(filterName, filterClass);
        authFilterSta.setInitParameter("allowAnonymousRead", "F");
        String adminRoleString = (String)roleMapping.get(AuthUtils.Role.ADMIN);
        authFilterAdmin.setInitParameter("roleGet", adminRoleString);
        authFilterAdmin.setInitParameter("rolePatch", adminRoleString);
        authFilterAdmin.setInitParameter("rolePost", adminRoleString);
        authFilterAdmin.setInitParameter("rolePut", adminRoleString);
        authFilterAdmin.setInitParameter("roleDelete", adminRoleString);
        authFilterAdmin.setInitParameter("roleAdmin", (String)roleMapping.get(AuthUtils.Role.ADMIN));
        authFilterAdmin.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), true, new String[]{"/DatabaseStatus"});
    }
}

