/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.auth.basic;

import de.fraunhofer.iosb.ilt.frostserver.auth.basic.BasicAuthProvider;
import de.fraunhofer.iosb.ilt.frostserver.auth.basic.DatabaseHandler;
import de.fraunhofer.iosb.ilt.frostserver.auth.basic.RequestWrapper;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigUtils;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import de.fraunhofer.iosb.ilt.frostserver.util.PrincipalExtended;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.IOException;
import java.security.Principal;
import java.util.Base64;
import java.util.EnumMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicAuthFilter.class);
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String AUTHORIZATION_REQUIRED_HEADER = "WWW-Authenticate";
    private static final String BASIC_PREFIX = "Basic ";
    private final Map<HttpMethod, AuthChecker> methodCheckers = new EnumMap<HttpMethod, AuthChecker>(HttpMethod.class);
    private DatabaseHandler databaseHandler;
    private String authHeaderValue;
    private String roleAdmin;

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.info("Turning on Basic authentication.");
        this.roleAdmin = BasicAuthFilter.getInitParamWithDefault(filterConfig, "roleAdmin", BasicAuthProvider.class);
        String roleGet = BasicAuthFilter.getInitParamWithDefault(filterConfig, "roleGet", BasicAuthProvider.class);
        String rolePost = BasicAuthFilter.getInitParamWithDefault(filterConfig, "rolePost", BasicAuthProvider.class);
        String rolePatch = BasicAuthFilter.getInitParamWithDefault(filterConfig, "rolePatch", BasicAuthProvider.class);
        String rolePut = BasicAuthFilter.getInitParamWithDefault(filterConfig, "rolePut", BasicAuthProvider.class);
        String roleDelete = BasicAuthFilter.getInitParamWithDefault(filterConfig, "roleDelete", BasicAuthProvider.class);
        String anonRead = BasicAuthFilter.getInitParamWithDefault(filterConfig, "allowAnonymousRead", "F");
        ServletContext context = filterConfig.getServletContext();
        Object attribute = context.getAttribute("CoreSettings");
        if (!(attribute instanceof CoreSettings)) {
            throw new IllegalArgumentException("Could not load core settings.");
        }
        CoreSettings coreSettings = (CoreSettings)attribute;
        Settings authSettings = coreSettings.getAuthSettings();
        this.databaseHandler = DatabaseHandler.getInstance();
        String realmName = authSettings.get("realmName", BasicAuthProvider.class);
        this.authHeaderValue = "Basic realm=\"" + realmName + "\", charset=\"UTF-8\"";
        AuthChecker allAllowed = (userData, response) -> true;
        this.methodCheckers.put(HttpMethod.OPTIONS, allAllowed);
        this.methodCheckers.put(HttpMethod.HEAD, allAllowed);
        if ("T".equals(anonRead)) {
            this.methodCheckers.put(HttpMethod.GET, allAllowed);
        } else {
            this.methodCheckers.put(HttpMethod.GET, (userData, response) -> this.requireRole(roleGet, userData, response));
        }
        this.methodCheckers.put(HttpMethod.POST, (userData, response) -> this.requireRole(rolePost, userData, response));
        this.methodCheckers.put(HttpMethod.PATCH, (userData, response) -> this.requireRole(rolePatch, userData, response));
        this.methodCheckers.put(HttpMethod.PUT, (userData, response) -> this.requireRole(rolePut, userData, response));
        this.methodCheckers.put(HttpMethod.DELETE, (userData, response) -> this.requireRole(roleDelete, userData, response));
    }

    private UserNamePass findCredentials(HttpServletRequest request) {
        String authHeader = request.getHeader(AUTHORIZATION_HEADER);
        if (authHeader == null || !authHeader.startsWith(BASIC_PREFIX)) {
            LOGGER.debug("No basic auth header.");
            return new UserNamePass(null, null);
        }
        String userPassBase64 = authHeader.substring(BASIC_PREFIX.length());
        String userPassDecoded = new String(Base64.getDecoder().decode(userPassBase64), StringHelper.UTF8);
        if (!userPassDecoded.contains(":")) {
            LOGGER.debug("No username:password in basic auth header.");
            return new UserNamePass(null, null);
        }
        String[] split = userPassDecoded.split(":", 2);
        UserNamePass userData = new UserNamePass(split[0], split[1]);
        if (this.databaseHandler.isValidUser(userData.userName, userData.userPass)) {
            return userData;
        }
        return new UserNamePass(null, null);
    }

    private boolean requireRole(String roleName, UserNamePass userData, HttpServletResponse response) {
        if (userData.isEmpty()) {
            LOGGER.debug("Rejecting request: No user data.");
            this.throwAuthRequired(response);
            return false;
        }
        if (!this.databaseHandler.userHasRole(userData.userName, roleName)) {
            LOGGER.debug("Rejecting request: User {} does not have role {}.", (Object)userData.userName, (Object)roleName);
            this.throwAuthRequired(response);
            return false;
        }
        LOGGER.debug("Accepting request: User {} has role {}.", (Object)userData.userName, (Object)roleName);
        return true;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpMethod method;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        try {
            method = HttpMethod.valueOf((String)request.getMethod().toUpperCase());
        }
        catch (IllegalArgumentException exc) {
            LOGGER.debug("Rejecting request: Unknown method: {}.", (Object)request.getMethod());
            LOGGER.trace("", (Throwable)exc);
            this.throwAuthRequired(response);
            return;
        }
        UserNamePass userData = this.findCredentials(request);
        AuthChecker checker = this.methodCheckers.get(method);
        if (checker == null) {
            LOGGER.debug("Rejecting request: No checker for method: {}.", (Object)request.getMethod());
            this.throwAuthRequired(response);
            return;
        }
        if (checker.isAllowed(userData, response)) {
            boolean admin = this.databaseHandler.userHasRole(userData.userName, this.roleAdmin);
            if (admin) {
                chain.doFilter((ServletRequest)new RequestWrapper(request, (Principal)new PrincipalExtended(userData.userName, admin)), (ServletResponse)response);
            } else {
                chain.doFilter((ServletRequest)new RequestWrapper(request, userData::getUserName), (ServletResponse)response);
            }
        }
    }

    public void destroy() {
    }

    private void throwAuthRequired(HttpServletResponse response) {
        response.addHeader(AUTHORIZATION_REQUIRED_HEADER, this.authHeaderValue);
        try {
            response.sendError(401);
        }
        catch (IOException exc) {
            LOGGER.error("Exception sending back error.", (Throwable)exc);
        }
    }

    private static String getInitParamWithDefault(FilterConfig filterConfig, String paramName, Class<? extends ConfigDefaults> defaultsProvider) {
        return BasicAuthFilter.getInitParamWithDefault(filterConfig, paramName, ConfigUtils.getDefaultValue(defaultsProvider, (String)paramName));
    }

    private static String getInitParamWithDefault(FilterConfig filterConfig, String paramName, String defValue) {
        String value = filterConfig.getInitParameter(paramName);
        if (value == null) {
            LOGGER.info("Filter setting {}, using default value: {}", (Object)paramName, (Object)defValue);
            return defValue;
        }
        LOGGER.info("Filter setting {}, set to value: {}", (Object)paramName, (Object)value);
        return value;
    }

    private static class UserNamePass {
        public final String userName;
        public final String userPass;

        public UserNamePass(String userName, String userPass) {
            this.userName = userName;
            this.userPass = userPass;
        }

        public String getUserName() {
            return this.userName;
        }

        public boolean isEmpty() {
            return this.userName == null;
        }
    }

    private static interface AuthChecker {
        public boolean isAllowed(UserNamePass var1, HttpServletResponse var2);
    }
}

