/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.auth.basic;

import de.fraunhofer.iosb.ilt.frostserver.auth.basic.BasicAuthFilterHelper;
import de.fraunhofer.iosb.ilt.frostserver.auth.basic.DatabaseHandler;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueBoolean;
import de.fraunhofer.iosb.ilt.frostserver.util.AuthProvider;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUser;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.UpgradeFailedException;
import java.io.IOException;
import java.io.Writer;

public class BasicAuthProvider
implements AuthProvider,
LiquibaseUser,
ConfigDefaults {
    public static final String LIQUIBASE_CHANGELOG_FILENAME = "liquibase/basicAuthTables.xml";
    @DefaultValueBoolean(value=false)
    public static final String TAG_AUTO_UPDATE_DATABASE = "autoUpdateDatabase";
    @DefaultValue(value="FROST-Server")
    public static final String TAG_AUTH_REALM_NAME = "realmName";
    @DefaultValue(value="read")
    public static final String TAG_ROLE_GET = "roleGet";
    @DefaultValue(value="update")
    public static final String TAG_ROLE_PATCH = "rolePatch";
    @DefaultValue(value="create")
    public static final String TAG_ROLE_POST = "rolePost";
    @DefaultValue(value="update")
    public static final String TAG_ROLE_PUT = "rolePut";
    @DefaultValue(value="delete")
    public static final String TAG_ROLE_DELETE = "roleDelete";
    @DefaultValue(value="admin")
    public static final String TAG_ROLE_ADMIN = "roleAdmin";

    public void init(CoreSettings coreSettings) {
        DatabaseHandler.init(coreSettings);
    }

    public void addFilter(Object context, CoreSettings coreSettings) {
        BasicAuthFilterHelper.createFilters(context, coreSettings);
    }

    public boolean isValidUser(String clientId, String userName, String password) {
        return DatabaseHandler.getInstance().isValidUser(userName, password);
    }

    public boolean userHasRole(String clientId, String userName, String roleName) {
        return DatabaseHandler.getInstance().userHasRole(userName, roleName);
    }

    public String checkForUpgrades() {
        return DatabaseHandler.getInstance().checkForUpgrades();
    }

    public boolean doUpgrades(Writer out) throws UpgradeFailedException, IOException {
        return DatabaseHandler.getInstance().doUpgrades(out);
    }
}

