/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.auth.basic;

import de.fraunhofer.iosb.ilt.frostserver.auth.basic.BasicAuthProvider;
import de.fraunhofer.iosb.ilt.frostserver.auth.basic.TableUsers;
import de.fraunhofer.iosb.ilt.frostserver.auth.basic.TableUsersRoles;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.ConnectionUtils;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.LiquibaseHelper;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUser;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUtils;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.UpgradeFailedException;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import org.jooq.DSLContext;
import org.jooq.Record1;
import org.jooq.SQLDialect;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseHandler.class);
    private static final String CONNECTION_NAME = "FROST-Auth";
    private static DatabaseHandler instance;
    private final CoreSettings coreSettings;
    private final Settings authSettings;
    private boolean maybeUpdateDatabase;

    public static void init(CoreSettings coreSettings) {
        if (instance == null) {
            DatabaseHandler.createInstance(coreSettings);
        }
    }

    private static synchronized void createInstance(CoreSettings coreSettings) {
        if (instance == null) {
            LOGGER.info("Initialising DatabaseHandler.");
            instance = new DatabaseHandler(coreSettings);
        }
    }

    public static DatabaseHandler getInstance() {
        if (instance == null) {
            LOGGER.error("DatabaseHandler not initialised.");
        }
        return instance;
    }

    private DatabaseHandler(CoreSettings coreSettings) {
        this.coreSettings = coreSettings;
        this.authSettings = coreSettings.getAuthSettings();
        this.maybeUpdateDatabase = this.authSettings.getBoolean("autoUpdateDatabase", BasicAuthProvider.class);
    }

    public boolean isValidUser(String userName, String password) {
        boolean bl;
        this.maybeUpdateDatabase();
        ConnectionUtils.ConnectionWrapper connectionProvider = new ConnectionUtils.ConnectionWrapper(this.authSettings, CONNECTION_NAME);
        try {
            DSLContext dslContext = DSL.using((Connection)connectionProvider.get(), (SQLDialect)SQLDialect.POSTGRES);
            Record1 one = (Record1)dslContext.selectOne().from((TableLike)TableUsers.USERS).where(TableUsers.USERS.userName.eq((Object)userName).and(TableUsers.USERS.userPass.eq((Object)password))).fetchOne();
            bl = one != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connectionProvider.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (RuntimeException | SQLException exc) {
                LOGGER.error("Failed to check user credentials.", (Throwable)exc);
                return false;
            }
        }
        connectionProvider.close();
        return bl;
    }

    public boolean userHasRole(String userName, String userPass, String roleName) {
        boolean bl;
        this.maybeUpdateDatabase();
        ConnectionUtils.ConnectionWrapper connectionProvider = new ConnectionUtils.ConnectionWrapper(this.authSettings, CONNECTION_NAME);
        try {
            DSLContext dslContext = DSL.using((Connection)connectionProvider.get(), (SQLDialect)SQLDialect.POSTGRES);
            Record1 one = (Record1)dslContext.selectOne().from((TableLike)TableUsers.USERS).leftJoin((TableLike)TableUsersRoles.USER_ROLES).on(TableUsers.USERS.userName.eq(TableUsersRoles.USER_ROLES.userName)).where(TableUsers.USERS.userName.eq((Object)userName).and(TableUsers.USERS.userPass.eq((Object)userPass)).and(TableUsersRoles.USER_ROLES.roleName.eq((Object)roleName))).fetchOne();
            bl = one != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connectionProvider.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (RuntimeException | SQLException exc) {
                LOGGER.error("Failed to check user rights.", (Throwable)exc);
                return false;
            }
        }
        connectionProvider.close();
        return bl;
    }

    public boolean userHasRole(String userName, String roleName) {
        boolean bl;
        if (userName == null) {
            return false;
        }
        this.maybeUpdateDatabase();
        ConnectionUtils.ConnectionWrapper connectionProvider = new ConnectionUtils.ConnectionWrapper(this.authSettings, CONNECTION_NAME);
        try {
            DSLContext dslContext = DSL.using((Connection)connectionProvider.get(), (SQLDialect)SQLDialect.POSTGRES);
            Record1 one = (Record1)dslContext.selectOne().from((TableLike)TableUsersRoles.USER_ROLES).where(TableUsersRoles.USER_ROLES.userName.eq((Object)userName).and(TableUsersRoles.USER_ROLES.roleName.eq((Object)roleName))).fetchOne();
            bl = one != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connectionProvider.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (RuntimeException | SQLException exc) {
                LOGGER.error("Failed to check user rights.", (Throwable)exc);
                return false;
            }
        }
        connectionProvider.close();
        return bl;
    }

    private void maybeUpdateDatabase() {
        if (this.maybeUpdateDatabase) {
            BasicAuthProvider basicAuthProvider = new BasicAuthProvider();
            basicAuthProvider.init(this.coreSettings);
            this.maybeUpdateDatabase = LiquibaseUtils.maybeUpdateDatabase((Logger)LOGGER, (LiquibaseUser)basicAuthProvider);
        }
    }

    public String checkForUpgrades() {
        String string;
        block8: {
            Settings customSettings = this.coreSettings.getAuthSettings();
            Connection connection = ConnectionUtils.getConnection((String)"FROST-BasicAuth", (Settings)customSettings);
            try {
                string = LiquibaseHelper.checkForUpgrades((Connection)connection, (String)"liquibase/basicAuthTables.xml", Collections.emptyMap());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOGGER.error("Could not initialise database.", (Throwable)ex);
                    return "Failed to initialise database:\n" + ex.getLocalizedMessage() + "\n";
                }
            }
            connection.close();
        }
        return string;
    }

    public boolean doUpgrades(Writer out) throws UpgradeFailedException, IOException {
        boolean bl;
        block8: {
            Settings customSettings = this.coreSettings.getAuthSettings();
            Connection connection = ConnectionUtils.getConnection((String)"FROST-BasicAuth", (Settings)customSettings);
            try {
                bl = LiquibaseHelper.doUpgrades((Connection)connection, (String)"liquibase/basicAuthTables.xml", Collections.emptyMap(), (Writer)out);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOGGER.error("Could not initialise database.", (Throwable)ex);
                    out.append("Failed to initialise database:\n");
                    out.append(ex.getLocalizedMessage());
                    out.append("\n");
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }
}

