/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.auth.basic;

import de.fraunhofer.iosb.ilt.frostserver.auth.basic.BasicAuthProvider;
import de.fraunhofer.iosb.ilt.frostserver.auth.basic.DatabaseHandler;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigUtils;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.IOException;
import java.util.Base64;
import java.util.EnumMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicAuthFilter.class);
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String AUTHORIZATION_REQUIRED_HEADER = "WWW-Authenticate";
    private static final String BASIC_PREFIX = "Basic ";
    private final Map<HttpMethod, AuthChecker> methodCheckers = new EnumMap<HttpMethod, AuthChecker>(HttpMethod.class);
    private DatabaseHandler databaseHandler;
    private String authHeaderValue;

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.info("Turning on Basic authentication.");
        String roleGet = BasicAuthFilter.getInitParamWithDefault(filterConfig, "roleGet", BasicAuthProvider.class);
        String rolePost = BasicAuthFilter.getInitParamWithDefault(filterConfig, "rolePost", BasicAuthProvider.class);
        String rolePatch = BasicAuthFilter.getInitParamWithDefault(filterConfig, "rolePatch", BasicAuthProvider.class);
        String rolePut = BasicAuthFilter.getInitParamWithDefault(filterConfig, "rolePut", BasicAuthProvider.class);
        String roleDelete = BasicAuthFilter.getInitParamWithDefault(filterConfig, "roleDelete", BasicAuthProvider.class);
        String anonRead = BasicAuthFilter.getInitParamWithDefault(filterConfig, "allowAnonymousRead", "F");
        ServletContext context = filterConfig.getServletContext();
        Object attribute = context.getAttribute("CoreSettings");
        if (!(attribute instanceof CoreSettings)) {
            throw new IllegalArgumentException("Could not load core settings.");
        }
        CoreSettings coreSettings = (CoreSettings)attribute;
        Settings authSettings = coreSettings.getAuthSettings();
        this.databaseHandler = DatabaseHandler.getInstance();
        String realmName = authSettings.get("realmName", BasicAuthProvider.class);
        this.authHeaderValue = "Basic realm=\"" + realmName + "\", charset=\"UTF-8\"";
        AuthChecker allAllowed = (request, response) -> true;
        this.methodCheckers.put(HttpMethod.OPTIONS, allAllowed);
        this.methodCheckers.put(HttpMethod.HEAD, allAllowed);
        if ("T".equals(anonRead)) {
            this.methodCheckers.put(HttpMethod.GET, allAllowed);
        } else {
            this.methodCheckers.put(HttpMethod.GET, (request, response) -> this.requireRole(roleGet, request, response));
        }
        this.methodCheckers.put(HttpMethod.POST, (request, response) -> this.requireRole(rolePost, request, response));
        this.methodCheckers.put(HttpMethod.PATCH, (request, response) -> this.requireRole(rolePatch, request, response));
        this.methodCheckers.put(HttpMethod.PUT, (request, response) -> this.requireRole(rolePut, request, response));
        this.methodCheckers.put(HttpMethod.DELETE, (request, response) -> this.requireRole(roleDelete, request, response));
    }

    private boolean requireRole(String roleName, HttpServletRequest request, HttpServletResponse response) {
        String userPass;
        String authHeader = request.getHeader(AUTHORIZATION_HEADER);
        if (authHeader == null || !authHeader.startsWith(BASIC_PREFIX)) {
            LOGGER.debug("Rejecting request: no basic auth header.");
            this.throwAuthRequired(response);
            return false;
        }
        String userPassBase64 = authHeader.substring(BASIC_PREFIX.length());
        String userPassDecoded = new String(Base64.getDecoder().decode(userPassBase64), StringHelper.UTF8);
        if (!userPassDecoded.contains(":")) {
            LOGGER.debug("Rejecting request: no username:password in basic auth header.");
            this.throwAuthRequired(response);
            return false;
        }
        String[] split = userPassDecoded.split(":", 2);
        String userName = split[0];
        if (!this.databaseHandler.userHasRole(userName, userPass = split[1], roleName)) {
            LOGGER.debug("Rejecting request: User {} does not have role {}.", (Object)userName, (Object)roleName);
            this.throwAuthRequired(response);
            return false;
        }
        LOGGER.debug("Accepting request: User {} has role {}.", (Object)userName, (Object)roleName);
        return true;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpMethod method;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        try {
            method = HttpMethod.valueOf((String)request.getMethod().toUpperCase());
        }
        catch (IllegalArgumentException exc) {
            LOGGER.debug("Rejecting request: Unknown method: {}.", (Object)request.getMethod());
            LOGGER.trace("", (Throwable)exc);
            this.throwAuthRequired(response);
            return;
        }
        AuthChecker checker = this.methodCheckers.get(method);
        if (checker == null) {
            LOGGER.debug("Rejecting request: No checker for method: {}.", (Object)request.getMethod());
            this.throwAuthRequired(response);
            return;
        }
        if (checker.isAllowed(request, response)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }

    private void throwAuthRequired(HttpServletResponse response) {
        response.addHeader(AUTHORIZATION_REQUIRED_HEADER, this.authHeaderValue);
        try {
            response.sendError(401);
        }
        catch (IOException exc) {
            LOGGER.error("Exception sending back error.", (Throwable)exc);
        }
    }

    private static String getInitParamWithDefault(FilterConfig filterConfig, String paramName, Class<? extends ConfigDefaults> defaultsProvider) {
        return BasicAuthFilter.getInitParamWithDefault(filterConfig, paramName, ConfigUtils.getDefaultValue(defaultsProvider, (String)paramName));
    }

    private static String getInitParamWithDefault(FilterConfig filterConfig, String paramName, String defValue) {
        String value = filterConfig.getInitParameter(paramName);
        if (value == null) {
            LOGGER.info("Filter setting {}, using default value: {}", (Object)paramName, (Object)defValue);
            return defValue;
        }
        LOGGER.info("Filter setting {}, set to value: {}", (Object)paramName, (Object)value);
        return value;
    }

    private static interface AuthChecker {
        public boolean isAllowed(HttpServletRequest var1, HttpServletResponse var2);
    }
}

