/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.utils;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.StatusCodeException;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.TextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static void showAlert(Alert.AlertType type, String title, String text, Throwable exception) {
        Alert alert = new Alert(type);
        alert.setTitle(title);
        alert.setContentText(text);
        if (exception != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.append(exception.getMessage() + "\n");
            exception.printStackTrace(pw);
            Object exceptionText = sw.toString();
            if (exception instanceof StatusCodeException) {
                StatusCodeException sce = (StatusCodeException)exception;
                exceptionText = "Server Returned:" + sce.getReturnedContent() + "\n\nException:\n" + (String)exceptionText;
            }
            TextArea textArea = new TextArea((String)exceptionText);
            textArea.setEditable(false);
            textArea.setWrapText(false);
            alert.getDialogPane().setExpandableContent((Node)textArea);
        }
        alert.showAndWait();
    }

    public static void deleteAll(SensorThingsService sts) throws ServiceFailureException {
        Utils.deleteAll(sts.things());
        Utils.deleteAll(sts.locations());
        Utils.deleteAll(sts.sensors());
        Utils.deleteAll(sts.featuresOfInterest());
        Utils.deleteAll(sts.observedProperties());
        Utils.deleteAll(sts.observations());
    }

    public static <T extends Entity<T>> void deleteAll(BaseDao<T> doa) throws ServiceFailureException {
        boolean more = true;
        int count = 0;
        while (more) {
            EntityList entities = doa.query().count().list();
            if (entities.getCount() > 0L) {
                LOGGER.info("{} to go.", (Object)entities.getCount());
            } else {
                more = false;
            }
            for (Entity entity : entities) {
                doa.delete(entity);
                ++count;
            }
        }
        LOGGER.info("Deleted {} using {}.", (Object)count, (Object)doa.getClass().getName());
    }
}

