/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.controller.ControllerCollection;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.controller.FactoryEntityPanel;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.utils.ObjectMapperFactory;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.utils.Utils;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.jackson.LocationDeserializer;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.FeatureOfInterest;
import de.fraunhofer.iosb.ilt.sta.model.HistoricalLocation;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.TimeObject;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.sta.query.Query;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.fxml.FXMLLoader;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import org.geojson.GeoJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.extra.Interval;

public interface EntityGuiController<T extends Entity<T>> {
    public static final TypeReference<Map<String, Object>> TYPE_MAP_STRING_OBJECT = new TypeReference<Map<String, Object>>(){};
    public static final TypeReference<List<UnitOfMeasurement>> TYPE_LIST_UOM = new TypeReference<List<UnitOfMeasurement>>(){};

    public void loadFields();

    public void saveFields();

    public EntityType getType();

    public void init(SensorThingsService var1, T var2, GridPane var3, Accordion var4, Label var5, boolean var6);

    public static <C extends Entity<C>, P extends Entity<P>> TitledPane createEditableEntityPane(P parentEntity, C childEntity, Query<C> childQuery, String orderby, ChildSetter<C> setter) throws IOException {
        EntityType type = EntityType.singleForClass((Class)childQuery.getEntityType().getType());
        String paneTitle = childEntity == null ? type.getName() + ": None selected" : childEntity.getType().getName() + ": " + childEntity.toString();
        Node pane = FactoryEntityPanel.getPane(childQuery.getService(), type, childEntity, false);
        TitledPane tp = new TitledPane(paneTitle, pane);
        Button edit = new Button("\ud83d\udd27");
        tp.setGraphic((Node)edit);
        edit.setOnAction(event -> {
            Optional result = EntityGuiController.entitySearchDialog(childQuery, false, orderby);
            if (result.isPresent() && !result.get().isEmpty()) {
                Entity newChild = (Entity)result.get().get(0);
                setter.setChild(newChild);
                try {
                    tp.setContent(FactoryEntityPanel.getPane(childQuery.getService(), type, childEntity, false));
                }
                catch (IOException ex) {
                    LoggerFactory.getLogger(EntityGuiController.class).error("Failed to load Collection Pane.", (Throwable)ex);
                }
                tp.setText(newChild.getType().getName() + ": " + newChild.toString());
            }
        });
        return tp;
    }

    public static <T extends Node> T addFieldTo(GridPane gp, int row, String title, T node, boolean fillHeight, boolean editable) {
        gp.getRowConstraints().add((Object)new RowConstraints(Double.NEGATIVE_INFINITY, -1.0, Double.NEGATIVE_INFINITY, Priority.NEVER, VPos.BASELINE, fillHeight));
        gp.add((Node)new Label(title), 0, row);
        gp.add(node, 1, row);
        if (node instanceof TextArea) {
            ((TextArea)node).setPrefRowCount(4);
        }
        if (node instanceof TextInputControl) {
            ((TextInputControl)node).setEditable(editable);
        } else {
            node.setDisable(!editable);
        }
        return node;
    }

    public static <C extends Entity<C>> Pane createCollectionPaneFor(Query<C> query, String orderBy) {
        return EntityGuiController.createCollectionPaneFor(query, orderBy, false, null);
    }

    public static <C extends Entity<C>> Pane createCollectionPaneFor(Query<C> query, String orderBy, boolean canLinkNew, ChildSetter<C> childSetter) {
        try {
            FXMLLoader loader = new FXMLLoader(EntityGuiController.class.getResource("/fxml/Collection.fxml"));
            AnchorPane content = (AnchorPane)loader.load();
            ControllerCollection controller = (ControllerCollection)loader.getController();
            controller.setQuery(query, true, true, canLinkNew, true, orderBy);
            if (childSetter != null) {
                controller.setChildSetter(childSetter);
            }
            return content;
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(EntityGuiController.class).error("Failed to load Collection Pane.", (Throwable)ex);
            return null;
        }
    }

    public static <T extends Entity<T>> Optional<List<T>> entitySearchDialog(Query<T> query, boolean multiSelect, String orderBy) {
        try {
            FXMLLoader loader = new FXMLLoader(EntityGuiController.class.getResource("/fxml/Collection.fxml"));
            AnchorPane content = (AnchorPane)loader.load();
            ControllerCollection controller = (ControllerCollection)loader.getController();
            controller.setQuery(query, false, false, false, multiSelect, orderBy);
            Dialog dialog = new Dialog();
            dialog.setHeight(800.0);
            if (multiSelect) {
                dialog.setTitle("Choose one or more " + EntityType.singleForClass((Class)query.getEntityType().getType()).getName());
            } else {
                dialog.setTitle("Choose a " + EntityType.singleForClass((Class)query.getEntityType().getType()).getName());
            }
            dialog.setResizable(true);
            dialog.getDialogPane().setContent((Node)content);
            ButtonType buttonTypeOk = new ButtonType("Set", ButtonBar.ButtonData.OK_DONE);
            dialog.getDialogPane().getButtonTypes().add((Object)buttonTypeOk);
            ButtonType buttonTypeCancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
            dialog.getDialogPane().getButtonTypes().add((Object)buttonTypeCancel);
            dialog.setResultConverter(button -> {
                if (button == buttonTypeOk) {
                    if (multiSelect) {
                        return controller.getSelectedEntities();
                    }
                    ArrayList list = new ArrayList();
                    list.add(controller.getSelectedEntity());
                    return list;
                }
                return null;
            });
            return dialog.showAndWait();
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(EntityGuiController.class).error("Failed to load Tab.", (Throwable)ex);
            return Optional.empty();
        }
    }

    public static interface ChildSetter<C extends Entity<C>> {
        public void setChild(C var1);

        default public void setChildren(List<C> children) {
        }
    }

    public static class GuiControllerThing
    implements EntityGuiController<Thing> {
        private static final Logger LOGGER = LoggerFactory.getLogger(GuiControllerThing.class);
        private Label labelId;
        private Thing entity;
        private TextField textName;
        private TextArea textDescription;
        private TextArea textProperties;

        @Override
        public void loadFields() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.getId() != null) {
                this.labelId.setText(this.entity.getId().toString());
            }
            this.textName.setText(this.entity.getName());
            this.textDescription.setText(this.entity.getDescription());
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                Map properties = this.entity.getProperties();
                if (properties != null) {
                    String props = mapper.writeValueAsString((Object)properties);
                    this.textProperties.setText(props);
                }
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Properties can not be converted to JSON.", (Throwable)ex);
            }
        }

        @Override
        public void saveFields() {
            if (!Utils.isNullOrEmpty(this.textName.getText())) {
                this.entity.setName(this.textName.getText());
            }
            if (!Utils.isNullOrEmpty(this.textDescription.getText())) {
                this.entity.setDescription(this.textDescription.getText());
            }
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                String jsonText = this.textProperties.getText();
                if (!jsonText.isEmpty()) {
                    Map properties = (Map)mapper.readValue(jsonText, TYPE_MAP_STRING_OBJECT);
                    this.entity.setProperties(properties);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Not valid json.", (Throwable)ex);
            }
        }

        @Override
        public EntityType getType() {
            return EntityType.THING;
        }

        @Override
        public void init(SensorThingsService service, final Thing entity, GridPane gridProperties, Accordion accordionLinks, Label labelId, boolean editable) {
            this.labelId = labelId;
            this.entity = entity;
            int i = 0;
            this.textName = EntityGuiController.addFieldTo(gridProperties, i, "Name", new TextField(), false, editable);
            this.textDescription = EntityGuiController.addFieldTo(gridProperties, ++i, "Description", new TextArea(), true, editable);
            this.textProperties = EntityGuiController.addFieldTo(gridProperties, ++i, "Properties", new TextArea(), true, editable);
            this.textProperties.setPrefRowCount(10);
            if (accordionLinks != null) {
                try {
                    TitledPane tp = new TitledPane("Datastreams", (Node)EntityGuiController.createCollectionPaneFor(entity.datastreams().query(), "name asc"));
                    accordionLinks.getPanes().add((Object)tp);
                    tp = new TitledPane("MultiDatastreams", (Node)EntityGuiController.createCollectionPaneFor(entity.multiDatastreams().query(), "name asc"));
                    accordionLinks.getPanes().add((Object)tp);
                    ChildSetter<Location> locationChildSetter = new ChildSetter<Location>(){

                        @Override
                        public void setChild(Location child) {
                            throw new UnsupportedOperationException("This setter only deals with multiple childs.");
                        }

                        @Override
                        public void setChildren(List<Location> children) {
                            EntityList locations = entity.getLocations();
                            locations.clear();
                            for (Location child : children) {
                                locations.add((Entity)child.withOnlyId());
                            }
                        }
                    };
                    tp = new TitledPane("Locations", (Node)EntityGuiController.createCollectionPaneFor(entity.locations().query(), "name asc", true, locationChildSetter));
                    accordionLinks.getPanes().add((Object)tp);
                    tp = new TitledPane("HistoricalLocations", (Node)EntityGuiController.createCollectionPaneFor(entity.historicalLocations().query(), "time desc"));
                    accordionLinks.getPanes().add((Object)tp);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public static class GuiControllerSensor
    implements EntityGuiController<Sensor> {
        private static final Logger LOGGER = LoggerFactory.getLogger(GuiControllerThing.class);
        private Label labelId;
        private Sensor entity;
        private TextField textName;
        private TextArea textDescription;
        private TextField textEncodingType;
        private TextArea textMetadata;
        private TextArea textProperties;

        @Override
        public void loadFields() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.getId() != null) {
                this.labelId.setText(this.entity.getId().toString());
            }
            this.textName.setText(this.entity.getName());
            this.textDescription.setText(this.entity.getDescription());
            this.textEncodingType.setText(this.entity.getEncodingType());
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                this.textMetadata.setText(mapper.writeValueAsString(this.entity.getMetadata()));
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Metadata can not be converted to JSON.", (Throwable)ex);
            }
            try {
                if (this.entity.getProperties() != null) {
                    String props = mapper.writeValueAsString((Object)this.entity.getProperties());
                    this.textProperties.setText(props);
                }
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Properties can not be converted to JSON.", (Throwable)ex);
            }
        }

        @Override
        public void saveFields() {
            if (!Utils.isNullOrEmpty(this.textName.getText())) {
                this.entity.setName(this.textName.getText());
            }
            if (!Utils.isNullOrEmpty(this.textDescription.getText())) {
                this.entity.setDescription(this.textDescription.getText());
            }
            if (!Utils.isNullOrEmpty(this.textEncodingType.getText())) {
                this.entity.setEncodingType(this.textEncodingType.getText());
            }
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                JsonNode json = mapper.readTree(this.textMetadata.getText());
                this.entity.setMetadata((Object)json);
            }
            catch (IOException ex) {
                LOGGER.error("Not valid json.", (Throwable)ex);
                this.entity.setMetadata((Object)this.textMetadata.getText());
            }
            try {
                if (!Utils.isNullOrEmpty(this.textProperties.getText())) {
                    Map properties = (Map)mapper.readValue(this.textProperties.getText(), TYPE_MAP_STRING_OBJECT);
                    this.entity.setProperties(properties);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Not valid json.", (Throwable)ex);
            }
        }

        @Override
        public EntityType getType() {
            return EntityType.SENSOR;
        }

        @Override
        public void init(SensorThingsService service, Sensor entity, GridPane gridProperties, Accordion accordionLinks, Label labelId, boolean editable) {
            this.labelId = labelId;
            this.entity = entity;
            int i = 0;
            this.textName = EntityGuiController.addFieldTo(gridProperties, i, "Name", new TextField(), false, editable);
            this.textDescription = EntityGuiController.addFieldTo(gridProperties, ++i, "Description", new TextArea(), true, editable);
            this.textEncodingType = EntityGuiController.addFieldTo(gridProperties, ++i, "EncodingType", new TextField(), false, editable);
            this.textMetadata = EntityGuiController.addFieldTo(gridProperties, ++i, "Metadata", new TextArea(), true, editable);
            this.textProperties = EntityGuiController.addFieldTo(gridProperties, ++i, "Properties", new TextArea(), true, editable);
            if (accordionLinks != null) {
                try {
                    TitledPane tp = new TitledPane("Datastreams", (Node)EntityGuiController.createCollectionPaneFor(entity.datastreams().query(), "name asc"));
                    accordionLinks.getPanes().add((Object)tp);
                    tp = new TitledPane("MultiDatastreams", (Node)EntityGuiController.createCollectionPaneFor(entity.multiDatastreams().query(), "name asc"));
                    accordionLinks.getPanes().add((Object)tp);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public static class GuiControllerObsProp
    implements EntityGuiController<ObservedProperty> {
        private static final Logger LOGGER = LoggerFactory.getLogger(GuiControllerThing.class);
        private Label labelId;
        private ObservedProperty entity;
        private TextField textName;
        private TextField textDefinition;
        private TextArea textDescription;
        private TextArea textProperties;

        @Override
        public void loadFields() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.getId() != null) {
                this.labelId.setText(this.entity.getId().toString());
            }
            this.textName.setText(this.entity.getName());
            this.textDefinition.setText(this.entity.getDefinition());
            this.textDescription.setText(this.entity.getDescription());
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                if (this.entity.getProperties() != null) {
                    String props = mapper.writeValueAsString((Object)this.entity.getProperties());
                    this.textProperties.setText(props);
                }
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Properties can not be converted to JSON.", (Throwable)ex);
            }
        }

        @Override
        public void saveFields() {
            if (!Utils.isNullOrEmpty(this.textName.getText())) {
                this.entity.setName(this.textName.getText());
            }
            if (!Utils.isNullOrEmpty(this.textDefinition.getText())) {
                this.entity.setDefinition(this.textDefinition.getText());
            }
            if (!Utils.isNullOrEmpty(this.textDescription.getText())) {
                this.entity.setDescription(this.textDescription.getText());
            }
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                if (!Utils.isNullOrEmpty(this.textProperties.getText())) {
                    Map properties = (Map)mapper.readValue(this.textProperties.getText(), TYPE_MAP_STRING_OBJECT);
                    this.entity.setProperties(properties);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Not valid json.", (Throwable)ex);
                Utils.showAlert(Alert.AlertType.ERROR, "Failed to update", "Failed to update the entity.", ex);
            }
        }

        @Override
        public EntityType getType() {
            return EntityType.OBSERVED_PROPERTY;
        }

        @Override
        public void init(SensorThingsService service, ObservedProperty entity, GridPane gridProperties, Accordion accordionLinks, Label labelId, boolean editable) {
            this.labelId = labelId;
            this.entity = entity;
            int i = 0;
            this.textName = EntityGuiController.addFieldTo(gridProperties, i, "Name", new TextField(), false, editable);
            this.textDefinition = EntityGuiController.addFieldTo(gridProperties, ++i, "Definition", new TextField(), false, editable);
            this.textDescription = EntityGuiController.addFieldTo(gridProperties, ++i, "Description", new TextArea(), true, editable);
            this.textProperties = EntityGuiController.addFieldTo(gridProperties, ++i, "Properties", new TextArea(), true, editable);
            if (accordionLinks != null) {
                try {
                    TitledPane tp = new TitledPane("Datastreams", (Node)EntityGuiController.createCollectionPaneFor(entity.datastreams().query(), "name asc"));
                    accordionLinks.getPanes().add((Object)tp);
                    tp = new TitledPane("MultiDatastreams", (Node)EntityGuiController.createCollectionPaneFor(entity.multiDatastreams().query(), "name asc"));
                    accordionLinks.getPanes().add((Object)tp);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public static class GuiControllerObservation
    implements EntityGuiController<Observation> {
        private static final Logger LOGGER = LoggerFactory.getLogger(GuiControllerThing.class);
        private Label labelId;
        private Observation entity;
        private TextField textPhenomenonTime;
        private TextField textResultTime;
        private TextArea textResult;
        private TextField textResultQuality;
        private TextField textValidTime;
        private TextArea textParameters;

        @Override
        public void loadFields() {
            String json;
            if (this.entity == null) {
                return;
            }
            if (this.entity.getId() != null) {
                this.labelId.setText(this.entity.getId().toString());
            }
            if (this.entity.getPhenomenonTime() != null) {
                this.textPhenomenonTime.setText(this.entity.getPhenomenonTime().toString());
            }
            if (this.entity.getResultTime() != null) {
                this.textResultTime.setText(this.entity.getResultTime().toString());
            }
            if (this.entity.getValidTime() != null) {
                this.textValidTime.setText(this.entity.getValidTime().toString());
            }
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                if (this.entity.getResult() != null) {
                    json = mapper.writeValueAsString(this.entity.getResult());
                    this.textResult.setText(json);
                }
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Properties can not be converted to JSON.", (Throwable)ex);
            }
            try {
                if (this.entity.getResultQuality() != null) {
                    json = mapper.writeValueAsString(this.entity.getResultQuality());
                    this.textResultQuality.setText(json);
                }
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Properties can not be converted to JSON.", (Throwable)ex);
            }
            try {
                if (this.entity.getParameters() != null) {
                    json = mapper.writeValueAsString((Object)this.entity.getParameters());
                    this.textParameters.setText(json);
                }
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Properties can not be converted to JSON.", (Throwable)ex);
            }
        }

        @Override
        public void saveFields() {
            JsonNode tree;
            if (!this.textPhenomenonTime.getText().isEmpty()) {
                this.entity.setPhenomenonTime(TimeObject.parse((String)this.textPhenomenonTime.getText()));
            }
            if (!this.textResultTime.getText().isEmpty()) {
                this.entity.setResultTime(ZonedDateTime.parse(this.textResultTime.getText()));
            }
            if (!this.textValidTime.getText().isEmpty()) {
                this.entity.setValidTime(Interval.parse((CharSequence)this.textValidTime.getText()));
            }
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                if (!Utils.isNullOrEmpty(this.textResult.getText())) {
                    tree = mapper.readTree(this.textResult.getText());
                    this.entity.setResult((Object)tree);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Not valid json.", (Throwable)ex);
            }
            try {
                if (!Utils.isNullOrEmpty(this.textResultQuality.getText())) {
                    tree = mapper.readTree(this.textResultQuality.getText());
                    this.entity.setResultQuality((Object)tree);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Not valid json.", (Throwable)ex);
            }
            try {
                if (!Utils.isNullOrEmpty(this.textParameters.getText())) {
                    Map map = (Map)mapper.readValue(this.textParameters.getText(), TYPE_MAP_STRING_OBJECT);
                    this.entity.setParameters(map);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Not valid json.", (Throwable)ex);
            }
        }

        @Override
        public EntityType getType() {
            return EntityType.OBSERVATION;
        }

        @Override
        public void init(SensorThingsService service, Observation entity, GridPane gridProperties, Accordion accordionLinks, Label labelId, boolean editable) {
            this.labelId = labelId;
            this.entity = entity;
            int i = 0;
            this.textPhenomenonTime = EntityGuiController.addFieldTo(gridProperties, i, "PhenomenonTime", new TextField(), false, editable);
            this.textResultTime = EntityGuiController.addFieldTo(gridProperties, ++i, "ResultTime", new TextField(), false, editable);
            this.textResult = EntityGuiController.addFieldTo(gridProperties, ++i, "Result", new TextArea(), true, editable);
            this.textResultQuality = EntityGuiController.addFieldTo(gridProperties, ++i, "ResultQuality", new TextField(), false, editable);
            this.textValidTime = EntityGuiController.addFieldTo(gridProperties, ++i, "ValidTime", new TextField(), false, editable);
            this.textParameters = EntityGuiController.addFieldTo(gridProperties, ++i, "Parameters", new TextArea(), true, editable);
            if (accordionLinks != null) {
                try {
                    accordionLinks.getPanes().add((Object)EntityGuiController.createEditableEntityPane(entity, entity.getDatastream(), service.datastreams().query(), "name asc", arg_0 -> ((Observation)entity).setDatastream(arg_0)));
                    accordionLinks.getPanes().add((Object)EntityGuiController.createEditableEntityPane(entity, entity.getMultiDatastream(), service.multiDatastreams().query(), "name asc", arg_0 -> ((Observation)entity).setMultiDatastream(arg_0)));
                    accordionLinks.getPanes().add((Object)EntityGuiController.createEditableEntityPane(entity, entity.getFeatureOfInterest(), service.featuresOfInterest().query(), "name asc", arg_0 -> ((Observation)entity).setFeatureOfInterest(arg_0)));
                }
                catch (ServiceFailureException | IOException ex) {
                    LOGGER.error("Failed to create panel.", ex);
                }
            }
        }
    }

    public static class GuiControllerLocation
    implements EntityGuiController<Location> {
        private static final Logger LOGGER = LoggerFactory.getLogger(GuiControllerThing.class);
        private Label labelId;
        private Location entity;
        private TextField textName;
        private TextArea textDescription;
        private TextField textEncodingType;
        private TextArea textLocation;
        private TextArea textProperties;

        @Override
        public void loadFields() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.getId() != null) {
                this.labelId.setText(this.entity.getId().toString());
            }
            this.textName.setText(this.entity.getName());
            this.textDescription.setText(this.entity.getDescription());
            this.textEncodingType.setText(this.entity.getEncodingType());
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                String json = mapper.writeValueAsString(this.entity.getLocation());
                this.textLocation.setText(json);
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Properties can not be converted to JSON.", (Throwable)ex);
            }
            try {
                if (this.entity.getProperties() != null) {
                    String props = mapper.writeValueAsString((Object)this.entity.getProperties());
                    this.textProperties.setText(props);
                }
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Properties can not be converted to JSON.", (Throwable)ex);
            }
        }

        @Override
        public void saveFields() {
            if (!Utils.isNullOrEmpty(this.textName.getText())) {
                this.entity.setName(this.textName.getText());
            }
            if (!Utils.isNullOrEmpty(this.textDescription.getText())) {
                this.entity.setDescription(this.textDescription.getText());
            }
            if (!Utils.isNullOrEmpty(this.textEncodingType.getText())) {
                this.entity.setEncodingType(this.textEncodingType.getText());
            }
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                if (!Utils.isNullOrEmpty(this.textLocation.getText())) {
                    GeoJsonObject feature = (GeoJsonObject)mapper.readValue(this.textLocation.getText(), GeoJsonObject.class);
                    this.entity.setLocation((Object)feature);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Not valid geojson.", (Throwable)ex);
            }
            try {
                if (!Utils.isNullOrEmpty(this.textProperties.getText())) {
                    Map properties = (Map)mapper.readValue(this.textProperties.getText(), TYPE_MAP_STRING_OBJECT);
                    this.entity.setProperties(properties);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Not valid json.", (Throwable)ex);
            }
        }

        @Override
        public EntityType getType() {
            return EntityType.LOCATION;
        }

        @Override
        public void init(SensorThingsService service, Location entity, GridPane gridProperties, Accordion accordionLinks, Label labelId, boolean editable) {
            this.labelId = labelId;
            this.entity = entity;
            int i = 0;
            this.textName = EntityGuiController.addFieldTo(gridProperties, i, "Name", new TextField(), false, editable);
            this.textDescription = EntityGuiController.addFieldTo(gridProperties, ++i, "Description", new TextArea(), true, editable);
            this.textEncodingType = EntityGuiController.addFieldTo(gridProperties, ++i, "EncodingType", new TextField(), false, editable);
            this.textLocation = EntityGuiController.addFieldTo(gridProperties, ++i, "Location", new TextArea(), false, editable);
            this.textProperties = EntityGuiController.addFieldTo(gridProperties, ++i, "Properties", new TextArea(), true, editable);
            if (accordionLinks != null) {
                try {
                    TitledPane tp = new TitledPane("Things", (Node)EntityGuiController.createCollectionPaneFor(entity.things().query(), "name asc"));
                    accordionLinks.getPanes().add((Object)tp);
                    tp = new TitledPane("HistoricalLocations", (Node)EntityGuiController.createCollectionPaneFor(entity.historicalLocations().query(), "time desc"));
                    accordionLinks.getPanes().add((Object)tp);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public static class GuiControllerHistoricalLocation
    implements EntityGuiController<HistoricalLocation> {
        private static final Logger LOGGER = LoggerFactory.getLogger(GuiControllerThing.class);
        private Label labelId;
        private HistoricalLocation entity;
        private TextField textTime;

        @Override
        public void loadFields() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.getId() != null) {
                this.labelId.setText(this.entity.getId().toString());
            }
            this.textTime.setText(this.entity.getTime().toString());
        }

        @Override
        public void saveFields() {
            if (!Utils.isNullOrEmpty(this.textTime.getText())) {
                this.entity.setTime(ZonedDateTime.parse(this.textTime.getText()));
            }
        }

        @Override
        public EntityType getType() {
            return EntityType.HISTORICAL_LOCATION;
        }

        @Override
        public void init(SensorThingsService service, HistoricalLocation entity, GridPane gridProperties, Accordion accordionLinks, Label labelId, boolean editable) {
            this.labelId = labelId;
            this.entity = entity;
            int i = 0;
            this.textTime = EntityGuiController.addFieldTo(gridProperties, i, "Time", new TextField(), false, editable);
            if (accordionLinks != null) {
                try {
                    accordionLinks.getPanes().add((Object)EntityGuiController.createEditableEntityPane(entity, entity.getThing(), service.things().query(), "name asc", arg_0 -> ((HistoricalLocation)entity).setThing(arg_0)));
                    TitledPane tp = new TitledPane("Locations", (Node)EntityGuiController.createCollectionPaneFor(entity.locations().query(), "name asc"));
                    accordionLinks.getPanes().add((Object)tp);
                }
                catch (ServiceFailureException | IOException ex) {
                    LOGGER.error("Failed to create panel.", ex);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public static class GuiControllerFeatureOfInterest
    implements EntityGuiController<FeatureOfInterest> {
        private static final Logger LOGGER = LoggerFactory.getLogger(GuiControllerThing.class);
        private Label labelId;
        private FeatureOfInterest entity;
        private TextField textName;
        private TextArea textDescription;
        private TextField textEncodingType;
        private TextArea textFeature;
        private TextArea textProperties;

        @Override
        public void loadFields() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.getId() != null) {
                this.labelId.setText(this.entity.getId().toString());
            }
            this.textName.setText(this.entity.getName());
            this.textDescription.setText(this.entity.getDescription());
            this.textEncodingType.setText(this.entity.getEncodingType());
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                String json = mapper.writeValueAsString(this.entity.getFeature());
                this.textFeature.setText(json);
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Properties can not be converted to JSON.", (Throwable)ex);
            }
            try {
                if (this.entity.getProperties() != null) {
                    String props = mapper.writeValueAsString((Object)this.entity.getProperties());
                    this.textProperties.setText(props);
                }
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Properties can not be converted to JSON.", (Throwable)ex);
            }
        }

        @Override
        public void saveFields() {
            if (!Utils.isNullOrEmpty(this.textName.getText())) {
                this.entity.setName(this.textName.getText());
            }
            if (!Utils.isNullOrEmpty(this.textDescription.getText())) {
                this.entity.setDescription(this.textDescription.getText());
            }
            if (!Utils.isNullOrEmpty(this.textEncodingType.getText())) {
                this.entity.setEncodingType(this.textEncodingType.getText());
            }
            ObjectMapper mapper = ObjectMapperFactory.get();
            if (!Utils.isNullOrEmpty(this.textFeature.getText())) {
                try {
                    Object feature = LocationDeserializer.deserialize((String)this.textFeature.getText(), (ObjectMapper)mapper);
                    this.entity.setFeature(feature);
                }
                catch (IOException ex) {
                    LOGGER.error("Not valid geojson.", (Throwable)ex);
                }
            }
            try {
                if (!Utils.isNullOrEmpty(this.textProperties.getText())) {
                    Map properties = (Map)mapper.readValue(this.textProperties.getText(), TYPE_MAP_STRING_OBJECT);
                    this.entity.setProperties(properties);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Not valid json.", (Throwable)ex);
            }
        }

        @Override
        public EntityType getType() {
            return EntityType.FEATURE_OF_INTEREST;
        }

        @Override
        public void init(SensorThingsService service, FeatureOfInterest entity, GridPane gridProperties, Accordion accordionLinks, Label labelId, boolean editable) {
            this.labelId = labelId;
            this.entity = entity;
            int i = 0;
            this.textName = EntityGuiController.addFieldTo(gridProperties, i, "Name", new TextField(), false, editable);
            this.textDescription = EntityGuiController.addFieldTo(gridProperties, ++i, "Description", new TextArea(), true, editable);
            this.textEncodingType = EntityGuiController.addFieldTo(gridProperties, ++i, "EncodingType", new TextField(), false, editable);
            this.textFeature = EntityGuiController.addFieldTo(gridProperties, ++i, "Feature", new TextArea(), false, editable);
            this.textProperties = EntityGuiController.addFieldTo(gridProperties, ++i, "Properties", new TextArea(), true, editable);
            if (accordionLinks != null) {
                try {
                    TitledPane tp = new TitledPane("Observations", (Node)EntityGuiController.createCollectionPaneFor(entity.observations().query(), "phenomenonTime asc"));
                    accordionLinks.getPanes().add((Object)tp);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public static class GuiControllerMultiDatastream
    implements EntityGuiController<MultiDatastream> {
        private static final Logger LOGGER = LoggerFactory.getLogger(GuiControllerThing.class);
        private Label labelId;
        private MultiDatastream entity;
        private TextField textName;
        private TextArea textDescription;
        private TextField textObservationType;
        private TextArea textUoms;
        private TextField textObservedArea;
        private TextField textPhenomenonTime;
        private TextField textResultTime;
        private TextArea textProperties;

        @Override
        public void loadFields() {
            if (this.entity.getId() != null) {
                this.labelId.setText(this.entity.getId().toString());
            }
            this.textName.setText(this.entity.getName());
            this.textDescription.setText(this.entity.getDescription());
            this.textObservationType.setText(this.entity.getObservationType());
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                List uoms = this.entity.getUnitOfMeasurements();
                if (uoms != null && !uoms.isEmpty()) {
                    this.textUoms.setText(mapper.writeValueAsString((Object)uoms));
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to load fields.", (Throwable)ex);
            }
            try {
                GeoJsonObject oa = this.entity.getObservedArea();
                if (oa != null) {
                    this.textObservedArea.setText(mapper.writeValueAsString((Object)oa));
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to load fields.", (Throwable)ex);
            }
            if (this.entity.getPhenomenonTime() != null) {
                this.textPhenomenonTime.setText(this.entity.getPhenomenonTime().toString());
            }
            if (this.entity.getResultTime() != null) {
                this.textResultTime.setText(this.entity.getResultTime().toString());
            }
            try {
                if (this.entity.getProperties() != null) {
                    String props = mapper.writeValueAsString((Object)this.entity.getProperties());
                    this.textProperties.setText(props);
                }
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Properties can not be converted to JSON.", (Throwable)ex);
            }
        }

        @Override
        public void saveFields() {
            Object properties;
            if (!Utils.isNullOrEmpty(this.textName.getText())) {
                this.entity.setName(this.textName.getText());
            }
            if (!Utils.isNullOrEmpty(this.textDescription.getText())) {
                this.entity.setDescription(this.textDescription.getText());
            }
            if (!Utils.isNullOrEmpty(this.textObservationType.getText())) {
                this.entity.setObservationType(this.textObservationType.getText());
            }
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                properties = (List)mapper.readValue(this.textUoms.getText(), TYPE_LIST_UOM);
                this.entity.setUnitOfMeasurements((List)properties);
            }
            catch (IOException ex) {
                LOGGER.error("Not valid json.", (Throwable)ex);
            }
            try {
                if (!Utils.isNullOrEmpty(this.textProperties.getText())) {
                    properties = (Map)mapper.readValue(this.textProperties.getText(), TYPE_MAP_STRING_OBJECT);
                    this.entity.setProperties((Map)properties);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Not valid json.", (Throwable)ex);
            }
        }

        @Override
        public EntityType getType() {
            return EntityType.MULTIDATASTREAM;
        }

        @Override
        public void init(SensorThingsService service, MultiDatastream entity, GridPane gridProperties, Accordion accordionLinks, Label labelId, boolean editable) {
            this.labelId = labelId;
            this.entity = entity;
            int i = 0;
            this.textName = EntityGuiController.addFieldTo(gridProperties, i, "Name", new TextField(), false, editable);
            this.textDescription = EntityGuiController.addFieldTo(gridProperties, ++i, "Description", new TextArea(), true, editable);
            this.textObservationType = EntityGuiController.addFieldTo(gridProperties, ++i, "ObservationType", new TextField(), false, editable);
            this.textUoms = EntityGuiController.addFieldTo(gridProperties, ++i, "UoMs", new TextArea(), false, editable);
            this.textObservedArea = EntityGuiController.addFieldTo(gridProperties, ++i, "ObservedArea", new TextField(), false, false);
            this.textPhenomenonTime = EntityGuiController.addFieldTo(gridProperties, ++i, "PhenomenonTime", new TextField(), false, false);
            this.textResultTime = EntityGuiController.addFieldTo(gridProperties, ++i, "ResultTime", new TextField(), false, false);
            this.textProperties = EntityGuiController.addFieldTo(gridProperties, ++i, "Properties", new TextArea(), true, editable);
            if (accordionLinks != null) {
                try {
                    accordionLinks.getPanes().add((Object)EntityGuiController.createEditableEntityPane(entity, entity.getThing(), service.things().query(), "name asc", arg_0 -> ((MultiDatastream)entity).setThing(arg_0)));
                    accordionLinks.getPanes().add((Object)EntityGuiController.createEditableEntityPane(entity, entity.getSensor(), service.sensors().query(), "name asc", arg_0 -> ((MultiDatastream)entity).setSensor(arg_0)));
                    TitledPane tp = new TitledPane("ObservedProperties", (Node)EntityGuiController.createCollectionPaneFor(entity.observedProperties().query(), "name asc"));
                    accordionLinks.getPanes().add((Object)tp);
                    tp = new TitledPane("Observations", (Node)EntityGuiController.createCollectionPaneFor(entity.observations().query(), "phenomenonTime asc"));
                    accordionLinks.getPanes().add((Object)tp);
                }
                catch (ServiceFailureException | IOException ex) {
                    LOGGER.error("Failed to create panel.", ex);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public static class GuiControllerDatastream
    implements EntityGuiController<Datastream> {
        private static final Logger LOGGER = LoggerFactory.getLogger(GuiControllerThing.class);
        private Label labelId;
        private Datastream entity;
        private TextField textName;
        private TextArea textDescription;
        private TextField textObservationType;
        private TextField textUomName;
        private TextField textUomSymbol;
        private TextField textUomDefinition;
        private TextField textObservedArea;
        private TextField textPhenomenonTime;
        private TextField textResultTime;
        private TextArea textProperties;

        @Override
        public void loadFields() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.getId() != null) {
                this.labelId.setText(this.entity.getId().toString());
            }
            this.textName.setText(this.entity.getName());
            this.textDescription.setText(this.entity.getDescription());
            this.textObservationType.setText(this.entity.getObservationType());
            UnitOfMeasurement uom = this.entity.getUnitOfMeasurement();
            if (uom == null) {
                uom = new UnitOfMeasurement();
                this.entity.setUnitOfMeasurement(uom);
            }
            this.textUomName.setText(uom.getName());
            this.textUomSymbol.setText(uom.getSymbol());
            this.textUomDefinition.setText(uom.getDefinition());
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                GeoJsonObject oa = this.entity.getObservedArea();
                this.textObservedArea.setText(mapper.writeValueAsString((Object)oa));
            }
            catch (IOException ex) {
                LOGGER.error("Failed to load fields.", (Throwable)ex);
            }
            if (this.entity.getPhenomenonTime() != null) {
                this.textPhenomenonTime.setText(this.entity.getPhenomenonTime().toString());
            }
            if (this.entity.getResultTime() != null) {
                this.textResultTime.setText(this.entity.getResultTime().toString());
            }
            try {
                if (this.entity.getProperties() != null) {
                    String props = mapper.writeValueAsString((Object)this.entity.getProperties());
                    this.textProperties.setText(props);
                }
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Properties can not be converted to JSON.", (Throwable)ex);
            }
        }

        @Override
        public void saveFields() {
            if (!Utils.isNullOrEmpty(this.textName.getText())) {
                this.entity.setName(this.textName.getText());
            }
            if (!Utils.isNullOrEmpty(this.textDescription.getText())) {
                this.entity.setDescription(this.textDescription.getText());
            }
            if (!Utils.isNullOrEmpty(this.textObservationType.getText())) {
                this.entity.setObservationType(this.textObservationType.getText());
            }
            if (!(Utils.isNullOrEmpty(this.textUomName.getText()) && Utils.isNullOrEmpty(this.textUomSymbol.getText()) && Utils.isNullOrEmpty(this.textUomDefinition.getText()))) {
                UnitOfMeasurement uom = this.entity.getUnitOfMeasurement();
                uom.setName(this.textUomName.getText());
                uom.setSymbol(this.textUomSymbol.getText());
                uom.setDefinition(this.textUomDefinition.getText());
            }
            ObjectMapper mapper = ObjectMapperFactory.get();
            try {
                if (!Utils.isNullOrEmpty(this.textProperties.getText())) {
                    Map properties = (Map)mapper.readValue(this.textProperties.getText(), TYPE_MAP_STRING_OBJECT);
                    this.entity.setProperties(properties);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Not valid json.", (Throwable)ex);
            }
        }

        @Override
        public EntityType getType() {
            return EntityType.DATASTREAM;
        }

        @Override
        public void init(SensorThingsService service, Datastream entity, GridPane gridProperties, Accordion accordionLinks, Label labelId, boolean editable) {
            this.labelId = labelId;
            this.entity = entity;
            int i = 0;
            this.textName = EntityGuiController.addFieldTo(gridProperties, i, "Name", new TextField(), false, editable);
            this.textDescription = EntityGuiController.addFieldTo(gridProperties, ++i, "Description", new TextArea(), true, editable);
            this.textObservationType = EntityGuiController.addFieldTo(gridProperties, ++i, "ObservationType", new TextField(), false, editable);
            this.textUomName = EntityGuiController.addFieldTo(gridProperties, ++i, "UoM: Name", new TextField(), false, editable);
            this.textUomSymbol = EntityGuiController.addFieldTo(gridProperties, ++i, "UoM: Symbol", new TextField(), false, editable);
            this.textUomDefinition = EntityGuiController.addFieldTo(gridProperties, ++i, "UoM: Definition", new TextField(), false, editable);
            this.textObservedArea = EntityGuiController.addFieldTo(gridProperties, ++i, "ObservedArea", new TextField(), false, false);
            this.textPhenomenonTime = EntityGuiController.addFieldTo(gridProperties, ++i, "PhenomenonTime", new TextField(), false, false);
            this.textResultTime = EntityGuiController.addFieldTo(gridProperties, ++i, "ResultTime", new TextField(), false, false);
            this.textProperties = EntityGuiController.addFieldTo(gridProperties, ++i, "Properties", new TextArea(), true, editable);
            if (accordionLinks != null) {
                try {
                    accordionLinks.getPanes().add((Object)EntityGuiController.createEditableEntityPane(entity, entity.getThing(), service.things().query(), "name asc", arg_0 -> ((Datastream)entity).setThing(arg_0)));
                    accordionLinks.getPanes().add((Object)EntityGuiController.createEditableEntityPane(entity, entity.getSensor(), service.sensors().query(), "name asc", arg_0 -> ((Datastream)entity).setSensor(arg_0)));
                    accordionLinks.getPanes().add((Object)EntityGuiController.createEditableEntityPane(entity, entity.getObservedProperty(), service.observedProperties().query(), "name asc", arg_0 -> ((Datastream)entity).setObservedProperty(arg_0)));
                    accordionLinks.getPanes().add((Object)new TitledPane("Observations", (Node)EntityGuiController.createCollectionPaneFor(entity.observations().query(), "phenomenonTime asc")));
                }
                catch (ServiceFailureException | IOException ex) {
                    LOGGER.error("Failed to create panel.", ex);
                }
                catch (NullPointerException e) {
                    LOGGER.trace("Failed to create panel.", (Throwable)e);
                }
            }
        }
    }
}

