/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import de.fraunhofer.iosb.ilt.configurable.ConfigurationException;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorMap;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.controller.ControllerServer;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.utils.Server;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.utils.ServerListEntry;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.utils.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerScene
implements Initializable {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerScene.class);
    @FXML
    private SplitPane mainSplit;
    @FXML
    private ToggleButton buttonServers;
    private double[] dividerPositions;
    @FXML
    private Button buttonAdd;
    @FXML
    private Button buttonUpdate;
    @FXML
    private Button buttonConnect;
    @FXML
    private Button buttonDelete;
    @FXML
    private ListView<ServerListEntry> serverList;
    private ObservableList<ServerListEntry> servers;
    @FXML
    private TabPane serverTabs;
    @FXML
    private Node paneServers;
    @FXML
    private BorderPane paneAuth;
    private ServerListEntry activeItem = new ServerListEntry();
    private EditorMap<?> configEditor;

    @FXML
    private void toggleServersAction(ActionEvent event) {
        this.checkServersButton();
    }

    private void checkServersButton() {
        if (this.buttonServers.isSelected()) {
            this.mainSplit.getItems().add(0, (Object)this.paneServers);
            this.mainSplit.setDividerPositions(this.dividerPositions);
        } else {
            this.dividerPositions = this.mainSplit.getDividerPositions();
            this.mainSplit.getItems().remove((Object)this.paneServers);
        }
    }

    private Server createConfiguredServer() throws ConfigurationException {
        JsonElement config = this.configEditor.getConfig();
        Server server = new Server();
        server.configure(config, null, null, null);
        return server;
    }

    @FXML
    private void actionServerAdd(ActionEvent event) {
        Server server;
        try {
            server = this.createConfiguredServer();
        }
        catch (ConfigurationException ex) {
            LOGGER.error("Failed to configure server.", (Throwable)ex);
            Utils.showAlert(Alert.AlertType.ERROR, "Failed to configure server", "Failed to configure server.", ex);
            return;
        }
        ServerListEntry entry = new ServerListEntry().setName(server.getName()).setJsonElement(this.configEditor.getConfig());
        this.servers.add((Object)entry);
        this.sortServers();
        this.saveServerList();
    }

    @FXML
    private void actionServerUpdate(ActionEvent event) {
        Server server;
        ServerListEntry serverEntry = (ServerListEntry)this.serverList.getSelectionModel().getSelectedItem();
        if (serverEntry == null) {
            return;
        }
        try {
            server = this.createConfiguredServer();
        }
        catch (ConfigurationException ex) {
            LOGGER.error("Failed to configure server.", (Throwable)ex);
            Utils.showAlert(Alert.AlertType.ERROR, "Failed to configure server", "Failed to configure server.", ex);
            return;
        }
        serverEntry.setName(server.getName()).setJsonElement(this.configEditor.getConfig());
        this.sortServers();
        this.saveServerList();
    }

    @FXML
    private void actionServerDelete(ActionEvent event) {
        int selectedIndex = this.serverList.getSelectionModel().getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < this.servers.size()) {
            this.servers.remove(selectedIndex);
        }
        this.saveServerList();
    }

    @FXML
    private void actionServerSelected(ServerListEntry server) {
        if (server == null) {
            this.buttonDelete.setDisable(true);
            return;
        }
        this.activeItem = server;
        this.buttonDelete.setDisable(false);
        this.configEditor.setConfig(server.getJsonElement());
    }

    @FXML
    private void actionServerConnect(ActionEvent event) {
        try {
            Server server;
            try {
                server = this.createConfiguredServer();
            }
            catch (ConfigurationException ex) {
                LOGGER.error("Failed to configure server.", (Throwable)ex);
                Utils.showAlert(Alert.AlertType.ERROR, "Failed to configure server", "Failed to configure server.", ex);
                return;
            }
            String name = server.getName();
            if (name.isEmpty()) {
                name = server.getUrl();
            }
            LOGGER.info("Connecting to {} at {}.", (Object)name, (Object)server.getUrl());
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/Server.fxml"));
            AnchorPane content = (AnchorPane)loader.load();
            ControllerServer controller = (ControllerServer)loader.getController();
            controller.setServerEntry(server);
            Tab tab = new Tab(name);
            tab.setContent((Node)content);
            this.serverTabs.getTabs().add((Object)tab);
            this.buttonServers.setSelected(false);
            this.checkServersButton();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to create server tab.", (Throwable)ex);
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.configEditor = new Server().getConfigEditor(null, null);
        this.paneAuth.setCenter(this.configEditor.getGuiFactoryFx().getNode());
        this.servers = FXCollections.observableArrayList();
        this.loadServerList();
        this.serverList.setItems(this.servers);
        this.serverList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.actionServerSelected((ServerListEntry)newValue));
    }

    private void sortServers() {
        this.servers.sort((Comparator)new Comparator<ServerListEntry>(){

            @Override
            public int compare(ServerListEntry o1, ServerListEntry o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
            }
        });
    }

    private void loadServerList() {
        try {
            File serversFile = new File("servers.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            List serversFromFile = (List)gson.fromJson((Reader)new FileReader(serversFile), new TypeReference<List<ServerListEntry>>(){}.getType());
            this.servers.addAll((Collection)serversFromFile);
            this.sortServers();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to read server list.", (Throwable)ex);
        }
    }

    private void saveServerList() {
        try {
            File serversFile = new File("servers.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String toJson = gson.toJson(this.servers);
            FileUtils.write((File)serversFile, (CharSequence)toJson, (Charset)UTF8);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to save server list.", (Throwable)ex);
        }
    }
}

