/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.controller;

import de.fraunhofer.iosb.ilt.sensorthingsmanager.utils.ChangingStatusLogger;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.utils.Utils;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.FeatureOfInterest;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.TimeObject;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerCleaner
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerCleaner.class);
    @FXML
    private CheckBox cleanThings;
    @FXML
    private CheckBox cleanDatastreams;
    @FXML
    private CheckBox cleanMultiDatastreams;
    @FXML
    private CheckBox cleanSensors;
    @FXML
    private CheckBox cleanObservedProperties;
    @FXML
    private CheckBox cleanFeatures;
    @FXML
    private CheckBox cleanLocations;
    @FXML
    private CheckBox cleanDuplicateObsPhentime;
    @FXML
    private CheckBox deleteThings;
    @FXML
    private CheckBox deleteSensors;
    @FXML
    private CheckBox deleteObservedProperties;
    @FXML
    private CheckBox deleteFeatures;
    @FXML
    private CheckBox deleteLocations;
    @FXML
    private CheckBox deleteDatastreams;
    @FXML
    private CheckBox deleteMultiDatastreams;
    @FXML
    private CheckBox deleteObservations;
    private SensorThingsService service;
    private final LogStatusCleaner logStatusCleaner = new LogStatusCleaner();
    private final ChangingStatusLogger statusLogger = new ChangingStatusLogger(LOGGER).addLogStatus(this.logStatusCleaner).setLogIntervalMs(2000L);

    @FXML
    private void actionClean(ActionEvent event) {
        this.statusLogger.start();
        try {
            if (this.cleanThings.isSelected()) {
                this.cleanThings();
            }
            if (this.cleanSensors.isSelected()) {
                this.cleanSensors();
            }
            if (this.cleanObservedProperties.isSelected()) {
                this.cleanObservedProperties();
            }
            if (this.cleanFeatures.isSelected()) {
                this.cleanFeatures();
            }
            if (this.cleanDatastreams.isSelected()) {
                this.cleanDatastreams();
            }
            if (this.cleanMultiDatastreams.isSelected()) {
                this.cleanMultiDatastreams();
            }
            if (this.cleanLocations.isSelected()) {
                this.cleanLocations();
            }
            if (this.cleanDuplicateObsPhentime.isSelected()) {
                this.cleanObservationsDuplicatePhentime();
            }
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Failed to clean.", (Throwable)ex);
        }
        this.statusLogger.stop();
    }

    private void cleanThings() throws ServiceFailureException {
        EntityList list = this.service.things().query().select(new String[]{"name", "id"}).expand("Datastreams($select=id;$top=1),MultiDatastreams($select=id;$top=1)").orderBy("id asc").list();
        ArrayList<Thing> toDelete = new ArrayList<Thing>();
        long count = 0L;
        long toDel = 0L;
        Iterator it = list.fullIterator();
        while (it.hasNext()) {
            Thing next = (Thing)it.next();
            this.logStatusCleaner.setThings(++count);
            if (!next.getDatastreams().isEmpty() || !next.getMultiDatastreams().isEmpty()) continue;
            toDelete.add(next);
            this.logStatusCleaner.setToDelete(++toDel);
        }
        LOGGER.info("Deleting {} Things", (Object)toDelete.size());
        for (Thing item : toDelete) {
            this.logStatusCleaner.setToDelete(--toDel);
            this.service.delete((Entity)item.withOnlyId());
        }
    }

    private void cleanSensors() throws ServiceFailureException {
        EntityList list = this.service.sensors().query().select(new String[]{"name", "id"}).expand("Datastreams($select=id;$top=1),MultiDatastreams($select=id;$top=1)").orderBy("id asc").list();
        ArrayList<Sensor> toDelete = new ArrayList<Sensor>();
        long count = 0L;
        long toDel = 0L;
        Iterator it = list.fullIterator();
        while (it.hasNext()) {
            Sensor next = (Sensor)it.next();
            this.logStatusCleaner.setSensors(++count);
            if (!next.getDatastreams().isEmpty() || !next.getMultiDatastreams().isEmpty()) continue;
            toDelete.add(next);
            this.logStatusCleaner.setToDelete(++toDel);
        }
        LOGGER.info("Deleting {} Sensors", (Object)toDelete.size());
        for (Sensor item : toDelete) {
            this.logStatusCleaner.setToDelete(--toDel);
            this.service.delete((Entity)item.withOnlyId());
        }
    }

    private void cleanObservedProperties() throws ServiceFailureException {
        EntityList list = this.service.observedProperties().query().select(new String[]{"name", "id"}).expand("Datastreams($select=id;$top=1),MultiDatastreams($select=id;$top=1)").orderBy("id asc").list();
        ArrayList<ObservedProperty> toDelete = new ArrayList<ObservedProperty>();
        long count = 0L;
        long toDel = 0L;
        Iterator it = list.fullIterator();
        while (it.hasNext()) {
            ObservedProperty next = (ObservedProperty)it.next();
            this.logStatusCleaner.setObsProps(++count);
            if (!next.getDatastreams().isEmpty() || !next.getMultiDatastreams().isEmpty()) continue;
            toDelete.add(next);
            this.logStatusCleaner.setToDelete(++toDel);
        }
        LOGGER.info("Deleting {} ObservedProperties", (Object)toDelete.size());
        for (ObservedProperty item : toDelete) {
            this.logStatusCleaner.setToDelete(--toDel);
            this.service.delete((Entity)item.withOnlyId());
        }
    }

    private void cleanDatastreams() throws ServiceFailureException {
        LOGGER.info("Cleaning Datastreams");
        EntityList list = this.service.datastreams().query().select(new String[]{"name", "id"}).expand("Observations($select=id;$top=1)").orderBy("id asc").list();
        ArrayList<Datastream> toDelete = new ArrayList<Datastream>();
        long count = 0L;
        long toDel = 0L;
        Iterator it = list.fullIterator();
        while (it.hasNext()) {
            Datastream next = (Datastream)it.next();
            this.logStatusCleaner.setDatastreams(++count);
            if (!next.getObservations().isEmpty()) continue;
            toDelete.add(next);
            this.logStatusCleaner.setToDelete(++toDel);
        }
        LOGGER.info("Deleting {} Datastreams", (Object)toDelete.size());
        for (Datastream item : toDelete) {
            this.logStatusCleaner.setToDelete(--toDel);
            this.service.delete((Entity)item.withOnlyId());
        }
    }

    private void cleanMultiDatastreams() throws ServiceFailureException {
        LOGGER.info("Cleaning MultiDatastreams");
        EntityList list = this.service.multiDatastreams().query().select(new String[]{"name", "id"}).expand("Observations($select=id;$top=1)").orderBy("id asc").list();
        ArrayList<MultiDatastream> toDelete = new ArrayList<MultiDatastream>();
        long count = 0L;
        long toDel = 0L;
        Iterator it = list.fullIterator();
        while (it.hasNext()) {
            MultiDatastream next = (MultiDatastream)it.next();
            this.logStatusCleaner.setMultiDatastreams(++count);
            if (!next.getObservations().isEmpty()) continue;
            toDelete.add(next);
            this.logStatusCleaner.setToDelete(++toDel);
        }
        LOGGER.info("Deleting {} MultiDatastream", (Object)toDelete.size());
        for (MultiDatastream item : toDelete) {
            this.logStatusCleaner.setToDelete(--toDel);
            this.service.delete((Entity)item.withOnlyId());
        }
    }

    private void cleanFeatures() throws ServiceFailureException {
        LOGGER.info("Cleaning Features");
        EntityList list = this.service.featuresOfInterest().query().select(new String[]{"name", "id"}).expand("Observations($select=id;$top=1)").orderBy("id asc").list();
        long count = 0L;
        long toDel = 0L;
        ArrayList<FeatureOfInterest> toDelete = new ArrayList<FeatureOfInterest>();
        Iterator it = list.fullIterator();
        while (it.hasNext()) {
            FeatureOfInterest next = (FeatureOfInterest)it.next();
            this.logStatusCleaner.setFeatures(++count);
            if (!next.getObservations().isEmpty()) continue;
            toDelete.add(next);
            this.logStatusCleaner.setToDelete(++toDel);
        }
        LOGGER.info("Deleting {} FeaturesOfInterest", (Object)toDelete.size());
        for (FeatureOfInterest item : toDelete) {
            this.logStatusCleaner.setToDelete(--toDel);
            this.service.delete((Entity)item.withOnlyId());
        }
    }

    private void cleanLocations() throws ServiceFailureException {
        EntityList list = this.service.locations().query().select(new String[]{"name", "id"}).expand("Things($select=id;$top=1),HistoricalLocations($select=id;$top=1)").orderBy("id asc").list();
        ArrayList<Location> toDelete = new ArrayList<Location>();
        long count = 0L;
        long toDel = 0L;
        Iterator it = list.fullIterator();
        while (it.hasNext()) {
            Location next = (Location)it.next();
            this.logStatusCleaner.setLocations(++count);
            if (!next.getThings().isEmpty() || !next.getHistoricalLocations().isEmpty()) continue;
            toDelete.add(next);
            this.logStatusCleaner.setToDelete(++toDel);
        }
        LOGGER.info("Deleting {} Locations", (Object)toDelete.size());
        for (Location item : toDelete) {
            this.logStatusCleaner.setToDelete(--toDel);
            this.service.delete((Entity)item.withOnlyId());
        }
    }

    private void cleanObservationsDuplicatePhentime() throws ServiceFailureException {
        EntityList list = this.service.datastreams().query().select(new String[]{"name", "id"}).orderBy("id asc").expand("Observations($select=id;$top=1)").filter("id ge 3699").list();
        long count = 0L;
        Iterator it = list.fullIterator();
        while (it.hasNext()) {
            Datastream next = (Datastream)it.next();
            this.logStatusCleaner.setDatastreams(++count);
            this.cleanObsForDatastream(next);
        }
    }

    private void cleanObsForDatastream(Datastream ds) throws ServiceFailureException {
        ArrayList<Observation> toDelete = new ArrayList<Observation>();
        EntityList list = ds.observations().query().orderBy("phenomenonTime asc,id asc").select(new String[]{"id,phenomenonTime"}).top(100000).list();
        Iterator it = list.fullIterator();
        long count = 0L;
        long toDel = 0L;
        TimeObject last = null;
        while (it.hasNext()) {
            Observation next = (Observation)it.next();
            this.logStatusCleaner.setObservations(++count);
            TimeObject cur = next.getPhenomenonTime();
            if (last == null) {
                last = cur;
                continue;
            }
            if (last.equals((Object)cur)) {
                toDelete.add(next);
                this.logStatusCleaner.setToDelete(++toDel);
            }
            last = cur;
        }
        if (toDelete.isEmpty()) {
            return;
        }
        LOGGER.info("Deleting {} obs for Datastream {}", (Object)toDelete.size(), (Object)ds);
        for (Observation obs : toDelete) {
            this.logStatusCleaner.setToDelete(--toDel);
            this.service.delete((Entity)obs);
        }
    }

    @FXML
    private void actionDelete(ActionEvent event) {
        try {
            if (this.deleteThings.isSelected()) {
                Utils.deleteAll(this.service.things());
            }
            if (this.deleteSensors.isSelected()) {
                Utils.deleteAll(this.service.sensors());
            }
            if (this.deleteObservedProperties.isSelected()) {
                Utils.deleteAll(this.service.observedProperties());
            }
            if (this.deleteFeatures.isSelected()) {
                Utils.deleteAll(this.service.featuresOfInterest());
            }
            if (this.deleteLocations.isSelected()) {
                Utils.deleteAll(this.service.locations());
            }
            if (this.deleteDatastreams.isSelected()) {
                Utils.deleteAll(this.service.datastreams());
            }
            if (this.deleteMultiDatastreams.isSelected()) {
                Utils.deleteAll(this.service.multiDatastreams());
            }
            if (this.deleteObservations.isSelected()) {
                Utils.deleteAll(this.service.observations());
            }
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Exception deleting.", (Throwable)ex);
        }
    }

    public void setService(SensorThingsService service) {
        this.service = service;
    }

    public void initialize(URL url, ResourceBundle rb) {
    }

    private static class LogStatusCleaner
    extends ChangingStatusLogger.ChangingStatusDefault {
        public LogStatusCleaner() {
            super("Cleaning... {} T, {} L, {} S, {} Op, {} Ds, {} MDs, {} F, {} O. To Delete: {} ", 9);
            this.setAllTo(0L);
        }

        public void setThings(Long value) {
            this.setObjectAt(0, value);
        }

        public void setLocations(Long value) {
            this.setObjectAt(1, value);
        }

        public void setSensors(Long value) {
            this.setObjectAt(2, value);
        }

        public void setObsProps(Long value) {
            this.setObjectAt(3, value);
        }

        public void setDatastreams(Long value) {
            this.setObjectAt(4, value);
        }

        public void setMultiDatastreams(Long value) {
            this.setObjectAt(5, value);
        }

        public void setFeatures(Long value) {
            this.setObjectAt(6, value);
        }

        public void setObservations(Long value) {
            this.setObjectAt(7, value);
        }

        public void setToDelete(Long value) {
            this.setObjectAt(8, value);
        }
    }
}

