/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation;

import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.TimeObject;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.regex.Pattern;

public class Utils {
    public static final UnitOfMeasurement NULL_UNIT = new UnitOfMeasurement(null, null, null);
    public static final String KEY_AGGREGATE_SOURCE = "aggregateSource";
    public static final String KEY_AGGREGATE_SOURCE_D = "aggregateSource.Datastream@iot.id";
    public static final String KEY_AGGREGATE_SOURCE_MD = "aggregateSource.MultiDatastream@iot.id";
    public static final String KEY_AGGREGATE_FOR = "aggregateFor";
    public static final String KEY_AGGREGATE_UNIT = "aggregateUnit";
    public static final String KEY_AGGREGATE_AMOUNT = "aggregateAmount";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String LB = Pattern.quote("[");
    public static final String RB = Pattern.quote("]");
    public static final Pattern POSTFIX_PATTERN = Pattern.compile("(.+)" + LB + "([0-9]+ [a-zA-Z]+)" + RB);

    private Utils() {
    }

    public static Instant getPhenTimeStart(Observation obs) {
        TimeObject phenTime = obs.getPhenomenonTime();
        return Utils.getPhenTimeStart(phenTime);
    }

    public static Instant getPhenTimeStart(TimeObject phenTime) {
        if (phenTime.isInterval()) {
            return phenTime.getAsInterval().getStart();
        }
        return phenTime.getAsDateTime().toInstant();
    }

    public static Instant getPhenTimeEnd(Observation obs) {
        TimeObject phenTime = obs.getPhenomenonTime();
        return Utils.getPhenTimeEnd(phenTime);
    }

    public static Instant getPhenTimeEnd(TimeObject phenTime) {
        if (phenTime.isInterval()) {
            return phenTime.getAsInterval().getEnd();
        }
        return phenTime.getAsDateTime().toInstant();
    }

    public static enum AggregationLevels {
        HOURLY("[1 hour]", "Aggregated hourly"),
        DAILY("[1 day]", "Aggregated daily");

        public final String postfix;
        public final String description;

        private AggregationLevels(String postfix, String description) {
            this.postfix = postfix;
            this.description = description;
        }
    }
}

