/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.Utils;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.sta.query.Query;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorThingsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SensorThingsUtils.class);
    public final Map<ObservedProperty, List<ObservedProperty>> aggregateProperties = new HashMap<ObservedProperty, List<ObservedProperty>>();

    public ObservedProperty findOrCreateOp(SensorThingsService service, String name, String def, String description, Map<String, Object> properties, String filter, boolean aggregates) throws ServiceFailureException {
        ObservedProperty op;
        Query query = service.observedProperties().query();
        if (Utils.isNullOrEmpty((String)filter)) {
            query.filter("name eq '" + Utils.escapeForStringConstant((String)name) + "'");
        } else {
            query.filter(filter);
        }
        EntityList opList = query.list();
        if (opList.size() > 1) {
            throw new IllegalStateException("More than one observedProperty with name " + name);
        }
        if (opList.size() == 1) {
            op = (ObservedProperty)opList.iterator().next();
        } else {
            LOGGER.info("Creating ObservedProperty {}.", (Object)name);
            op = new ObservedProperty();
            op.setName(name);
            op.setDefinition(def);
            op.setDescription(description);
            op.setProperties(properties);
            service.create((Entity)op);
        }
        if (aggregates) {
            this.findOrCreateAggregateOps(service, op);
        }
        return op;
    }

    public void findOrCreateAggregateOps(SensorThingsService service, ObservedProperty op) throws ServiceFailureException {
        List<ObservedProperty> agList = this.aggregateProperties.get(op);
        if (agList != null && agList.size() == 3) {
            return;
        }
        agList = new ArrayList<ObservedProperty>();
        this.aggregateProperties.put(op, agList);
        String opName = op.getName();
        String opDef = op.getDefinition();
        String opDesc = op.getDescription();
        String def = op.getDefinition();
        String agOpName = opName + " Min";
        String agOpDesc = opDesc + " Minimum";
        ObservedProperty agOp = this.findOrCreateOp(service, agOpName, def, agOpDesc, null, "", false);
        agList.add(agOp);
        agOpName = opName + " Max";
        agOpDesc = opDesc + " Maximum";
        agOp = this.findOrCreateOp(service, agOpName, def, agOpDesc, null, "", false);
        agList.add(agOp);
        agOpName = opName + " Dev";
        agOpDesc = opDesc + " Standard deviation";
        agOp = this.findOrCreateOp(service, agOpName, def, agOpDesc, null, "", false);
        agList.add(agOp);
    }

    public MultiDatastream findOrCreateMultiDatastream(SensorThingsService service, String name, String desc, List<UnitOfMeasurement> uoms, Thing t, List<ObservedProperty> ops, Sensor s, Map<String, Object> props) throws ServiceFailureException {
        MultiDatastream mds;
        EntityList mdsList = service.multiDatastreams().query().filter("name eq '" + Utils.escapeForStringConstant((String)name) + "'").list();
        if (mdsList.size() > 1) {
            throw new IllegalStateException("More than one multidatastream with name " + name);
        }
        if (mdsList.size() == 1) {
            mds = (MultiDatastream)mdsList.iterator().next();
        } else {
            LOGGER.info("Creating multiDatastream {}.", (Object)name);
            ArrayList<String> dataTypes = new ArrayList<String>();
            for (ObservedProperty op : ops) {
                dataTypes.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
            }
            mds = new MultiDatastream(name, desc, dataTypes, uoms);
            mds.setProperties(props);
            mds.setThing(t);
            mds.setSensor(s);
            mds.getObservedProperties().addAll(ops);
            service.create((Entity)mds);
        }
        return mds;
    }
}

