/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation;

import de.fraunhofer.iosb.ilt.configurable.ConfigurationException;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorMap;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregateCombo;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregationBase;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregationData;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregationLevel;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.SensorThingsUtils;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.utils.ButtonTableCell;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.utils.DateTimePicker;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.TimeObject;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.net.URL;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.ObservableValueBase;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.extra.Interval;

public class ControllerAggManager
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerAggManager.class);
    private static final ObservableValue<Void> OBSERVABLE_VOID = new ObservableValueBase<Void>(){

        public Void getValue() {
            return null;
        }
    };
    @FXML
    private BorderPane paneAddLevel;
    @FXML
    private Button buttonReload;
    @FXML
    private Button buttonAddLevel;
    @FXML
    private Button buttonApplyChanges;
    @FXML
    private TableView<AggregationBase> table;
    @FXML
    private ProgressBar progressBar;
    private SensorThingsService service;
    private AggregationData data;
    private TableColumn<AggregationBase, String> baseColumn;
    private TableColumn<AggregationBase, AggregationBase> buttonColumn;
    private Map<AggregationLevel, TableColumn<AggregationBase, Boolean>> columnsByLevel = new HashMap<AggregationLevel, TableColumn<AggregationBase, Boolean>>();
    private EditorMap<?> levelEditor;
    private SensorThingsUtils utils = new SensorThingsUtils();
    private Instant lastPickedStart;
    private Instant lastPickedEnd;

    public void initialize(URL location, ResourceBundle resources) {
        this.buttonReload.setDisable(true);
        AggregationLevel level = new AggregationLevel(ChronoUnit.HOURS, 1);
        this.levelEditor = level.getConfigEditor(null, null);
        Node node = this.levelEditor.getGuiFactoryFx().getNode();
        this.paneAddLevel.setCenter(node);
    }

    public void setService(SensorThingsService service) {
        this.service = service;
        this.buttonReload.setDisable(false);
    }

    private void addMenuToColumn(TableColumn<AggregationBase, Boolean> column, AggregationLevel level) {
        MenuItem addAll = new MenuItem("Check All");
        addAll.setOnAction(event -> this.setAllOnColumn(column, level, true));
        MenuItem removeAll = new MenuItem("Un-Check All");
        removeAll.setOnAction(event -> this.setAllOnColumn(column, level, false));
        MenuItem addSelected = new MenuItem("Check Selected");
        addSelected.setOnAction(event -> this.setSelectedOnColumn(column, level, true));
        MenuItem removeSelected = new MenuItem("Un-Check Selected");
        removeSelected.setOnAction(event -> this.setSelectedOnColumn(column, level, false));
        ContextMenu menu = new ContextMenu(new MenuItem[]{addAll, removeAll, addSelected, removeSelected});
        column.setContextMenu(menu);
    }

    private void setAllOnColumn(TableColumn<AggregationBase, Boolean> column, AggregationLevel level, boolean enabled) {
        for (AggregationBase item : column.getTableView().getItems()) {
            item.getFxProperties().getLevelProperty(level).set(enabled);
        }
    }

    private void setSelectedOnColumn(TableColumn<AggregationBase, Boolean> column, AggregationLevel level, boolean enabled) {
        for (AggregationBase item : column.getTableView().getSelectionModel().getSelectedItems()) {
            item.getFxProperties().getLevelProperty(level).set(enabled);
        }
    }

    private TableColumn<AggregationBase, Boolean> getColumnForLevel(AggregationLevel level) {
        TableColumn column = this.columnsByLevel.get(level);
        if (column == null) {
            LOGGER.info("Creating column {}.", (Object)level);
            column = new TableColumn(level.toString());
            column.setCellFactory(param -> {
                CheckBoxTableCell cell = new CheckBoxTableCell();
                cell.setAlignment(Pos.CENTER);
                return cell;
            });
            column.setCellValueFactory(param -> ((AggregationBase)param.getValue()).getFxProperties().getLevelProperty(level));
            column.setEditable(true);
            this.addMenuToColumn((TableColumn<AggregationBase, Boolean>)column, level);
            this.columnsByLevel.put(level, (TableColumn<AggregationBase, Boolean>)column);
        }
        return column;
    }

    private void reCalculateBase(AggregationBase base, Instant start, Instant end) {
        try {
            Datastream baseDs = base.getBaseDatastream();
            if (baseDs == null) {
                LOGGER.error("No base Datastream for {}", (Object)base.getBaseName());
            }
            Observation dummy = new Observation((Object)"Dummy", baseDs);
            dummy.setPhenomenonTime(new TimeObject(Interval.of((Instant)start, (Instant)end)));
            this.service.create((Entity)dummy);
            this.service.delete((Entity)dummy);
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Failed to create or delete dummy observation!", (Throwable)ex);
        }
    }

    private void reCalculateBase(AggregationBase base) {
        Instant endDateTime;
        Instant startDateTime;
        DateTimePicker startTime = new DateTimePicker(this.lastPickedStart);
        DateTimePicker endTime = new DateTimePicker(this.lastPickedEnd);
        GridPane pane = new GridPane();
        int row = 0;
        pane.add((Node)new Text(base.getBaseName()), 0, row, 2, 1);
        pane.add((Node)new Text("From"), 0, ++row);
        pane.add((Node)startTime, 1, row);
        pane.add((Node)new Text("To"), 0, ++row);
        pane.add((Node)endTime, 1, row);
        Dialog dialog = new Dialog();
        dialog.setResizable(true);
        dialog.setTitle("Re-Calculate which Period?");
        dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.CANCEL);
        dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.APPLY);
        dialog.getDialogPane().setContent((Node)pane);
        dialog.getDialogPane().setExpandableContent((Node)new Text("This will create a new Observation in the given Datastream, and directly delete it again."));
        Optional confirmation = dialog.showAndWait();
        this.lastPickedStart = startDateTime = startTime.getValue().toInstant();
        this.lastPickedEnd = endDateTime = endTime.getValue().toInstant();
        if (confirmation.isPresent() && confirmation.get() == ButtonType.APPLY) {
            LOGGER.info("Re-Calculating from {} to {} for {} ({})", new Object[]{startDateTime, endDateTime, base.getBaseName(), base.getBaseDatastream()});
            this.reCalculateBase(base, startDateTime, endDateTime);
        } else {
            LOGGER.info("Cancelled...  {} to {} for {}", new Object[]{startDateTime, endDateTime, base.getBaseName()});
        }
    }

    @FXML
    private void actionReload(ActionEvent event) {
        if (this.service == null) {
            return;
        }
        this.table.setVisible(false);
        this.progressBar.setVisible(true);
        final AggregationData myData = new AggregationData(this.service, true, true);
        Task<AggregationData> task = new Task<AggregationData>(){

            protected AggregationData call() throws Exception {
                AggregationData.ProgressListener pl = progress1 -> this.updateProgress(progress1, 1.0);
                myData.addProgressListener(pl);
                myData.getAggregationBases();
                myData.removeProgressListener(pl);
                return myData;
            }
        };
        task.setOnSucceeded(arg_0 -> this.lambda$actionReload$6((Task)task, arg_0));
        task.setOnFailed(event1 -> new Alert(Alert.AlertType.ERROR, "Loading failed: " + event1.toString(), new ButtonType[]{ButtonType.CLOSE}).show());
        this.progressBar.progressProperty().unbind();
        this.progressBar.progressProperty().bind((ObservableValue)task.progressProperty());
        new Thread((Runnable)task).start();
    }

    private void fillTableAndShow(AggregationData myData) {
        this.data = myData;
        this.baseColumn = new TableColumn("Base Name");
        this.baseColumn.setCellValueFactory(param -> ((AggregationBase)param.getValue()).getFxProperties().getBaseNameProperty());
        this.buttonColumn = new TableColumn("\u21ba");
        this.buttonColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((AggregationBase)param.getValue())));
        this.buttonColumn.setCellFactory(param -> new ButtonTableCell<AggregationBase, AggregationBase>("\u21ba"){

            @Override
            public void onAction(TableRow<AggregationBase> row) {
                ControllerAggManager.this.reCalculateBase((AggregationBase)row.getItem());
            }
        });
        this.columnsByLevel.clear();
        for (AggregationBase base : this.data.getAggregationBases()) {
            for (AggregateCombo combo : base.getCombos()) {
                this.getColumnForLevel(combo.level);
            }
        }
        this.table.getColumns().clear();
        this.table.getColumns().add(this.baseColumn);
        this.table.getColumns().add(this.buttonColumn);
        this.table.getColumns().addAll(this.columnsByLevel.values());
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.table.setItems(FXCollections.observableArrayList(this.data.getAggregationBases()));
        this.progressBar.setVisible(false);
        this.table.setVisible(true);
    }

    @FXML
    private void actionAddLevel(ActionEvent event) {
        AggregationLevel level = new AggregationLevel();
        try {
            level.configure(this.levelEditor.getConfig(), null, null, null);
        }
        catch (ConfigurationException ex) {
            LOGGER.error("Failed to configure aggregation level.");
        }
        TableColumn<AggregationBase, Boolean> column = this.getColumnForLevel(level);
        if (this.table.getColumns().contains(column)) {
            LOGGER.info("Column {} already exists.", (Object)level);
        } else {
            this.table.getColumns().add(column);
        }
    }

    @FXML
    private void actionApplyChanges(ActionEvent event) throws ServiceFailureException {
        List<String> changeLog = this.generateChangeLog();
        StringBuilder changeString = new StringBuilder();
        for (String line : changeLog) {
            changeString.append(line);
        }
        Dialog dialog = new Dialog();
        dialog.setResizable(true);
        dialog.setTitle("Apply changes?");
        dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.CANCEL);
        dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.APPLY);
        TextArea textArea = new TextArea(changeString.toString());
        textArea.setEditable(false);
        textArea.setWrapText(false);
        dialog.getDialogPane().setContent((Node)textArea);
        Optional confirmation = dialog.showAndWait();
        if (confirmation.isPresent() && confirmation.get() == ButtonType.APPLY) {
            LOGGER.info("Working");
            this.applyChangesTask(changeLog.size());
        } else {
            LOGGER.info("Cancelled");
        }
    }

    private void applyChangesTask(final int count) {
        final SimpleDoubleProperty progress = new SimpleDoubleProperty(0.0);
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                ControllerAggManager.this.applyChanges(progress, count);
                return null;
            }
        };
        task.setOnSucceeded(event1 -> this.actionReload(null));
        task.setOnFailed(event1 -> new Alert(Alert.AlertType.ERROR, "Update Failed: " + event1.toString(), new ButtonType[]{ButtonType.CLOSE}).show());
        this.table.setVisible(false);
        this.progressBar.progressProperty().unbind();
        this.progressBar.progressProperty().bind((ObservableValue)progress);
        this.progressBar.setVisible(true);
        new Thread((Runnable)task).start();
    }

    private void createAggregate(AggregationBase base, AggregationLevel level) throws ServiceFailureException {
        LOGGER.info("Creating {} for {}.", (Object)level, (Object)base.getBaseName());
        Datastream baseDs = base.getBaseDatastream();
        ObservedProperty op = baseDs.getObservedProperty();
        UnitOfMeasurement uom = baseDs.getUnitOfMeasurement();
        this.utils.findOrCreateAggregateOps(this.service, op);
        ArrayList<ObservedProperty> ops = new ArrayList<ObservedProperty>();
        ops.add(op);
        ops.addAll((Collection)this.utils.aggregateProperties.get(op));
        ArrayList<UnitOfMeasurement> uoms = new ArrayList<UnitOfMeasurement>();
        for (ObservedProperty op1 : ops) {
            uoms.add(uom);
        }
        HashMap<String, Object> aggProps = new HashMap<String, Object>();
        aggProps.put("aggregateSource.Datastream@iot.id", baseDs.getId().getValue());
        aggProps.put("aggregateFor", "/Datastreams(" + baseDs.getId().getUrl() + ")");
        aggProps.put("aggregateAmount", level.amount);
        aggProps.put("aggregateUnit", level.unit.toString());
        String mdsName = base.getBaseName() + " " + level.toPostFix();
        String mdsDesc = baseDs.getDescription() + " aggregated per " + level.amount + " " + level.unit;
        this.utils.findOrCreateMultiDatastream(this.service, mdsName, mdsDesc, uoms, baseDs.getThing(), ops, baseDs.getSensor(), aggProps);
    }

    private void deleteAggregate(AggregationBase base, AggregationLevel level) {
        AggregateCombo combo = base.getCombosByLevel().get(level);
        if (combo == null) {
            LOGGER.error("Can not delete {} for {}, no such combo.", (Object)level, (Object)base.getBaseName());
            return;
        }
        LOGGER.error("Deleting {} for {}", (Object)level, (Object)base.getBaseName());
        try {
            this.service.delete((Entity)combo.target);
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Failed to delete {}", (Object)combo.target);
            LOGGER.error("Failed to delete:", (Throwable)ex);
        }
    }

    private void applyChanges(SimpleDoubleProperty progress, int changeCount) throws ServiceFailureException {
        int nr = 0;
        for (AggregationBase base : this.data.getAggregationBases()) {
            Map<AggregationLevel, AggregateCombo> presentLevels = base.getCombosByLevel();
            Map<AggregationLevel, Boolean> wantedLevels = base.getWantedLevels();
            for (Map.Entry<AggregationLevel, Boolean> wantedEntry : wantedLevels.entrySet()) {
                AggregationLevel level = wantedEntry.getKey();
                boolean wanted = wantedEntry.getValue();
                if (wanted && !presentLevels.containsKey(level)) {
                    ++nr;
                    this.createAggregate(base, level);
                    continue;
                }
                if (wanted || !presentLevels.containsKey(level)) continue;
                ++nr;
                this.deleteAggregate(base, level);
            }
            progress.set(1.0 * (double)nr / (double)changeCount);
        }
    }

    private List<String> generateChangeLog() {
        ArrayList<String> changeLog = new ArrayList<String>();
        for (AggregationBase base : this.data.getAggregationBases()) {
            Map<AggregationLevel, AggregateCombo> presentLevels = base.getCombosByLevel();
            Map<AggregationLevel, Boolean> wantedLevels = base.getWantedLevels();
            for (Map.Entry<AggregationLevel, Boolean> wantedEntry : wantedLevels.entrySet()) {
                AggregationLevel level = wantedEntry.getKey();
                boolean wanted = wantedEntry.getValue();
                if (wanted && !presentLevels.containsKey(level)) {
                    changeLog.add("Create " + level.toString() + " for " + base.getBaseName() + "\n");
                    continue;
                }
                if (wanted || !presentLevels.containsKey(level)) continue;
                changeLog.add("DELETE " + level.toString() + " for " + base.getBaseName() + "\n");
            }
        }
        return changeLog;
    }

    private /* synthetic */ void lambda$actionReload$6(Task task, WorkerStateEvent event1) {
        this.fillTableAndShow((AggregationData)task.getValue());
    }
}

