/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Spinner;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;

public class DateTimePicker
extends GridPane {
    public static final ZoneId ZONE_UTC = ZoneId.of("Z");
    final ZonedDateTime initialValue;
    private DatePicker date;
    private Spinner<Integer> hour;
    private Spinner<Integer> minute;

    public DateTimePicker() {
        this(ZonedDateTime.now());
    }

    public DateTimePicker(Instant initialValue) {
        if (initialValue == null) {
            initialValue = Instant.now();
        }
        this.initialValue = initialValue.atZone(ZONE_UTC);
        this.buildGui();
    }

    public DateTimePicker(ZonedDateTime initialValue) {
        if (initialValue == null) {
            initialValue = ZonedDateTime.now();
        }
        this.initialValue = initialValue;
        this.buildGui();
    }

    private void buildGui() {
        this.date = new DatePicker(this.initialValue.toLocalDate());
        int startHourVal = this.initialValue.get(ChronoField.HOUR_OF_DAY);
        this.hour = new Spinner(0, 23, startHourVal);
        this.hour.setEditable(true);
        this.hour.setPrefWidth(80.0);
        int startMinuteVal = this.initialValue.get(ChronoField.MINUTE_OF_HOUR);
        this.minute = new Spinner(0, 59, startMinuteVal);
        this.minute.setEditable(true);
        this.minute.setPrefWidth(80.0);
        this.add((Node)this.date, 1, 0);
        this.add((Node)this.hour, 2, 0);
        this.add((Node)new Text(":"), 3, 0);
        this.add((Node)this.minute, 4, 0);
    }

    public ZonedDateTime getValue() {
        return ZonedDateTime.of((LocalDate)this.date.getValue(), LocalTime.of((Integer)this.hour.getValue(), (Integer)this.minute.getValue()), ZONE_UTC);
    }

    public ZonedDateTime getValue(ZoneId zoneId) {
        return ZonedDateTime.of((LocalDate)this.date.getValue(), LocalTime.of((Integer)this.hour.getValue(), (Integer)this.minute.getValue()), zoneId);
    }
}

