/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.controller;

import de.fraunhofer.iosb.ilt.sensorthingsmanager.controller.ControllerEntity;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.controller.EntityGuiController;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.FeatureOfInterest;
import de.fraunhofer.iosb.ilt.sta.model.HistoricalLocation;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;

public class FactoryEntityPanel {
    private static final String ENTITY_PANE_FXML = "/fxml/PaneEntity.fxml";

    public static <T extends Entity<T>> Node getPane(SensorThingsService service, EntityType type, T entity, boolean showNavProps) throws IOException {
        if (entity != null && entity.getType() != type) {
            throw new IllegalArgumentException("Entity must have given type or be null.");
        }
        switch (type) {
            case DATASTREAM: {
                return FactoryEntityPanel.getDatastreamPane(service, (Datastream)entity, showNavProps);
            }
            case FEATURE_OF_INTEREST: {
                return FactoryEntityPanel.getFeatureOfInterestPane(service, (FeatureOfInterest)entity, showNavProps);
            }
            case HISTORICAL_LOCATION: {
                return FactoryEntityPanel.getHistoricalLocationPane(service, (HistoricalLocation)entity, showNavProps);
            }
            case LOCATION: {
                return FactoryEntityPanel.getLocationPane(service, (Location)entity, showNavProps);
            }
            case MULTIDATASTREAM: {
                return FactoryEntityPanel.getMultiDatastreamPane(service, (MultiDatastream)entity, showNavProps);
            }
            case OBSERVATION: {
                return FactoryEntityPanel.getObservationPane(service, (Observation)entity, showNavProps);
            }
            case OBSERVED_PROPERTY: {
                return FactoryEntityPanel.getObsPropPane(service, (ObservedProperty)entity, showNavProps);
            }
            case SENSOR: {
                return FactoryEntityPanel.getSensorPane(service, (Sensor)entity, showNavProps);
            }
            case THING: {
                return FactoryEntityPanel.getThingPane(service, (Thing)entity, showNavProps);
            }
        }
        return null;
    }

    public static Node getDatastreamPane(SensorThingsService service, Datastream entity, boolean showNavProps) throws IOException {
        if (entity == null) {
            return new Label("No Datastream.");
        }
        FXMLLoader loader = new FXMLLoader(FactoryEntityPanel.class.getResource(ENTITY_PANE_FXML));
        Pane content = (Pane)loader.load();
        ControllerEntity controller = (ControllerEntity)loader.getController();
        controller.setEntity(service, entity, new EntityGuiController.GuiControllerDatastream(), showNavProps);
        return content;
    }

    public static Node getFeatureOfInterestPane(SensorThingsService service, FeatureOfInterest entity, boolean showNavProps) throws IOException {
        FXMLLoader loader = new FXMLLoader(FactoryEntityPanel.class.getResource(ENTITY_PANE_FXML));
        Pane content = (Pane)loader.load();
        ControllerEntity controller = (ControllerEntity)loader.getController();
        controller.setEntity(service, entity, new EntityGuiController.GuiControllerFeatureOfInterest(), showNavProps);
        return content;
    }

    public static Node getHistoricalLocationPane(SensorThingsService service, HistoricalLocation entity, boolean showNavProps) throws IOException {
        FXMLLoader loader = new FXMLLoader(FactoryEntityPanel.class.getResource(ENTITY_PANE_FXML));
        Pane content = (Pane)loader.load();
        ControllerEntity controller = (ControllerEntity)loader.getController();
        controller.setEntity(service, entity, new EntityGuiController.GuiControllerHistoricalLocation(), showNavProps);
        return content;
    }

    public static Node getLocationPane(SensorThingsService service, Location entity, boolean showNavProps) throws IOException {
        FXMLLoader loader = new FXMLLoader(FactoryEntityPanel.class.getResource(ENTITY_PANE_FXML));
        Pane content = (Pane)loader.load();
        ControllerEntity controller = (ControllerEntity)loader.getController();
        controller.setEntity(service, entity, new EntityGuiController.GuiControllerLocation(), showNavProps);
        return content;
    }

    public static Node getMultiDatastreamPane(SensorThingsService service, MultiDatastream entity, boolean showNavProps) throws IOException {
        if (entity == null) {
            return new Label("No MultiDatastream.");
        }
        FXMLLoader loader = new FXMLLoader(FactoryEntityPanel.class.getResource(ENTITY_PANE_FXML));
        Pane content = (Pane)loader.load();
        ControllerEntity controller = (ControllerEntity)loader.getController();
        controller.setEntity(service, entity, new EntityGuiController.GuiControllerMultiDatastream(), showNavProps);
        return content;
    }

    public static Node getObservationPane(SensorThingsService service, Observation entity, boolean showNavProps) throws IOException {
        FXMLLoader loader = new FXMLLoader(FactoryEntityPanel.class.getResource(ENTITY_PANE_FXML));
        Pane content = (Pane)loader.load();
        ControllerEntity controller = (ControllerEntity)loader.getController();
        controller.setEntity(service, entity, new EntityGuiController.GuiControllerObservation(), showNavProps);
        return content;
    }

    public static Node getObsPropPane(SensorThingsService service, ObservedProperty entity, boolean showNavProps) throws IOException {
        FXMLLoader loader = new FXMLLoader(FactoryEntityPanel.class.getResource(ENTITY_PANE_FXML));
        Pane content = (Pane)loader.load();
        ControllerEntity controller = (ControllerEntity)loader.getController();
        controller.setEntity(service, entity, new EntityGuiController.GuiControllerObsProp(), showNavProps);
        return content;
    }

    public static Node getSensorPane(SensorThingsService service, Sensor entity, boolean showNavProps) throws IOException {
        FXMLLoader loader = new FXMLLoader(FactoryEntityPanel.class.getResource(ENTITY_PANE_FXML));
        Pane content = (Pane)loader.load();
        ControllerEntity controller = (ControllerEntity)loader.getController();
        controller.setEntity(service, entity, new EntityGuiController.GuiControllerSensor(), showNavProps);
        return content;
    }

    public static Node getThingPane(SensorThingsService service, Thing entity, boolean showNavProps) throws IOException {
        FXMLLoader loader = new FXMLLoader(FactoryEntityPanel.class.getResource(ENTITY_PANE_FXML));
        Pane content = (Pane)loader.load();
        ControllerEntity controller = (ControllerEntity)loader.getController();
        controller.setEntity(service, entity, new EntityGuiController.GuiControllerThing(), showNavProps);
        return content;
    }
}

