/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.controller;

import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.ControllerAggManager;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.controller.ControllerCleaner;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.controller.ControllerCollection;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.utils.Server;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.FeatureOfInterest;
import de.fraunhofer.iosb.ilt.sta.model.HistoricalLocation;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.query.Query;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerServer
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerServer.class);
    private Server entry;
    @FXML
    private Label serverTitle;
    @FXML
    private TabPane collectionTabs;
    private SensorThingsService service;

    public void initialize(URL location, ResourceBundle resources) {
    }

    public void setServerEntry(Server entry) {
        this.entry = entry;
        this.serverTitle.setText(entry.getName() + " @ " + entry.getUrl());
        try {
            this.service = new SensorThingsService(new URL(entry.getUrl()));
            if (entry.getAuthMethod() != null) {
                entry.getAuthMethod().setAuth(this.service);
            }
            this.addTabFor("Things", "name asc", this.service.things().query(), () -> {
                Thing entity = new Thing();
                entity.setName("New Thing");
                return entity;
            });
            this.addTabFor("Sensors", "name asc", this.service.sensors().query(), () -> {
                Sensor entity = new Sensor();
                entity.setName("New Sensor");
                return entity;
            });
            this.addTabFor("Datastreams", "name asc", this.service.datastreams().query(), () -> {
                Datastream entity = new Datastream();
                entity.setName("New Datastream");
                return entity;
            });
            this.addTabFor("MultiDtstrms", "name asc", this.service.multiDatastreams().query(), () -> {
                MultiDatastream entity = new MultiDatastream();
                entity.setName("New MultiDatastream");
                return entity;
            });
            this.addTabFor("ObsrvdProps", "name asc", this.service.observedProperties().query(), () -> {
                ObservedProperty entity = new ObservedProperty();
                entity.setName("New ObservedProperty");
                return entity;
            });
            this.addTabFor("Locations", "name asc", this.service.locations().query(), () -> {
                Location entity = new Location();
                entity.setName("New Location");
                return entity;
            });
            this.addTabFor("HistLctns", "time desc", this.service.historicalLocations().query(), () -> {
                HistoricalLocation entity = new HistoricalLocation();
                return entity;
            });
            this.addTabFor("Observations", "phenomenonTime asc", this.service.observations().query(), () -> {
                Observation entity = new Observation();
                return entity;
            });
            this.addTabFor("FoIs", "name asc", this.service.featuresOfInterest().query(), () -> {
                FeatureOfInterest entity = new FeatureOfInterest();
                entity.setName("New FeatureOfInterest");
                return entity;
            });
            this.addCleanerTab();
            this.addAggregationTab();
        }
        catch (MalformedURLException ex) {
            LOGGER.error("Failed to create service url.", (Throwable)ex);
        }
    }

    private <T extends Entity<T>> void addTabFor(String title, String orderBy, Query<T> query, ControllerCollection.EntityFactory<T> factory) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/Collection.fxml"));
            AnchorPane content = (AnchorPane)loader.load();
            ControllerCollection controller = (ControllerCollection)loader.getController();
            controller.setQuery(query, factory, orderBy);
            Tab tab = new Tab(title);
            tab.setContent((Node)content);
            this.collectionTabs.getTabs().add((Object)tab);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to load Tab.", (Throwable)ex);
        }
    }

    private void addCleanerTab() {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/Cleaner.fxml"));
            BorderPane content = (BorderPane)loader.load();
            ControllerCleaner controller = (ControllerCleaner)loader.getController();
            controller.setService(this.service);
            Tab tab = new Tab("Cleaner");
            tab.setContent((Node)content);
            this.collectionTabs.getTabs().add((Object)tab);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to load Tab.", (Throwable)ex);
        }
    }

    private void addAggregationTab() {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/AggregationManager.fxml"));
            BorderPane content = (BorderPane)loader.load();
            ControllerAggManager controller = (ControllerAggManager)loader.getController();
            controller.setService(this.service);
            Tab tab = new Tab("Aggregations");
            tab.setContent((Node)content);
            this.collectionTabs.getTabs().add((Object)tab);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to load Tab.", (Throwable)ex);
        }
    }
}

