/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.controller;

import de.fraunhofer.iosb.ilt.sensorthingsmanager.controller.EntityGuiController;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.utils.Utils;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Accordion;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerEntity<T extends Entity<T>>
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerEntity.class);
    @FXML
    private Label labelId;
    @FXML
    private Label labelType;
    @FXML
    private Accordion accordionLinks;
    @FXML
    private GridPane gridProperties;
    @FXML
    private SplitPane splitPaneMain;
    @FXML
    private Button buttonSave;
    private T entity;
    private EntityGuiController<T> controller;
    private SensorThingsService service;

    @FXML
    private void actionSave(ActionEvent event) {
        this.controller.saveFields();
        try {
            if (this.entity.getId() == null) {
                this.service.create(this.entity);
                this.controller.loadFields();
            } else {
                this.entity.getService().update(this.entity);
                this.controller.loadFields();
            }
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Failed to update entity.", (Throwable)ex);
            Utils.showAlert(Alert.AlertType.ERROR, "Failed to update", "Failed to update the entity.", ex);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    public T getEntity() {
        return this.entity;
    }

    public ControllerEntity setEntity(SensorThingsService service, T entity, EntityGuiController<T> controller, boolean showNavigationProperties) {
        this.service = service;
        this.entity = entity;
        this.controller = controller;
        this.labelType.setText(controller.getType().getName());
        if (entity != null && showNavigationProperties) {
            controller.init(service, entity, this.gridProperties, this.accordionLinks, this.labelId, true);
        } else {
            this.splitPaneMain.getItems().remove((Object)this.accordionLinks);
            controller.init(service, entity, this.gridProperties, null, this.labelId, false);
            this.buttonSave.setVisible(false);
        }
        controller.loadFields();
        return this;
    }

    public EntityGuiController<T> getController() {
        return this.controller;
    }
}

