/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.controller;

import de.fraunhofer.iosb.ilt.sensorthingsmanager.controller.EntityGuiController;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.controller.EntityListEntry;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.controller.FactoryEntityPanel;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.utils.Utils;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.StatusCodeException;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.Id;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.query.Query;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.BorderPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerCollection<T extends Entity<T>>
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerCollection.class);
    @FXML
    private Button buttonReload;
    @FXML
    private Button buttonNext;
    @FXML
    private Button buttonAll;
    @FXML
    private Button buttonDelete;
    @FXML
    private Button buttonNew;
    @FXML
    private Button buttonAdd;
    @FXML
    private ToggleButton buttonFilter;
    private String filter = "";
    @FXML
    private ToggleButton buttonSelect;
    private String select = "";
    @FXML
    private ToggleButton buttonOrder;
    private String orderby = "";
    @FXML
    private BorderPane paneSelected;
    @FXML
    private TableView<EntityListEntry<T>> entityTable;
    @FXML
    private TableColumn<EntityListEntry<T>, String> columnName;
    private TableColumn<EntityListEntry<T>, ?> columnId;
    private final ObservableList<EntityListEntry<T>> entities = FXCollections.observableArrayList();
    private EntityList<T> currentQueryList;
    private Query<T> query;
    private boolean canCreate = false;
    private boolean canDelete = false;
    private boolean canLinkNew = false;
    private EntityGuiController.ChildSetter<T> childSetter;
    private boolean canMultiSelect = false;
    private EntityFactory<T> entityFactory;
    private boolean showNavigationProperties = true;

    @FXML
    private void actionButtonReload(ActionEvent event) {
        try {
            this.addOptionsToQuery();
            this.currentQueryList = this.query.list();
            this.loadEntities();
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Failed to fetch entity list.", (Throwable)ex);
            Utils.showAlert(Alert.AlertType.ERROR, "Failed to reload", "Reloading the set of entities failed.", ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.trace("Failed to fetch entity list.", (Throwable)ex);
        }
    }

    @FXML
    private void actionButtonNext(ActionEvent event) {
        if (this.currentQueryList == null || !this.currentQueryList.hasNextLink()) {
            return;
        }
        try {
            this.currentQueryList.fetchNext();
        }
        catch (StatusCodeException ex) {
            LOGGER.error("Failed to fetch next set of entities.", (Throwable)ex);
            Utils.showAlert(Alert.AlertType.ERROR, "Failed to fetch", "Fetching the next set of entities failed for url: " + ex.getUrl(), ex);
        }
        this.loadEntities();
    }

    @FXML
    private void actionButtonAll(ActionEvent event) {
        try {
            this.addOptionsToQuery();
            this.currentQueryList = this.query.top(500).list();
            this.loadAllEntities();
        }
        catch (StatusCodeException ex) {
            LOGGER.error("Failed to fetch entity list.", (Throwable)ex);
            Utils.showAlert(Alert.AlertType.ERROR, "Failed to fetch", "Fetching the set of all entities failed for url: " + ex.getUrl(), ex);
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Failed to fetch entity list.", (Throwable)ex);
            Utils.showAlert(Alert.AlertType.ERROR, "Failed to fetch", "Fetching the set of all entities failed.", ex);
        }
    }

    @FXML
    private void actionButtonFilter(ActionEvent event) {
        LOGGER.info("Filter button clicked.");
        if (this.buttonFilter.isSelected()) {
            TextInputDialog textInputDialog = new TextInputDialog(this.filter);
            textInputDialog.setHeaderText("Set filter");
            textInputDialog.setResizable(true);
            Optional filterOptional = textInputDialog.showAndWait();
            this.filter = filterOptional.isPresent() ? (String)filterOptional.get() : "";
        }
    }

    @FXML
    private void actionButtonSelect(ActionEvent event) {
        LOGGER.info("Select button clicked.");
        if (this.buttonSelect.isSelected()) {
            TextInputDialog textInputDialog = new TextInputDialog(this.select);
            textInputDialog.setHeaderText("Set select");
            textInputDialog.setResizable(true);
            Optional selectOptional = textInputDialog.showAndWait();
            this.select = selectOptional.isPresent() ? (String)selectOptional.get() : "";
        }
    }

    @FXML
    private void actionButtonOrder(ActionEvent event) {
        LOGGER.info("Order button clicked.");
        if (this.buttonOrder.isSelected()) {
            TextInputDialog textInputDialog = new TextInputDialog(this.orderby);
            textInputDialog.setHeaderText("Set OrderBy");
            textInputDialog.setResizable(true);
            Optional orderByOptional = textInputDialog.showAndWait();
            this.orderby = orderByOptional.isPresent() ? (String)orderByOptional.get() : "";
        }
    }

    @FXML
    private void actionDelete(ActionEvent event) {
        if (!this.canDelete) {
            return;
        }
        ObservableList selectedItems = this.entityTable.getSelectionModel().getSelectedItems();
        ArrayList<EntityListEntry> toDelete = new ArrayList<EntityListEntry>();
        for (EntityListEntry selectedItem : selectedItems) {
            toDelete.add(selectedItem);
        }
        String what = selectedItems.size() == 1 ? "Item " + ((EntityListEntry)selectedItems.get(0)).getEntity().getId().toString() : "all " + selectedItems.size() + " items";
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Delete " + what + " ?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
        alert.showAndWait();
        if (alert.getResult() == ButtonType.YES) {
            try {
                for (EntityListEntry selectedItem : toDelete) {
                    Object entity = selectedItem.getEntity();
                    if (entity.getId() == null) {
                        this.entities.remove((Object)selectedItem);
                        continue;
                    }
                    LOGGER.info("Deleting " + entity);
                    entity.getService().delete(entity);
                    this.entities.remove((Object)selectedItem);
                }
            }
            catch (ServiceFailureException ex) {
                LOGGER.warn("Failed to delete entity.", (Throwable)ex);
                Utils.showAlert(Alert.AlertType.ERROR, "Failed to delete", "Failed to delete an entity.", ex);
            }
        }
    }

    @FXML
    private void actionNew(ActionEvent event) {
        if (!this.canCreate) {
            return;
        }
        EntityListEntry newItem = new EntityListEntry<T>().setEntity(this.entityFactory.createEntity());
        this.entities.add(newItem);
        this.entityTable.getSelectionModel().select(newItem);
    }

    @FXML
    private void actionAdd(ActionEvent event) {
        if (this.childSetter == null) {
            new Alert(Alert.AlertType.ERROR, "No childSetter defined.", new ButtonType[]{ButtonType.CLOSE}).showAndWait();
            return;
        }
        Class entityClass = this.query.getEntityClass();
        Query allQuery = new Query(this.query.getService(), entityClass);
        Optional result = EntityGuiController.entitySearchDialog(allQuery, true, this.orderby);
        if (result.isPresent() && !result.get().isEmpty()) {
            List newChildren = result.get();
            this.childSetter.setChildren(newChildren);
        }
    }

    private void addOptionsToQuery() {
        if (this.buttonFilter.isSelected() && !this.filter.isEmpty()) {
            this.query.filter(this.filter);
        } else {
            this.query.filter("");
        }
        if (this.buttonSelect.isSelected() && !this.select.isEmpty()) {
            this.query.select(new String[]{this.select});
        } else {
            this.query.select(new String[0]);
        }
        if (!this.orderby.isEmpty()) {
            this.query.orderBy(this.orderby);
        }
    }

    public void setOrderby(String orderby) {
        this.orderby = orderby;
    }

    private void loadEntities() {
        this.entities.clear();
        for (Entity entity : this.currentQueryList) {
            this.entities.add(new EntityListEntry<Entity>().setEntity(entity));
        }
        this.createIdColumn();
        this.buttonNext.setDisable(!this.currentQueryList.hasNextLink());
        this.buttonDelete.setDisable(true);
        this.entityTable.sort();
    }

    private void loadAllEntities() {
        int i = 0;
        this.entities.clear();
        Iterator it = this.currentQueryList.fullIterator();
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            this.entities.add(new EntityListEntry<Entity>().setEntity(entity));
            if (++i < 500) continue;
            LOGGER.warn("Warning after {}. Total: {}.", (Object)i, (Object)this.entities.size());
            Optional result = new Alert(Alert.AlertType.WARNING, "Already loaded " + this.entities.size() + " Entities.\nContinue loading?", new ButtonType[]{ButtonType.CANCEL, ButtonType.YES}).showAndWait();
            if (!result.isPresent() || result.get() != ButtonType.YES) break;
            i = 0;
        }
        this.createIdColumn();
        this.buttonNext.setDisable(!this.currentQueryList.hasNextLink());
        this.buttonDelete.setDisable(true);
        this.entityTable.sort();
    }

    private void entitySelected(EntityListEntry<T> newValue) {
        if (newValue == null) {
            this.buttonDelete.setDisable(true);
            return;
        }
        try {
            T entity = newValue.getEntity();
            Node pane = FactoryEntityPanel.getPane(this.query.getService(), entity.getType(), entity, this.showNavigationProperties);
            this.paneSelected.setCenter(pane);
            this.buttonDelete.setDisable(false);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to create pane for entity.", (Throwable)ex);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.columnName.setCellValueFactory(param -> {
            Object entity = ((EntityListEntry)param.getValue()).getEntity();
            Id id = entity.getId();
            String entityString = entity.toString();
            if (id != null && entityString.startsWith(id.toString())) {
                entityString = entityString.substring(id.toString().length()).trim();
            }
            return new ReadOnlyObjectWrapper((Object)entityString);
        });
        this.entityTable.setItems(this.entities);
        this.entityTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.entityTable.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.entitySelected((EntityListEntry<T>)newValue));
    }

    private void createIdColumn() {
        if (this.entities.isEmpty() || this.columnId != null) {
            return;
        }
        Id id = ((EntityListEntry)this.entities.get(0)).getEntity().getId();
        if (id == null) {
            return;
        }
        if (id.getValue() instanceof Number) {
            TableColumn column = new TableColumn("ID");
            column.setCellValueFactory(param -> {
                if (((EntityListEntry)param.getValue()).getEntity().getId() == null) {
                    return new ReadOnlyObjectWrapper((Object)-1);
                }
                return new ReadOnlyObjectWrapper((Object)((Number)((EntityListEntry)param.getValue()).getEntity().getId().getValue()));
            });
            this.columnId = column;
        } else {
            TableColumn column = new TableColumn("ID");
            column.setCellValueFactory(param -> {
                if (((EntityListEntry)param.getValue()).getEntity().getId() == null) {
                    return new ReadOnlyObjectWrapper((Object)"");
                }
                return new ReadOnlyObjectWrapper((Object)((EntityListEntry)param.getValue()).getEntity().getId().toString());
            });
            this.columnId = column;
        }
        this.entityTable.getColumns().add(0, this.columnId);
    }

    public Query getQuery() {
        return this.query;
    }

    public ControllerCollection setQuery(Query query, EntityFactory<T> entityFactory, String orderBy) {
        this.query = query;
        this.canCreate = true;
        this.canDelete = true;
        this.orderby = orderBy;
        this.entityFactory = entityFactory;
        this.buttonDelete.setVisible(this.canDelete);
        this.buttonNew.setVisible(this.canCreate);
        this.buttonAdd.setVisible(this.canLinkNew);
        return this;
    }

    public ControllerCollection setQuery(Query query, boolean showNavigationProperties, boolean canDelete, boolean canLinkNew, boolean multiSelect, String orderBy) {
        this.query = query;
        this.canCreate = false;
        this.canLinkNew = canLinkNew;
        this.canDelete = canDelete;
        this.showNavigationProperties = showNavigationProperties;
        this.canMultiSelect = multiSelect;
        this.orderby = orderBy;
        this.buttonDelete.setVisible(canDelete);
        this.buttonNew.setVisible(this.canCreate);
        this.buttonAdd.setVisible(canLinkNew);
        this.entityTable.getSelectionModel().setSelectionMode(this.canMultiSelect ? SelectionMode.MULTIPLE : SelectionMode.SINGLE);
        return this;
    }

    public void setChildSetter(EntityGuiController.ChildSetter<T> childSetter) {
        this.childSetter = childSetter;
    }

    public T getSelectedEntity() {
        EntityListEntry item = (EntityListEntry)this.entityTable.getSelectionModel().getSelectedItem();
        if (item == null) {
            return null;
        }
        return item.getEntity();
    }

    public List<T> getSelectedEntities() {
        ObservableList items = this.entityTable.getSelectionModel().getSelectedItems();
        if (items == null) {
            return null;
        }
        ArrayList values = new ArrayList();
        for (EntityListEntry item : items) {
            values.add(item.getEntity());
        }
        return values;
    }

    public static interface EntityFactory<T extends Entity<T>> {
        public T createEntity();
    }
}

