/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.auth;

import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorPassword;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.auth.AuthMethod;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.io.IOException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthPostCookie
implements AnnotatedConfigurable<Void, Void>,
AuthMethod {
    public static final String HTTPREQUEST_HEADER_ACCEPT = "Accept";
    public static final String HTTPREQUEST_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HTTPREQUEST_TYPE_JSON = "application/json";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthPostCookie.class);
    @ConfigurableField(editor=EditorString.class, label="PostUrl", description="The url to post to, use placeholders {username} and {password} for username and password.", optional=false)
    @EditorString.EdOptsString(dflt="https://example.org/servlet/is/rest/login?user={username}&key={password}")
    private String postUrl;
    @ConfigurableField(editor=EditorString.class, label="Username", description="The username to use for authentication", optional=false)
    @EditorString.EdOptsString
    private String username;
    @ConfigurableField(editor=EditorPassword.class, label="Password", description="The password to use for authentication", optional=false)
    @EditorPassword.EdOptsPassword
    private String password;

    @Override
    public void setAuth(SensorThingsService service) {
        String finalUrl = this.postUrl.replace("{username}", this.username);
        finalUrl = finalUrl.replace("{password}", this.password);
        CloseableHttpClient client = service.getHttpClient();
        HttpPost loginPost = new HttpPost(finalUrl);
        loginPost.setHeader(HTTPREQUEST_HEADER_ACCEPT, HTTPREQUEST_TYPE_JSON);
        try {
            client.execute((HttpUriRequest)loginPost);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to login.", (Throwable)ex);
        }
    }
}

