/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation;

import de.fraunhofer.iosb.ilt.configurable.AbstractConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorEnum;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorInt;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.Utils;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import org.apache.commons.lang3.builder.CompareToBuilder;

public class AggregationLevel
extends AbstractConfigurable<Void, Void>
implements Comparable<AggregationLevel> {
    @ConfigurableField(editor=EditorEnum.class, label="Unit", description="The unit of the given amount.")
    @EditorEnum.EdOptsEnum(sourceType=ChronoUnit.class, dflt="HOURS")
    public TemporalUnit unit;
    @ConfigurableField(editor=EditorInt.class, label="Amount", description="The amount of the given unit.")
    @EditorInt.EdOptsInt(min=1, max=0x7FFFFFFF, step=1, dflt=1)
    public int amount;
    public Duration duration;

    public AggregationLevel() {
    }

    public void setUnit(TemporalUnit unit) {
        if (this.unit != null) {
            throw new IllegalStateException("The unit of an aggregation level must not be changed. Already is: " + this.unit);
        }
        this.unit = unit;
        this.calculateDuration();
    }

    public void setAmount(int amount) {
        if (this.amount != 0) {
            throw new IllegalStateException("The amount of an aggregation level must not be changed. Already is: " + this.amount);
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("Aggregation Levels must have a positive, non-zero amount. Given: " + amount);
        }
        this.amount = amount;
        this.calculateDuration();
    }

    private void calculateDuration() {
        if (this.unit != null && this.amount != 0) {
            this.duration = this.unit.getDuration().multipliedBy(this.amount);
        }
    }

    public static AggregationLevel of(String postfix) {
        String[] split;
        if ((postfix = postfix.trim()).startsWith("[")) {
            postfix = postfix.substring(1);
        }
        if (postfix.endsWith("]")) {
            postfix = postfix.substring(0, postfix.length() - 1);
        }
        if ((split = postfix.split(" ")).length != 2) {
            return null;
        }
        int amount = Integer.parseInt(split[0]);
        ChronoUnit unit = AggregationLevel.getUnit(split[1]);
        if (unit == null) {
            return null;
        }
        return new AggregationLevel(unit, amount);
    }

    public static boolean isPostfix(String postfix) {
        return AggregationLevel.of(postfix) != null;
    }

    public static boolean nameHasPostfix(String dsName) {
        return Utils.POSTFIX_PATTERN.matcher(dsName).matches();
    }

    private static ChronoUnit getUnit(String unitString) {
        unitString = unitString.toUpperCase();
        try {
            ChronoUnit unit = ChronoUnit.valueOf(unitString);
            return unit;
        }
        catch (IllegalArgumentException unit) {
            try {
                ChronoUnit unit2 = ChronoUnit.valueOf(unitString + "S");
                return unit2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    public AggregationLevel(TemporalUnit unit, int amount) {
        this.unit = unit;
        this.amount = amount;
        this.duration = unit.getDuration().multipliedBy(amount);
    }

    public ZonedDateTime toIntervalStart(ZonedDateTime time) {
        ZonedDateTime start;
        switch (ChronoUnit.valueOf(this.unit.toString().toUpperCase())) {
            case SECONDS: {
                start = time.truncatedTo(ChronoUnit.MINUTES);
                break;
            }
            case MINUTES: {
                start = time.truncatedTo(ChronoUnit.HOURS);
                break;
            }
            case HOURS: {
                start = time.truncatedTo(ChronoUnit.DAYS);
                break;
            }
            case DAYS: {
                start = time.with(TemporalAdjusters.firstDayOfYear()).truncatedTo(ChronoUnit.DAYS);
                break;
            }
            default: {
                start = time.with(TemporalAdjusters.firstDayOfYear()).truncatedTo(ChronoUnit.DAYS);
            }
        }
        long haveMillis = Duration.between(start, time).toMillis();
        long maxMillis = this.duration.toMillis();
        long periods = haveMillis / maxMillis;
        start = start.plus(this.duration.multipliedBy(periods));
        return start;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof AggregationLevel)) {
            return false;
        }
        AggregationLevel otherLevel = (AggregationLevel)obj;
        return this.duration.equals(otherLevel.duration);
    }

    public int hashCode() {
        return Objects.hash(this.duration);
    }

    @Override
    public int compareTo(AggregationLevel o) {
        return new CompareToBuilder().append((Object)this.duration, (Object)o.duration).toComparison();
    }

    public String toPostFix() {
        return "[" + this.amount + " " + this.unit + "]";
    }

    public String toString() {
        return this.amount + " " + this.unit;
    }
}

