/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation;

import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregateCombo;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregationBase;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregationLevel;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.Utils;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.query.Query;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationData {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregationData.class);
    private final SensorThingsService service;
    private final List<AggregationBase> aggregationBases = new ArrayList<AggregationBase>();
    private final Map<String, AggregationBase> aggregationBasesByName = new HashMap<String, AggregationBase>();
    private Map<String, List<AggregateCombo>> combosBySource;
    private ZoneId zoneId;
    private final boolean fixReferences;
    private final boolean addEmptyBases;
    private final boolean sourceEqualsTarget = true;
    private double progressBase = 0.0;
    private double progressTarget = 1.0;
    private final List<ProgressListener> progressListeners = new CopyOnWriteArrayList<ProgressListener>();

    public AggregationData(SensorThingsService service, boolean fixReferences, boolean addEmptyBases) {
        this.service = service;
        this.fixReferences = fixReferences;
        this.addEmptyBases = addEmptyBases;
    }

    public AggregationData(SensorThingsService service, boolean fixReferences) {
        this(service, fixReferences, true);
    }

    private AggregationBase getAggregationBase(String baseName) {
        AggregationBase aggBase = this.aggregationBasesByName.computeIfAbsent(baseName, name -> {
            AggregationBase base = new AggregationBase((String)name);
            this.aggregationBases.add(base);
            return base;
        });
        return aggBase;
    }

    private void findAllBases() {
        try {
            Query query = this.service.datastreams().query().select(new String[]{"id", "name", "description", "properties", "unitOfMeasurement"}).top(1000).orderBy("id asc");
            if (this.hasListeners()) {
                query.count();
            }
            EntityList dsList = query.list();
            long count = dsList.getCount();
            double pPart = (this.progressTarget - this.progressBase) / (double)count;
            int nr = 0;
            Iterator datastreams = dsList.fullIterator();
            while (datastreams.hasNext()) {
                Datastream datastream = (Datastream)datastreams.next();
                String name = datastream.getName();
                String base = this.baseNameFromName(name);
                AggregationBase aggregationBase = this.getAggregationBase(base);
                aggregationBase.setBaseDatastream(datastream);
                this.setProgress(this.progressBase + (double)(++nr) * pPart);
            }
            LOGGER.info("Loaded {} Datastreams", (Object)nr);
        }
        catch (ServiceFailureException exc) {
            LOGGER.error("Service error loading Datastreams: ", (Throwable)exc);
        }
    }

    private void findTargetMultiDatastreams() {
        try {
            Query query = this.service.things().query().top(1000).select(new String[]{"id,name,properties"}).orderBy("id asc").expand("MultiDatastreams($top=1000;$orderby=id asc;$select=id,name,properties)");
            if (this.hasListeners()) {
                query.count();
            }
            EntityList thingList = query.list();
            long count = thingList.getCount();
            double pPart = (this.progressTarget - this.progressBase) / (double)count;
            int nr = 0;
            Iterator thingIt = thingList.fullIterator();
            while (thingIt.hasNext()) {
                Thing thing = (Thing)thingIt.next();
                EntityList dsList = thing.getMultiDatastreams();
                Iterator it = dsList.fullIterator();
                while (it.hasNext()) {
                    MultiDatastream mds = (MultiDatastream)it.next();
                    String name = mds.getName();
                    Matcher matcher = Utils.POSTFIX_PATTERN.matcher(name);
                    if (!matcher.matches()) {
                        LOGGER.debug("MultiDatastream {} is not an aggregate.");
                        continue;
                    }
                    AggregateCombo combo = new AggregateCombo(thing, mds);
                    combo.baseName = matcher.group(1).trim();
                    String postfix = matcher.group(2);
                    combo.level = AggregationLevel.of(postfix);
                    if (combo.level == null) {
                        LOGGER.debug("Not a postfix: {}.", (Object)postfix);
                        continue;
                    }
                    combo.resolveZoneId(this.zoneId);
                    LOGGER.debug("Found: {} from {}, timeZone {}", new Object[]{combo.level, combo.target.getName(), combo.getZoneId()});
                    AggregationBase aggBase = this.getAggregationBase(combo.baseName);
                    aggBase.addCombo(combo);
                }
                this.setProgress(this.progressBase + (double)(++nr) * pPart);
            }
        }
        catch (ServiceFailureException exc) {
            LOGGER.error("Service error: ", (Throwable)exc);
        }
    }

    private void findSourceDatastreams(AggregateCombo target) {
        try {
            AggregationBase base = this.aggregationBasesByName.get(target.baseName);
            if (base != null && base.getBaseDatastream() != null) {
                target.sourceDs = base.getBaseDatastream();
                target.sourceIsAggregate = false;
                this.checkReference(target.sourceDs, target.target, target.level);
                return;
            }
            String nameQuoted = "'" + target.baseName.replaceAll("'", "''") + "'";
            List list = this.service.multiDatastreams().query().filter("name eq " + nameQuoted).top(1000).orderBy("id asc").list().toList();
            if (list.size() > 1) {
                LOGGER.warn("Multiple ({}) sources found for '{}'.", (Object)list.size(), (Object)target.baseName);
            }
            if (list.size() > 0) {
                target.sourceMds = (MultiDatastream)list.get(0);
                target.sourceIsAggregate = false;
                this.checkReference(target.sourceMds, target.target, target.level);
                return;
            }
            list = this.service.datastreams().query().filter("name eq " + nameQuoted).top(1000).orderBy("id asc").list().toList();
            if (list.isEmpty()) {
                list = this.service.datastreams().query().filter("startswith(name," + nameQuoted + ")").top(1000).orderBy("id asc").list().toList();
            }
            if (list.size() > 1) {
                LOGGER.warn("Multiple ({}) sources found for '{}'.", (Object)list.size(), (Object)target.baseName);
            }
            for (Datastream source : list) {
                String postfix = source.getName().substring(target.baseName.length());
                if (!AggregationLevel.isPostfix(postfix)) continue;
                target.sourceDs = source;
                target.sourceIsAggregate = false;
                target.sourceIsCollection = true;
                this.checkReference(target.sourceDs, target.target, target.level);
                return;
            }
            LOGGER.warn("No source found for '{}'.", (Object)target.baseName);
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Failed to find source for {}." + target.baseName);
            LOGGER.debug("Exception:", (Throwable)ex);
        }
    }

    private void findSourceDatastreams(AggregationBase base) {
        Set<AggregateCombo> comboSet = base.getCombos();
        AggregateCombo[] targets = comboSet.toArray(new AggregateCombo[comboSet.size()]);
        int i = 0;
        for (AggregateCombo target : targets) {
            int idx = i;
            boolean found = false;
            while (!found && idx > 0) {
                AggregateCombo test = targets[--idx];
                long smaller = test.level.duration.getSeconds();
                long larger = target.level.duration.getSeconds();
                if (larger % smaller != 0L) continue;
                LOGGER.debug("{}: {} ~ {} ({})", new Object[]{target.baseName, target.level, test.level, larger / smaller});
                target.sourceMds = test.target;
                target.sourceIsAggregate = true;
                found = true;
                this.checkReference(target.sourceMds, target.target, target.level);
            }
            if (!found) {
                this.findSourceDatastreams(target);
                if (target.sourceDs != null) {
                    base.setBaseDatastream(target.sourceDs);
                    base.setBaseMultiDatastream(null);
                } else if (base.getBaseDatastream() == null) {
                    base.setBaseMultiDatastream(target.sourceMds);
                }
            }
            ++i;
            LOGGER.debug("Found source for: {}.", (Object)target);
        }
    }

    private void findSourceDatastreams(List<AggregationBase> bases) {
        long count = bases.size();
        double pPart = (this.progressTarget - this.progressBase) / (double)count;
        int nr = 0;
        for (AggregationBase base : bases) {
            this.findSourceDatastreams(base);
            this.setProgress(this.progressBase + (double)(++nr) * pPart);
        }
    }

    private String baseNameFromName(String name) {
        Matcher matcher = Utils.POSTFIX_PATTERN.matcher(name);
        if (matcher.matches()) {
            return matcher.group(1).trim();
        }
        return name;
    }

    private void gatherData() {
        this.setProgress(0.0, 0.1);
        if (this.addEmptyBases) {
            this.findAllBases();
            LOGGER.info("Found {} base names", (Object)this.aggregationBases.size());
        }
        this.moveProgress(0.3);
        this.findTargetMultiDatastreams();
        LOGGER.info("Found {} comboSets", (Object)this.aggregationBasesByName.size());
        this.moveProgress(0.9);
        this.findSourceDatastreams(this.aggregationBases);
        this.moveProgress(1.0);
        this.combosBySource = new HashMap<String, List<AggregateCombo>>();
        long count = this.aggregationBasesByName.size();
        double pPart = (this.progressTarget - this.progressBase) / (double)count;
        int nr = 0;
        for (AggregationBase base : this.aggregationBasesByName.values()) {
            for (AggregateCombo combo : base.getCombos()) {
                String path = combo.getSourceObsMqttPath();
                if (path.isEmpty()) continue;
                List<AggregateCombo> bySource = this.combosBySource.get(path);
                if (bySource == null) {
                    bySource = new ArrayList<AggregateCombo>();
                    this.combosBySource.put(path, bySource);
                }
                bySource.add(combo);
            }
            this.setProgress(this.progressBase + (double)(++nr) * pPart);
        }
        this.setProgress(1.0);
        LOGGER.info("Found {} unique source datastreams", (Object)this.combosBySource.size());
    }

    public List<AggregationBase> getAggregationBases() {
        if (this.aggregationBases.isEmpty()) {
            this.gatherData();
        }
        return this.aggregationBases;
    }

    public Map<String, AggregationBase> getCombosByBase() {
        if (this.aggregationBasesByName.isEmpty()) {
            this.gatherData();
        }
        return this.aggregationBasesByName;
    }

    public Map<String, List<AggregateCombo>> getComboBySource() {
        return this.getComboBySource(false);
    }

    public Map<String, List<AggregateCombo>> getComboBySource(boolean recalculate) {
        if (this.combosBySource == null || recalculate) {
            this.gatherData();
        }
        return this.combosBySource;
    }

    private void checkReference(Datastream source, MultiDatastream aggregate, AggregationLevel level) {
        String aggKey = null;
        Object aggId = null;
        String expectedAggFor = "/Datastreams(" + source.getId().getUrl() + ")";
        aggKey = "aggregateSource.Datastream@iot.id";
        aggId = source.getId().getValue();
        this.checkReference(aggregate, expectedAggFor, level, aggKey, aggId);
    }

    private void checkReference(MultiDatastream source, MultiDatastream aggregate, AggregationLevel level) {
        String aggKey = null;
        Object aggId = null;
        String expectedAggFor = "/MultiDatastreams(" + source.getId().getUrl() + ")";
        aggKey = "aggregateSource.MultiDatastream@iot.id";
        aggId = source.getId().getValue();
        this.checkReference(aggregate, expectedAggFor, level, aggKey, aggId);
    }

    private boolean checkProperty(Map<String, Object> properties, String property, Object value) {
        Object checkValue = value;
        boolean changed = false;
        Object oldValue = properties.get(property);
        if (!(value instanceof Number || value instanceof Boolean || value instanceof String || value == null)) {
            checkValue = value.toString();
        }
        if (value instanceof Number && oldValue instanceof Number) {
            checkValue = value.toString();
            oldValue = oldValue.toString();
        }
        if (!checkValue.equals(oldValue)) {
            LOGGER.info("Fixing property {}. Is {}, should be {}.", new Object[]{property, oldValue, value});
            properties.put(property, value);
            changed = true;
        }
        return changed;
    }

    private void checkReference(MultiDatastream aggregate, String expectedAggFor, AggregationLevel level, String aggSourceKey, Object aggSourceId) {
        String aggFor;
        HashMap<String, Object> properties = aggregate.getProperties();
        if (properties == null) {
            properties = new HashMap<String, Object>();
            aggregate.setProperties(properties);
        }
        boolean changed = false;
        changed |= this.checkProperty(properties, "aggregateAmount", level.amount);
        changed |= this.checkProperty(properties, "aggregateUnit", level.unit.toString());
        if (aggSourceKey != null) {
            changed |= this.checkProperty(properties, aggSourceKey, aggSourceId);
        }
        if (!expectedAggFor.equals(aggFor = Objects.toString(properties.get("aggregateFor")))) {
            if (this.fixReferences) {
                LOGGER.info("Setting source reference for {} to {}.", (Object)aggregate.getName(), (Object)expectedAggFor);
                properties.put("aggregateFor", expectedAggFor);
                changed = true;
            } else {
                LOGGER.info("Source reference for {} not correct. Should be {}.", (Object)aggregate.getName(), (Object)expectedAggFor);
            }
        }
        if (changed && this.fixReferences) {
            try {
                MultiDatastream copy = aggregate.withOnlyId();
                copy.setProperties(aggregate.getProperties());
                copy.setMultiObservationDataTypes(null);
                copy.setUnitOfMeasurements(null);
                this.service.update((Entity)copy);
            }
            catch (ServiceFailureException ex) {
                LOGGER.error("Failed to update reference.", (Throwable)ex);
            }
        }
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void moveProgress(double target) {
        this.progressBase = this.progressTarget;
        this.progressTarget = target;
        this.setProgress(this.progressBase);
    }

    public void setProgress(double base, double target) {
        this.progressBase = base;
        this.progressTarget = target;
        this.setProgress(base);
    }

    public void setProgress(double p) {
        for (ProgressListener l : this.progressListeners) {
            l.setProgress(p);
        }
    }

    public boolean hasListeners() {
        return !this.progressListeners.isEmpty();
    }

    public void addProgressListener(ProgressListener l) {
        this.progressListeners.add(l);
    }

    public void removeProgressListener(ProgressListener l) {
        this.progressListeners.remove(l);
    }

    public static interface ProgressListener {
        public void setProgress(double var1);
    }
}

