/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation;

import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregateCombo;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregationBase;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregationLevel;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class AggregationBaseFx {
    private final AggregationBase base;
    private final StringProperty baseName;
    private final Map<AggregationLevel, AggregateCombo> combosByLevel;
    private final Map<AggregationLevel, BooleanProperty> levelToggles = new HashMap<AggregationLevel, BooleanProperty>();

    public AggregationBaseFx(AggregationBase base) {
        this.base = base;
        this.baseName = new SimpleStringProperty(base.getBaseName());
        this.combosByLevel = base.getCombosByLevel();
    }

    public StringProperty getBaseNameProperty() {
        return this.baseName;
    }

    public BooleanProperty getLevelProperty(AggregationLevel level) {
        BooleanProperty property = this.levelToggles.get(level);
        if (property == null) {
            boolean hasProp = this.combosByLevel.containsKey(level);
            property = new SimpleBooleanProperty(hasProp);
            this.levelToggles.put(level, property);
            property.addListener((observable, oldValue, newValue) -> this.base.toggleLevel(level, (boolean)newValue));
        }
        return property;
    }

    public Map<AggregationLevel, BooleanProperty> getLevelToggles() {
        return this.levelToggles;
    }

    public void comboAdded(AggregationLevel level) {
        BooleanProperty presentProp = this.levelToggles.get(level);
        if (presentProp != null) {
            presentProp.set(true);
        }
    }
}

