/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation;

import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregateCombo;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregationBaseFx;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregationLevel;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregationBase.class);
    private final String baseName;
    private Datastream baseDatastream;
    private MultiDatastream baseMultiDatastream;
    private final Set<AggregateCombo> combos = new TreeSet<AggregateCombo>();
    private final Map<AggregationLevel, AggregateCombo> combosByLevel = new HashMap<AggregationLevel, AggregateCombo>();
    private final Map<AggregationLevel, Boolean> wantedLevels = new HashMap<AggregationLevel, Boolean>();
    private AggregationBaseFx fxProperties;

    public AggregationBase(String baseName) {
        this.baseName = baseName;
    }

    public AggregationBase(String baseName, Datastream baseDatastream, MultiDatastream baseMultiDatastream) {
        this.baseName = baseName;
        this.baseDatastream = baseDatastream;
        this.baseMultiDatastream = baseMultiDatastream;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public AggregationBaseFx getFxProperties() {
        if (this.fxProperties == null) {
            this.fxProperties = new AggregationBaseFx(this);
        }
        return this.fxProperties;
    }

    protected void toggleLevel(AggregationLevel level, boolean toValue) {
        if (toValue) {
            LOGGER.info("Adding level {} to base {}.", (Object)level, (Object)this.baseName);
            this.wantedLevels.put(level, true);
        } else {
            LOGGER.info("Removing level {} from base {}.", (Object)level, (Object)this.baseName);
            this.wantedLevels.put(level, false);
        }
    }

    public Set<AggregateCombo> getCombos() {
        return this.combos;
    }

    public Map<AggregationLevel, AggregateCombo> getCombosByLevel() {
        return this.combosByLevel;
    }

    public void addCombo(AggregateCombo combo) {
        AggregationLevel level = combo.level;
        this.combos.add(combo);
        AggregateCombo old = this.combosByLevel.put(level, combo);
        if (old != null) {
            LOGGER.warn("Multiple combos of level {} found for base {}.", (Object)level, (Object)this.getBaseName());
        }
        if (this.fxProperties != null) {
            this.fxProperties.comboAdded(level);
        }
    }

    public Map<AggregationLevel, Boolean> getWantedLevels() {
        return this.wantedLevels;
    }

    public Datastream getBaseDatastream() {
        return this.baseDatastream;
    }

    public void setBaseDatastream(Datastream baseDatastream) {
        this.baseDatastream = baseDatastream;
    }

    public MultiDatastream getBaseMultiDatastream() {
        return this.baseMultiDatastream;
    }

    public void setBaseMultiDatastream(MultiDatastream baseMultiDatastream) {
        this.baseMultiDatastream = baseMultiDatastream;
    }
}

