/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation;

import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.AggregationLevel;
import de.fraunhofer.iosb.ilt.sensorthingsmanager.aggregation.Utils;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.Id;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.TimeObject;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.extra.Interval;

public class AggregateCombo
implements Comparable<AggregateCombo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregateCombo.class);
    public final Thing targetThing;
    public final MultiDatastream target;
    public Datastream sourceDs;
    public MultiDatastream sourceMds;
    public boolean sourceIsAggregate;
    public boolean sourceIsCollection = false;
    public AggregationLevel level;
    public String baseName;
    private ZoneId zoneId;
    private Interval currentInterval;

    public AggregateCombo(Thing targetThing, MultiDatastream target) {
        this.targetThing = targetThing;
        this.target = target;
    }

    public boolean hasSource() {
        return this.sourceDs != null || this.sourceMds != null;
    }

    public EntityType getSourceType() {
        if (this.sourceDs != null) {
            return EntityType.DATASTREAM;
        }
        if (this.sourceMds != null) {
            return EntityType.MULTIDATASTREAM;
        }
        return null;
    }

    public Id getSourceId() {
        if (this.sourceDs != null) {
            return this.sourceDs.getId();
        }
        if (this.sourceMds != null) {
            return this.sourceMds.getId();
        }
        return null;
    }

    public BaseDao<Observation> getObsDaoForSource() {
        if (this.sourceDs != null) {
            return this.sourceDs.observations();
        }
        if (this.sourceMds != null) {
            return this.sourceMds.observations();
        }
        return null;
    }

    public Observation getLastForTarget() {
        try {
            return (Observation)this.target.observations().query().select(new String[]{"id", "phenomenonTime"}).orderBy("phenomenonTime desc").first();
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Error fetching last observation.", (Throwable)ex);
            return null;
        }
    }

    public Observation getFirstForSource() {
        try {
            if (this.hasSource()) {
                return (Observation)this.getObsDaoForSource().query().select(new String[]{"id", "phenomenonTime"}).orderBy("phenomenonTime asc").first();
            }
            return null;
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Error fetching first observation.", (Throwable)ex);
            return null;
        }
    }

    public Observation getLastForSource() {
        try {
            if (this.hasSource()) {
                return (Observation)this.getObsDaoForSource().query().select(new String[]{"id", "phenomenonTime"}).orderBy("phenomenonTime desc").first();
            }
            return null;
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Error fetching last observation.", (Throwable)ex);
            return null;
        }
    }

    public List<Observation> getObservationsForSource(Instant start, Instant end) {
        ArrayList<Observation> result = new ArrayList<Observation>();
        if (this.hasSource()) {
            try {
                StringBuilder filter = new StringBuilder();
                filter.append("overlaps(phenomenonTime,").append(start.toString()).append("/").append(end.toString()).append(")");
                EntityList entityList = this.getObsDaoForSource().query().filter(filter.toString()).orderBy("phenomenonTime asc").top(1000).list();
                Iterator it = entityList.fullIterator();
                while (it.hasNext()) {
                    Observation entity = (Observation)it.next();
                    result.add(entity);
                }
            }
            catch (ServiceFailureException ex) {
                LOGGER.error("Failed to fetch observations.", (Throwable)ex);
            }
        }
        return result;
    }

    public void resolveZoneId(ZoneId dflt) {
        if (this.zoneId == null) {
            Map properties = this.targetThing.getProperties();
            Object zoneName = properties.get("timeZone");
            if (zoneName == null || zoneName.toString().isEmpty()) {
                this.zoneId = dflt;
            } else {
                try {
                    this.zoneId = ZoneId.of(zoneName.toString());
                }
                catch (DateTimeException ex) {
                    LOGGER.warn("Invalid zone: " + zoneName, (Throwable)ex);
                    this.zoneId = dflt;
                }
            }
        }
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public String getSourceObsMqttPath() {
        if (this.sourceDs != null) {
            return "v1.0/Datastreams(" + this.sourceDs.getId() + ")/Observations?$select=id,phenomenonTime";
        }
        if (this.sourceMds != null) {
            return "v1.0/MultiDatastreams(" + this.sourceMds.getId() + ")/Observations?$select=id,phenomenonTime";
        }
        return "";
    }

    public List<Interval> calculateIntervalsForTime(TimeObject phenTime) {
        ArrayList<Interval> retval = new ArrayList<Interval>();
        Instant phenTimeStart = Utils.getPhenTimeStart(phenTime);
        Instant phenTimeEnd = Utils.getPhenTimeEnd(phenTime);
        ZonedDateTime atZone = phenTimeStart.atZone(this.getZoneId());
        ZonedDateTime intStart = this.level.toIntervalStart(atZone);
        ZonedDateTime intEnd = intStart.plus(this.level.amount, this.level.unit);
        retval.add(Interval.of((Instant)intStart.toInstant(), (Instant)intEnd.toInstant()));
        while (intEnd.toInstant().isBefore(phenTimeEnd)) {
            intStart = intEnd;
            intEnd = intStart.plus(this.level.amount, this.level.unit);
            retval.add(Interval.of((Instant)intStart.toInstant(), (Instant)intEnd.toInstant()));
        }
        return retval;
    }

    public Interval replaceIfNotCurrent(Interval other) {
        if (this.currentInterval == null) {
            this.currentInterval = other;
            return null;
        }
        if (this.currentInterval.equals((Object)other)) {
            return null;
        }
        Interval old = this.currentInterval;
        this.currentInterval = other;
        return old;
    }

    public Interval unsetCurrent(Interval other) {
        if (this.currentInterval == null) {
            return null;
        }
        if (this.currentInterval.equals((Object)other)) {
            this.currentInterval = null;
            return null;
        }
        Interval old = this.currentInterval;
        this.currentInterval = null;
        return old;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof AggregateCombo)) {
            return false;
        }
        AggregateCombo otherCombo = (AggregateCombo)obj;
        if (!this.level.equals(otherCombo.level)) {
            return false;
        }
        if (!this.baseName.equals(otherCombo.baseName)) {
            return false;
        }
        return this.target.getId().equals(otherCombo.target.getId());
    }

    public int hashCode() {
        return Objects.hash(this.target, this.level, this.baseName);
    }

    @Override
    public int compareTo(AggregateCombo o) {
        return new CompareToBuilder().append((Object)this.level, (Object)o.level).append((Object)this.baseName, (Object)o.baseName).toComparison();
    }

    public String toString() {
        if (this.sourceDs != null) {
            return this.baseName + " " + this.level + ". (d " + this.sourceDs.getId() + " -> md " + this.target.getId() + ")";
        }
        if (this.sourceMds != null) {
            return this.baseName + " " + this.level + ". (md " + this.sourceMds.getId() + " -> md " + this.target.getId() + ")";
        }
        return this.baseName + " " + this.level + ". (? -> md " + this.target.getId() + ")";
    }

    public String getBaseName() {
        return this.baseName;
    }
}

