/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.format.expert.IsoDateStyle;
import net.time4j.format.expert.IsoDecimalStyle;
import net.time4j.range.MomentInterval;
import net.time4j.tz.TZID;
import net.time4j.tz.ZonalOffset;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringHelper {
    public static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final Logger LOGGER = LoggerFactory.getLogger(StringHelper.class);
    private static final String UTF8_NOT_SUPPORTED = "UTF-8 not supported?";
    private static final NonZeroCondition NON_ZERO_FRACTION = new NonZeroCondition((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND);
    public static final ChronoPrinter<Moment> FORMAT_MOMENT = StringHelper.buildMomentFormatter();
    public static final ChronoPrinter<MomentInterval> FORMAT_INTERVAL = StringHelper.buildIntervalFormatter();

    private StringHelper() {
    }

    public static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String deCapitalize(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isNullOrEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static String cleanForLogging(String string) {
        if (string == null) {
            return "null";
        }
        return StringUtils.replaceChars((String)string, (String)"\n\r\t", (String)"");
    }

    public static String cleanForLogging(Object object) {
        return StringHelper.cleanForLogging(Objects.toString(object));
    }

    public static String escapeForStringConstant(String in) {
        return in.replace("'", "''");
    }

    public static String cleanForLogging(String string, int maxLength) {
        return StringUtils.replaceChars((String)StringUtils.abbreviate((String)string, (int)maxLength), (String)"\n\r\t", (String)"");
    }

    public static String quoteForUrl(Object in) {
        if (in instanceof Number) {
            return in.toString();
        }
        return "'" + StringHelper.escapeForStringConstant(in.toString()) + "'";
    }

    public static String urlEncode(String string, boolean notSlashes) {
        if (notSlashes) {
            return StringHelper.urlEncodeNotSlashes(string);
        }
        return StringHelper.urlEncode(string);
    }

    public static String urlEncodeNotSlashes(String string) {
        CharSequence[] split = string.split("/");
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringHelper.urlEncode((String)split[i]);
        }
        return String.join((CharSequence)"/", split);
    }

    public static String urlEncode(String input) {
        try {
            return URLEncoder.encode(input, UTF8.name());
        }
        catch (UnsupportedEncodingException exc) {
            LOGGER.error(UTF8_NOT_SUPPORTED);
            throw new IllegalStateException(UTF8_NOT_SUPPORTED, exc);
        }
    }

    public static String urlDecode(String input) {
        try {
            return URLDecoder.decode(input, UTF8.name());
        }
        catch (UnsupportedEncodingException exc) {
            LOGGER.error(UTF8_NOT_SUPPORTED);
            throw new IllegalStateException(UTF8_NOT_SUPPORTED, exc);
        }
    }

    private static ChronoPrinter<MomentInterval> buildIntervalFormatter() {
        return (formattable, buffer, attributes) -> {
            MomentInterval interval = (MomentInterval)formattable.toCanonical();
            if (interval.getStart().isInfinite()) {
                buffer.append("-");
            } else {
                FORMAT_MOMENT.print((Object)interval.getStartAsMoment(), buffer);
            }
            buffer.append('/');
            if (interval.getEnd().isInfinite()) {
                buffer.append("-");
            } else {
                FORMAT_MOMENT.print((Object)interval.getEndAsMoment(), buffer);
            }
            return Collections.emptySet();
        };
    }

    private static ChronoPrinter<Moment> buildMomentFormatter() {
        IsoDateStyle dateStyle = IsoDateStyle.EXTENDED_CALENDAR_DATE;
        IsoDecimalStyle decimalStyle = IsoDecimalStyle.DOT;
        ZonalOffset offset = ZonalOffset.UTC;
        ChronoFormatter.Builder builder = ChronoFormatter.setUp((Chronology)Moment.axis(), (Locale)Locale.ROOT);
        builder.addCustomized((ChronoElement)PlainDate.COMPONENT, Iso8601Format.ofDate((IsoDateStyle)dateStyle), (text, status, attributes) -> null);
        builder.addLiteral('T');
        StringHelper.addWallTime(builder, dateStyle.isExtended(), decimalStyle);
        builder.addTimezoneOffset(FormatStyle.MEDIUM, dateStyle.isExtended(), Collections.singletonList("Z"));
        return builder.build().with(Leniency.STRICT).withTimezone((TZID)offset);
    }

    private static <T extends ChronoEntity<T>> void addWallTime(ChronoFormatter.Builder<T> builder, boolean extended, IsoDecimalStyle decimalStyle) {
        builder.startSection(Attributes.NUMBER_SYSTEM, (Enum)NumberSystem.ARABIC);
        builder.startSection(Attributes.ZERO_DIGIT, '0');
        builder.addFixedInteger((ChronoElement)PlainTime.HOUR_FROM_0_TO_24, 2);
        if (extended) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger((ChronoElement)PlainTime.MINUTE_OF_HOUR, 2);
        if (extended) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger((ChronoElement)PlainTime.SECOND_OF_MINUTE, 2);
        builder.startOptionalSection((ChronoCondition)NON_ZERO_FRACTION);
        switch (decimalStyle) {
            case COMMA: {
                builder.addLiteral(',', '.');
                break;
            }
            case DOT: {
                builder.addLiteral('.', ',');
                break;
            }
            default: {
                throw new UnsupportedOperationException(decimalStyle.name());
            }
        }
        builder.addFraction((ChronoElement)PlainTime.NANO_OF_SECOND, 1, 9, false);
        for (int i = 0; i < 3; ++i) {
            builder.endSection();
        }
    }

    private static class NonZeroCondition
    implements ChronoCondition<ChronoDisplay> {
        private final ChronoElement<Integer> element;

        NonZeroCondition(ChronoElement<Integer> element) {
            this.element = element;
        }

        public boolean test(ChronoDisplay context) {
            return context.getInt(this.element) > 0;
        }

        ChronoCondition<ChronoDisplay> or(NonZeroCondition other) {
            return context -> this.test((ChronoDisplay)context) || other.test((ChronoDisplay)context);
        }
    }
}

