/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.utils;

import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypePrimitive;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.util.UUID;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;

public class ParserUtils {
    public static final TypePrimitive.Parser PARSER_LONG = Long::parseLong;
    public static final TypePrimitive.Parser PARSER_UUID = input -> {
        if (input.startsWith("'")) {
            return UUID.fromString(input.substring(1, input.length() - 1));
        }
        return UUID.fromString(input);
    };
    public static final TypePrimitive.Parser PARSER_STRING = input -> {
        if (input.startsWith("'")) {
            String idString = input.substring(1, input.length() - 1);
            return idString.replace("''", "'");
        }
        return input;
    };

    private ParserUtils() {
    }

    public static String entityPath(EntityType entityType, Object ... primaryKeyValues) {
        return String.format("%s(%s)", entityType.plural, ParserUtils.formatKeyValuesForUrl(primaryKeyValues));
    }

    public static String relationPath(Entity parent, NavigationProperty relation) {
        if (parent == null) {
            throw new IllegalArgumentException("Can't generate path for null entity.");
        }
        if (!parent.getEntityType().getNavigationProperties().contains(relation)) {
            throw new IllegalArgumentException("Entity of type " + parent.getEntityType() + " has no relation of type " + relation + ".");
        }
        return String.format("%s(%s)/%s", parent.getEntityType().plural, ParserUtils.formatKeyValuesForUrl(parent.getPrimaryKeyValues()), relation.getName());
    }

    public static String formatKeyValuesForUrl(Entity entity) {
        return ParserUtils.formatKeyValuesForUrl(entity.getPrimaryKeyValues());
    }

    public static String formatKeyValuesForUrl(Object ... pkeyValues) {
        if (pkeyValues.length == 1) {
            if (pkeyValues[0] == null) {
                throw new IllegalArgumentException("Primary key value must be non-null");
            }
            return StringHelper.quoteForUrl(pkeyValues[0]);
        }
        throw new NotImplementedException("Multi-valued primary keys are not supported yet.");
    }

    public static Object[] tryToParse(String input) {
        if (input.startsWith("'")) {
            return new Object[]{StringUtils.replace((String)input.substring(1, input.length() - 1), (String)"''", (String)"'")};
        }
        try {
            return new Object[]{Long.valueOf(input)};
        }
        catch (NumberFormatException numberFormatException) {
            return new Object[]{input};
        }
    }
}

