/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    public static final String OM_MEASUREMENT = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement";
    public static final String OM_COMPLEXOBSERVATION = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_ComplexObservation";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CONTENT_TYPE_APPLICATION_GEOJSON = "application/geo+json";
    public static final String CONTENT_TYPE_APPLICATION_HTTP = "application/http";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE_APPLICATION_JSONPATCH = "application/json-patch+json";
    public static final String CONTENT_TYPE_APPLICATION_XML = "application/xml";
    public static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    public static final String CHARSET_UTF8 = "charset=UTF-8";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_LOCATION = "Location";
    public static final String HEADER_PREFER = "Prefer";
    public static final String TAG_PREFER_RETURN = "return";
    public static final String REQUEST_PARAM_FORMAT = "$format";
    public static final String VALUE_ID_TYPE_LONG = "LONG";
    public static final String VALUE_ID_TYPE_STRING = "STRING";
    public static final String VALUE_ID_TYPE_UUID = "UUID";
    public static final String VALUE_RETURN_REPRESENTATION = "representation";
    public static final String VALUE_RETURN_MINIMAL = "minimal";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Constants.class.getName());

    private Constants() {
    }

    public static <T> T throwIfNullOrTypeNot(Object entity, Class<T> targetClass) {
        if (entity == null || !targetClass.isAssignableFrom(entity.getClass())) {
            throw new IllegalArgumentException("Expected " + targetClass + " got " + entity);
        }
        return (T)entity;
    }

    public static <T> T throwIfTypeNot(Object entity, Class<T> targetClass) {
        if (entity != null && !targetClass.isAssignableFrom(entity.getClass())) {
            LOGGER.error("Expected {}, but got {}", targetClass, entity);
            throw new IllegalArgumentException("Expected " + targetClass + " got " + entity);
        }
        return (T)entity;
    }
}

