/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models;

import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypePrimitive;
import de.fraunhofer.iosb.ilt.frostclient.models.DataModel;
import de.fraunhofer.iosb.ilt.frostclient.models.SensorThingsSensingV11;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.MapValue;

public class SensorThingsPlus
implements DataModel {
    private static final String NAME_GROUP = "Group";
    private static final String NAME_GROUPS = "Groups";
    private static final String NAME_LICENSE = "License";
    private static final String NAME_LICENSES = "Licenses";
    private static final String NAME_PARTY = "Party";
    private static final String NAME_PARTIES = "Parties";
    private static final String NAME_PROJECT = "Project";
    private static final String NAME_PROJECTS = "Projects";
    private static final String NAME_RELATION = "Relation";
    private static final String NAME_RELATIONS = "Relations";
    private static final String NAME_SUBJECT = "Subject";
    private static final String NAME_SUBJECTS = "Subjects";
    private static final String NAME_OBJECT = "Object";
    private static final String NAME_OBJECTS = "Objects";
    private static final String NAME_AUTHID = "authId";
    private static final String NAME_CLASSIFICATION = "classifiction";
    private static final String NAME_DISPLAYNAME = "displayName";
    private static final String NAME_ROLE = "role";
    private static final String NAME_PURPOSE = "purpose";
    private static final String NAME_END_TIME = "endTime";
    private static final String NAME_START_TIME = "startTime";
    private static final String NAME_CREATION_TIME = "creationTime";
    private static final String NAME_TERMS_OF_USE = "termsOfUse";
    private static final String NAME_PRIVACY_POLICY = "privacyPolicy";
    private static final String NAME_DATA_QUALITY = "dataQuality";
    private static final String NAME_LOGO = "logo";
    private static final String NAME_ATTRIBUTION_TEXT = "attributionText";
    private static final String NAME_URL = "url";
    private static final String NAME_PROPERTIES = "properties";
    private static final String NAME_EXTERNAL_OBJECT = "externalObject";
    public static final EntityPropertyMain<String> EP_AUTHID = new EntityPropertyMain("authId", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<String> EP_CLASSIFICATION = new EntityPropertyMain("classifiction", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<String> EP_DEFINITION = SensorThingsSensingV11.EP_DEFINITION;
    public static final EntityPropertyMain<String> EP_DESCRIPTION = SensorThingsSensingV11.EP_DESCRIPTION;
    public static final EntityPropertyMain<String> EP_DISPLAYNAME = new EntityPropertyMain("displayName", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<String> EP_PURPOSE = new EntityPropertyMain("purpose", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<String> EP_ROLE = new EntityPropertyMain("role", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<String> EP_START_TIME = new EntityPropertyMain("startTime", TypePrimitive.EDM_DATETIMEOFFSET);
    public static final EntityPropertyMain<String> EP_END_TIME = new EntityPropertyMain("endTime", TypePrimitive.EDM_DATETIMEOFFSET);
    public static final EntityPropertyMain<String> EP_CREATION_TIME = new EntityPropertyMain("creationTime", TypePrimitive.EDM_DATETIMEOFFSET);
    public static final EntityPropertyMain<String> EP_TERMS_OF_USE = new EntityPropertyMain("termsOfUse", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<String> EP_PRIVACY_POLICY = new EntityPropertyMain("privacyPolicy", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<MapValue> EP_DATA_QUALITY = new EntityPropertyMain("dataQuality", TypeComplex.STA_MAP);
    public static final EntityPropertyMain<MapValue> EP_PROPERTIES = SensorThingsSensingV11.EP_PROPERTIES;
    public static final EntityPropertyMain<String> EP_LOGO = new EntityPropertyMain("logo", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<String> EP_ATTRIBUTION_TEXT = new EntityPropertyMain("attributionText", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<String> EP_URL = new EntityPropertyMain("url", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<String> EP_EXTERNAL_OBJECT = new EntityPropertyMain("externalObject", TypePrimitive.EDM_STRING);
    public final NavigationPropertyEntity npPartyProject = new NavigationPropertyEntity("Party");
    public final NavigationPropertyEntitySet npProjectsParty = new NavigationPropertyEntitySet("Projects", this.npPartyProject);
    public final NavigationPropertyEntity npPartyGroup = new NavigationPropertyEntity("Party");
    public final NavigationPropertyEntitySet npGroupsParty = new NavigationPropertyEntitySet("Groups", this.npPartyGroup);
    public final NavigationPropertyEntity npPartyDatastream = new NavigationPropertyEntity("Party");
    public final NavigationPropertyEntitySet npDatastreamsParty = new NavigationPropertyEntitySet("Datastreams", this.npPartyDatastream);
    public final NavigationPropertyEntity npPartyMultiDatastream = new NavigationPropertyEntity("Party");
    public final NavigationPropertyEntitySet npMultiDatastreamsParty = new NavigationPropertyEntitySet("MultiDatastreams", this.npPartyMultiDatastream);
    public final NavigationPropertyEntity npPartyThing = new NavigationPropertyEntity("Party");
    public final NavigationPropertyEntitySet npThingsParty = new NavigationPropertyEntitySet("Things", this.npPartyThing);
    public final NavigationPropertyEntity npLicenseProject = new NavigationPropertyEntity("License");
    public final NavigationPropertyEntitySet npProjectsLicense = new NavigationPropertyEntitySet("Projects", this.npLicenseProject);
    public final NavigationPropertyEntity npLicenseGroup = new NavigationPropertyEntity("License");
    public final NavigationPropertyEntitySet npGroupsLicense = new NavigationPropertyEntitySet("Groups", this.npLicenseGroup);
    public final NavigationPropertyEntity npLicenseDatastream = new NavigationPropertyEntity("License");
    public final NavigationPropertyEntitySet npDatastreamsLicense = new NavigationPropertyEntitySet("Datastreams", this.npLicenseDatastream);
    public final NavigationPropertyEntity npLicenseMultiDatastream = new NavigationPropertyEntity("License");
    public final NavigationPropertyEntitySet npMultiDatastreamsLicense = new NavigationPropertyEntitySet("MultiDatastreams", this.npLicenseMultiDatastream);
    public final NavigationPropertyEntity npSubjectRelation = new NavigationPropertyEntity("Subject");
    public final NavigationPropertyEntitySet npObjectsObservation = new NavigationPropertyEntitySet("Objects", this.npSubjectRelation);
    public final NavigationPropertyEntity npObjectRelation = new NavigationPropertyEntity("Object");
    public final NavigationPropertyEntitySet npSubjectsObservation = new NavigationPropertyEntitySet("Subjects", this.npObjectRelation);
    public final NavigationPropertyEntity npGroupsRelation = new NavigationPropertyEntity("Groups");
    public final NavigationPropertyEntitySet npRelationsGroup = new NavigationPropertyEntitySet("Relations", this.npGroupsRelation);
    public final NavigationPropertyEntity npGroupsProject = new NavigationPropertyEntity("Groups");
    public final NavigationPropertyEntitySet npProjectsGroup = new NavigationPropertyEntitySet("Projects", this.npGroupsProject);
    public final NavigationPropertyEntity npGroupsObservation = new NavigationPropertyEntity("Groups");
    public final NavigationPropertyEntitySet npObservationsGroup = new NavigationPropertyEntitySet("Observations", this.npGroupsObservation);
    public final NavigationPropertyEntity npProjectsDatastream = new NavigationPropertyEntity("Project");
    public final NavigationPropertyEntitySet npDatastreamsProject = new NavigationPropertyEntitySet("Datastreams", this.npProjectsDatastream);
    public final NavigationPropertyEntity npProjectsMultiDatastream = new NavigationPropertyEntity("Project");
    public final NavigationPropertyEntitySet npMultiDatastreamsProject = new NavigationPropertyEntitySet("MultiDatastreams", this.npProjectsMultiDatastream);
    public final EntityType etGroup = new EntityType("Group", "Groups");
    public final EntityType etLicense = new EntityType("License", "Licenses");
    public final EntityType etParty = new EntityType("Party", "Parties");
    public final EntityType etProject = new EntityType("Project", "Projects");
    public final EntityType etRelation = new EntityType("Relation", "Relations");
    private ModelRegistry mr;

    @Override
    public final void init(ModelRegistry modelRegistry) {
        if (this.mr != null) {
            throw new IllegalArgumentException("Already initialised.");
        }
        this.mr = modelRegistry;
        EntityType etDatastream = this.mr.getEntityTypeForName("Datastream");
        EntityType etThing = this.mr.getEntityTypeForName("Thing");
        EntityType etObservation = this.mr.getEntityTypeForName("Observation");
        EntityType etMultiDatastream = this.mr.getEntityTypeForName("MultiDatastream");
        this.mr.registerEntityType(this.etGroup);
        this.mr.registerEntityType(this.etLicense);
        this.mr.registerEntityType(this.etParty);
        this.mr.registerEntityType(this.etProject);
        this.mr.registerEntityType(this.etRelation);
        this.etGroup.registerProperty(SensorThingsSensingV11.EP_ID).registerProperty(ModelRegistry.EP_SELFLINK).registerProperty(SensorThingsSensingV11.EP_NAME).registerProperty(EP_DESCRIPTION).registerProperty(EP_PURPOSE).registerProperty(EP_END_TIME).registerProperty(EP_CREATION_TIME).registerProperty(EP_TERMS_OF_USE).registerProperty(EP_PRIVACY_POLICY).registerProperty(EP_PROPERTIES).registerProperty(EP_DATA_QUALITY).registerProperty(this.npLicenseGroup).registerProperty(this.npObservationsGroup).registerProperty(this.npPartyGroup).registerProperty(this.npProjectsGroup).registerProperty(this.npRelationsGroup);
        this.etLicense.registerProperty(SensorThingsSensingV11.EP_ID).registerProperty(ModelRegistry.EP_SELFLINK).registerProperty(SensorThingsSensingV11.EP_NAME).registerProperty(EP_DESCRIPTION).registerProperty(EP_DEFINITION).registerProperty(EP_LOGO).registerProperty(EP_ATTRIBUTION_TEXT).registerProperty(this.npProjectsLicense).registerProperty(this.npGroupsLicense).registerProperty(this.npDatastreamsLicense).registerProperty(this.npMultiDatastreamsLicense);
        this.etParty.registerProperty(SensorThingsSensingV11.EP_ID).registerProperty(ModelRegistry.EP_SELFLINK).registerProperty(EP_DESCRIPTION).registerProperty(EP_AUTHID).registerProperty(EP_ROLE).registerProperty(EP_DISPLAYNAME).registerProperty(this.npProjectsParty).registerProperty(this.npGroupsParty).registerProperty(this.npThingsParty).registerProperty(this.npDatastreamsParty).registerProperty(this.npMultiDatastreamsParty);
        this.etProject.registerProperty(SensorThingsSensingV11.EP_ID).registerProperty(ModelRegistry.EP_SELFLINK).registerProperty(SensorThingsSensingV11.EP_NAME).registerProperty(EP_DESCRIPTION).registerProperty(EP_CLASSIFICATION).registerProperty(EP_TERMS_OF_USE).registerProperty(EP_PRIVACY_POLICY).registerProperty(EP_CREATION_TIME).registerProperty(EP_START_TIME).registerProperty(EP_END_TIME).registerProperty(EP_URL).registerProperty(EP_PROPERTIES).registerProperty(this.npPartyProject).registerProperty(this.npLicenseProject).registerProperty(this.npDatastreamsProject).registerProperty(this.npMultiDatastreamsProject).registerProperty(this.npGroupsProject);
        this.etRelation.registerProperty(SensorThingsSensingV11.EP_ID).registerProperty(ModelRegistry.EP_SELFLINK).registerProperty(EP_ROLE).registerProperty(EP_DESCRIPTION).registerProperty(EP_EXTERNAL_OBJECT).registerProperty(EP_PROPERTIES).registerProperty(this.npGroupsRelation).registerProperty(this.npSubjectRelation).registerProperty(this.npObjectRelation);
        etObservation.registerProperty(this.npGroupsObservation).registerProperty(this.npSubjectsObservation).registerProperty(this.npObjectsObservation);
        etThing.registerProperty(this.npPartyThing);
        etDatastream.registerProperty(this.npLicenseDatastream).registerProperty(this.npPartyDatastream).registerProperty(this.npProjectsDatastream);
        if (etMultiDatastream != null) {
            etMultiDatastream.registerProperty(this.npLicenseMultiDatastream).registerProperty(this.npPartyMultiDatastream).registerProperty(this.npProjectsMultiDatastream);
        }
    }

    @Override
    public boolean isInitialised() {
        return this.mr != null;
    }

    public ModelRegistry getModelRegistry() {
        return this.mr;
    }

    public Entity newGroup() {
        return new Entity(this.etGroup);
    }

    public Entity newGroup(Object id) {
        return this.newGroup().setPrimaryKeyValues(id);
    }

    public Entity newGroup(String name, String description) {
        return ((Entity)this.newGroup().setProperty((Property)SensorThingsSensingV11.EP_NAME, name)).setProperty((Property)EP_DESCRIPTION, description);
    }

    public Entity newLicense() {
        return new Entity(this.etLicense);
    }

    public Entity newLicense(Object id) {
        return this.newLicense().setPrimaryKeyValues(id);
    }

    public Entity newLicense(String name, String description, String definition) {
        return ((Entity)((Entity)this.newLicense().setProperty((Property)SensorThingsSensingV11.EP_NAME, name)).setProperty((Property)EP_DESCRIPTION, description)).setProperty((Property)EP_DEFINITION, definition);
    }

    public Entity newParty() {
        return new Entity(this.etGroup);
    }

    public Entity newParty(String authId) {
        return this.newParty().setPrimaryKeyValues(authId);
    }

    public Entity newParty(String authId, String displayName, String description) {
        return ((Entity)this.newParty(authId).setProperty((Property)EP_DISPLAYNAME, displayName)).setProperty((Property)EP_DESCRIPTION, description);
    }

    public Entity newParty(String authId, String displayName, String description, String role) {
        return this.newParty(authId, displayName, description).setProperty((Property)EP_ROLE, role);
    }

    public Entity newProject() {
        return new Entity(this.etProject);
    }

    public Entity newProject(Object id) {
        return this.newProject().setPrimaryKeyValues(id);
    }

    public Entity newProject(String name, String description) {
        return ((Entity)this.newProject().setProperty((Property)SensorThingsSensingV11.EP_NAME, name)).setProperty((Property)EP_DESCRIPTION, description);
    }

    public Entity newRelation() {
        return new Entity(this.etRelation);
    }

    public Entity newRelation(Object id) {
        return this.newRelation().setPrimaryKeyValues(id);
    }

    public Entity newRelation(String role, String description) {
        return ((Entity)this.newRelation().setProperty((Property)EP_ROLE, role)).setProperty((Property)EP_DESCRIPTION, description);
    }
}

