/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models;

import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostclient.model.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostclient.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypePrimitive;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeSimpleSet;
import de.fraunhofer.iosb.ilt.frostclient.models.DataModel;
import de.fraunhofer.iosb.ilt.frostclient.models.SensorThingsSensingV11;
import de.fraunhofer.iosb.ilt.frostclient.utils.TypeReferencesHelper;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SensorThingsMultiDatastreamV11
implements DataModel {
    public static final String NAME_MULTI_DATASTREAM = "MultiDatastream";
    public static final String NAME_MULTI_DATASTREAMS = "MultiDatastreams";
    public static final String NAME_MULTIOBSERVATIONDATATYPES = "multiObservationDataTypes";
    public static final EntityPropertyMain<List<String>> EP_MULTIOBSERVATIONDATATYPES = new EntityPropertyMain("multiObservationDataTypes", new TypeSimpleSet(TypePrimitive.EDM_STRING, TypeReferencesHelper.TYPE_REFERENCE_LIST_STRING));
    public static final EntityPropertyMain<List<UnitOfMeasurement>> EP_UNITOFMEASUREMENTS = new EntityPropertyMain("unitOfMeasurements", new TypeSimpleSet(SensorThingsSensingV11.ept_Uom, TypeReferencesHelper.TYPE_REFERENCE_LIST_UOM));
    public final NavigationPropertyEntity npObservationMultidatastream = new NavigationPropertyEntity("MultiDatastream");
    public final NavigationPropertyEntitySet npMultidatastreamObservations = new NavigationPropertyEntitySet("Observations", this.npObservationMultidatastream);
    public final NavigationPropertyEntitySet npObspropMultidatastreams = new NavigationPropertyEntitySet("MultiDatastreams");
    public final NavigationPropertyEntitySet npMultidatastreamObservedproperties = new NavigationPropertyEntitySet("ObservedProperties", this.npObspropMultidatastreams);
    public final NavigationPropertyEntitySet npThingMultidatastreams = new NavigationPropertyEntitySet("MultiDatastreams");
    public final NavigationPropertyEntity npMultidatastreamThing = new NavigationPropertyEntity("Thing", this.npThingMultidatastreams);
    public final NavigationPropertyEntitySet npSensorMultidatastreams = new NavigationPropertyEntitySet("MultiDatastreams");
    public final NavigationPropertyEntity npMultidatastreamSensor = new NavigationPropertyEntity("Sensor", this.npSensorMultidatastreams);
    public final EntityType etMultiDatastream = new EntityType("MultiDatastream", "MultiDatastreams");
    private ModelRegistry mr;

    @Override
    public final void init(ModelRegistry modelRegistry) {
        if (this.mr != null) {
            throw new IllegalArgumentException("Already initialised.");
        }
        this.mr = modelRegistry;
        this.mr.registerEntityType(this.etMultiDatastream);
        this.etMultiDatastream.registerProperty(SensorThingsSensingV11.EP_ID).registerProperty(ModelRegistry.EP_SELFLINK).registerProperty(SensorThingsSensingV11.EP_NAME).registerProperty(SensorThingsSensingV11.EP_DESCRIPTION).registerProperty(SensorThingsSensingV11.EP_OBSERVATIONTYPE).registerProperty(EP_MULTIOBSERVATIONDATATYPES).registerProperty(EP_UNITOFMEASUREMENTS).registerProperty(SensorThingsSensingV11.EP_OBSERVEDAREA).registerProperty(SensorThingsSensingV11.EP_PHENOMENONTIMEDS).registerProperty(SensorThingsSensingV11.EP_PROPERTIES).registerProperty(SensorThingsSensingV11.EP_RESULTTIMEDS).registerProperty(this.npMultidatastreamObservedproperties).registerProperty(this.npMultidatastreamSensor).registerProperty(this.npMultidatastreamThing).registerProperty(this.npMultidatastreamObservations);
        this.mr.getEntityTypeForName("Thing").registerProperty(this.npThingMultidatastreams);
        this.mr.getEntityTypeForName("ObservedProperty").registerProperty(this.npObspropMultidatastreams);
        this.mr.getEntityTypeForName("Sensor").registerProperty(this.npSensorMultidatastreams);
        this.mr.getEntityTypeForName("Observation").registerProperty(this.npObservationMultidatastream);
    }

    @Override
    public boolean isInitialised() {
        return this.mr != null;
    }

    public ModelRegistry getModelRegistry() {
        return this.mr;
    }

    public Entity newMultiDatastream() {
        return new Entity(this.etMultiDatastream);
    }

    public Entity newMultiDatastream(Object id) {
        return new Entity(this.etMultiDatastream).setPrimaryKeyValues(id);
    }

    public Entity newMultiDatastream(String name, String description, UnitOfMeasurement ... uoms) {
        return this.newMultiDatastream(name, description, Arrays.asList(uoms));
    }

    public Entity newMultiDatastream(String name, String description, List<UnitOfMeasurement> uoms) {
        ArrayList<String> obsTypes = new ArrayList<String>();
        for (int i = 0; i < uoms.size(); ++i) {
            obsTypes.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        }
        return ((Entity)((Entity)((Entity)((Entity)this.newMultiDatastream().setProperty((Property)SensorThingsSensingV11.EP_NAME, name)).setProperty((Property)SensorThingsSensingV11.EP_DESCRIPTION, description)).setProperty((Property)SensorThingsSensingV11.EP_OBSERVATIONTYPE, "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_ComplexObservation")).setProperty((Property)EP_MULTIOBSERVATIONDATATYPES, obsTypes)).setProperty((Property)EP_UNITOFMEASUREMENTS, uoms);
    }

    public Entity newObservation() {
        return new Entity(this.mr.getEntityTypeForName("Observation"));
    }

    public Entity newObservation(Object result) {
        return this.newObservation().setProperty((Property)SensorThingsSensingV11.EP_RESULT, result);
    }

    public Entity newObservation(Object result, Entity datastream) {
        if (!this.etMultiDatastream.equals(datastream.getEntityType())) {
            throw new IllegalArgumentException("Datastream must have entityType Datastream, not " + datastream.getEntityType());
        }
        return ((Entity)this.newObservation().setProperty((Property)SensorThingsSensingV11.EP_RESULT, result)).setProperty((Property)this.npObservationMultidatastream, datastream);
    }

    public Entity newObservation(Object result, ZonedDateTime phenomenonTime) {
        return this.newObservation(result).setProperty((Property)SensorThingsSensingV11.EP_PHENOMENONTIME, TimeValue.create(phenomenonTime));
    }

    public Entity newObservation(Object result, ZonedDateTime phenomenonTime, Entity datastream) {
        return this.newObservation(result, datastream).setProperty((Property)SensorThingsSensingV11.EP_PHENOMENONTIME, TimeValue.create(phenomenonTime));
    }

    public Entity newObservation(Object result, TimeInterval phenomenonTime) {
        return this.newObservation(result).setProperty((Property)SensorThingsSensingV11.EP_PHENOMENONTIME, new TimeValue(phenomenonTime));
    }

    public Entity newObservation(Object result, TimeInterval phenomenonTime, Entity datastream) {
        return this.newObservation(result, datastream).setProperty((Property)SensorThingsSensingV11.EP_PHENOMENONTIME, new TimeValue(phenomenonTime));
    }
}

