/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.property.type;

import com.fasterxml.jackson.core.type.TypeReference;
import de.fraunhofer.iosb.ilt.frostclient.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.PropertyType;
import de.fraunhofer.iosb.ilt.frostclient.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostclient.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostclient.model.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypePrimitive;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.MapValue;
import de.fraunhofer.iosb.ilt.frostclient.utils.TypeReferencesHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeComplex
extends PropertyType {
    public static final String STA_MAP_NAME = "Object";
    public static final String STA_OBJECT_NAME = "ANY";
    public static final String STA_TIMEINTERVAL_NAME = "TimeInterval";
    public static final String STA_TIMEVALUE_NAME = "TimeValue";
    public static final String NAME_INTERVAL_START = "start";
    public static final String NAME_INTERVAL_END = "end";
    public static final EntityPropertyMain<TimeInstant> EP_START_TIME = new EntityPropertyMain("start", TypePrimitive.EDM_DATETIMEOFFSET);
    public static final EntityPropertyMain<TimeInstant> EP_END_TIME = new EntityPropertyMain("end", TypePrimitive.EDM_DATETIMEOFFSET);
    public static final TypeComplex STA_MAP = new TypeComplex("Object", "A free object that can contain anything", TypeReferencesHelper.TYPE_REFERENCE_MAPVALUE, MapValue::new, true);
    public static final TypeComplex STA_OBJECT = new TypeComplex("ANY", "A free type, can be anything", TypeReferencesHelper.TYPE_REFERENCE_OBJECT, null, true);
    public static final TypeComplex STA_OBJECT_UNTYPED = new TypeComplex("ANY", "A free type, can be anything", null, null, true);
    public static final TypeComplex STA_TIMEINTERVAL = new TypeComplex("TimeInterval", "An ISO time interval.", TypeReferencesHelper.TYPE_REFERENCE_TIMEINTERVAL, TimeInterval::new).registerProperty(EP_START_TIME).registerProperty(EP_END_TIME);
    public static final TypeComplex STA_TIMEVALUE = new TypeComplex("TimeValue", "An ISO time instant or time interval.", TypeReferencesHelper.TYPE_REFERENCE_TIMEVALUE, TimeValue::new).registerProperty(EP_START_TIME).registerProperty(EP_END_TIME);
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TypeComplex.class.getName());
    private static final Map<String, TypeComplex> TYPES = new HashMap<String, TypeComplex>();
    private final Set<EntityProperty> properties = new LinkedHashSet<EntityProperty>();
    private final Map<String, Property> propertiesByName = new LinkedHashMap<String, Property>();
    private final boolean openType;
    private final Instantiator instantiator;

    public static TypeComplex getType(String name) {
        return TYPES.get(name);
    }

    public TypeComplex(String name, String description, TypeReference typeReference, Instantiator instantiator) {
        this(name, description, typeReference, instantiator, false);
    }

    public TypeComplex(String name, String description, TypeReference typeReference, Instantiator instantiator, boolean openType) {
        super(name, description, typeReference);
        this.openType = openType;
        this.instantiator = instantiator;
    }

    public boolean isOpenType() {
        return this.openType;
    }

    public Set<EntityProperty> getProperties() {
        return this.properties;
    }

    public Property getProperty(String name) {
        return this.propertiesByName.get(name);
    }

    public boolean hasProperty(String name) {
        return this.propertiesByName.containsKey(name);
    }

    public TypeComplex registerProperty(EntityProperty property) {
        this.properties.add(property);
        this.propertiesByName.put(property.getName(), property);
        return this;
    }

    public ComplexValue instantiate() {
        return this.instantiator.instantiate();
    }

    static {
        for (Field field : FieldUtils.getAllFields(TypeComplex.class)) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                TypeComplex type = (TypeComplex)FieldUtils.readStaticField((Field)field, (boolean)false);
                String name = type.getName();
                TYPES.put(name, type);
                LOGGER.debug("Registered type: {}", (Object)name);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Failed to initialise: {}", (Object)field, (Object)ex);
            }
            catch (IllegalAccessException ex) {
                LOGGER.trace("Failed to initialise: {}", (Object)field, (Object)ex);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public static interface Instantiator {
        public ComplexValue instantiate();
    }
}

