/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.property;

import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.property.PropertyAbstract;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeEntitySet;
import java.util.Objects;

public abstract class NavigationPropertyAbstract<P>
extends PropertyAbstract<P>
implements NavigationProperty<P> {
    private EntityType entityType;
    private final boolean entitySet;
    private NavigationPropertyAbstract<?> inverse;

    protected NavigationPropertyAbstract(String propertyName, boolean isSet) {
        super(propertyName, TypeComplex.STA_OBJECT, false);
        this.entitySet = isSet;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
        if (this.entitySet) {
            this.setType(new TypeEntitySet(entityType));
        } else {
            this.setType(new TypeEntity(entityType));
        }
    }

    @Override
    public NavigationPropertyAbstract getInverse() {
        return this.inverse;
    }

    public final void setInverse(NavigationPropertyAbstract inverse) {
        this.inverse = inverse;
    }

    public final void setInverses(NavigationPropertyAbstract inverse) {
        this.inverse = inverse;
        inverse.setInverse(this);
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public boolean isEntitySet() {
        return this.entitySet;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NavigationPropertyAbstract other = (NavigationPropertyAbstract)obj;
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hashCode(this.getName());
    }
}

