/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.exception.StatusCodeException;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.JsonReader;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import de.fraunhofer.iosb.ilt.frostclient.utils.Utils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySetImpl
implements EntitySet {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EntitySetImpl.class.getName());
    protected List<Entity> data = new ArrayList<Entity>();
    protected long count = -1L;
    protected String nextLink;
    @JsonIgnore
    private final EntityType type;
    @JsonIgnore
    private NavigationPropertyEntitySet navigationProperty;
    @JsonIgnore
    private SensorThingsService service;

    public EntitySetImpl(EntityType type) {
        this.type = type;
    }

    public EntitySetImpl(NavigationPropertyEntitySet navigationProperty) {
        this.type = navigationProperty.getEntityType();
        this.navigationProperty = navigationProperty;
    }

    @Override
    public List<Entity> toList() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            private Iterator<Entity> currentIterator;
            {
                this.currentIterator = EntitySetImpl.this.data.iterator();
            }

            private void fetchNextList() {
                if (EntitySetImpl.this.nextLink == null) {
                    this.currentIterator = null;
                    return;
                }
                EntitySetImpl.this.fetchNext();
                this.currentIterator = EntitySetImpl.this.data.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.currentIterator == null) {
                    return false;
                }
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                this.fetchNextList();
                return this.hasNext();
            }

            @Override
            public Entity next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.currentIterator.next();
            }
        };
    }

    @Override
    public void fetchNext() {
        if (this.nextLink == null) {
            this.data = Collections.emptyList();
            return;
        }
        HttpGet httpGet = new HttpGet(this.nextLink);
        httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        LOGGER.debug("Fetching: {}", (Object)httpGet.getURI());
        try (CloseableHttpResponse response = this.service.execute((HttpRequestBase)httpGet);){
            Utils.throwIfNotOk((HttpRequestBase)httpGet, response);
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            JsonReader reader = new JsonReader(this.service.getModelRegistry());
            EntitySet nextSet = reader.parseEntitySet(this.type, json);
            nextSet.setService(this.service);
            this.data = nextSet.toList();
            this.nextLink = nextSet.getNextLink();
        }
        catch (IOException | ParseException exc) {
            LOGGER.error("Failed deserializing collection.", exc);
            this.nextLink = null;
            this.data = new ArrayList<Entity>();
        }
        catch (StatusCodeException exc) {
            LOGGER.error("Failed follow nextlink: {} - '{}' - {}", new Object[]{exc.getStatusCode(), this.nextLink, StringHelper.cleanForLogging(exc.getReturnedContent(), 100)});
            LOGGER.debug("Response: {}", (Object)exc.getReturnedContent());
            this.nextLink = null;
            this.data = new ArrayList<Entity>();
        }
    }

    @Override
    public void add(Entity e) {
        this.data.add(e);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntitySetImpl other = (EntitySetImpl)obj;
        return Objects.equals(this.data, other.data);
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public void setCount(long count) {
        this.count = count;
    }

    @Override
    public boolean hasNextLink() {
        return !StringHelper.isNullOrEmpty(this.nextLink);
    }

    @Override
    public String getNextLink() {
        return this.nextLink;
    }

    @Override
    public void setNextLink(String nextLink) {
        this.nextLink = nextLink;
    }

    @Override
    public EntityType getEntityType() {
        return this.type;
    }

    @Override
    public NavigationPropertyEntitySet getNavigationProperty() {
        return this.navigationProperty;
    }

    public EntitySetImpl setNavigationProperty(NavigationPropertyEntitySet navigationProperty) {
        this.navigationProperty = navigationProperty;
        return this;
    }

    @Override
    public void setService(SensorThingsService service) {
        this.service = service;
        for (Entity entity : this.data) {
            entity.setService(service);
        }
    }
}

