/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model;

import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.dao.BaseDao;
import de.fraunhofer.iosb.ilt.frostclient.dao.Dao;
import de.fraunhofer.iosb.ilt.frostclient.exception.ServiceFailureException;
import de.fraunhofer.iosb.ilt.frostclient.exception.StatusCodeException;
import de.fraunhofer.iosb.ilt.frostclient.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostclient.model.EntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.EntitySetImpl;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.PrimaryKey;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.query.Query;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entity
implements ComplexValue<Entity> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Entity.class.getName());
    private EntityType entityType;
    private final Map<EntityPropertyMain, Object> entityProperties = new HashMap<EntityPropertyMain, Object>();
    private final Map<NavigationProperty, Object> navProperties = new HashMap<NavigationProperty, Object>();
    private final Set<Property> setProperties = new HashSet<Property>();
    private SensorThingsService service;
    private String selfLink;

    public Entity(EntityType entityType) {
        this.entityType = entityType;
    }

    public final PrimaryKey getPrimaryKey() {
        return this.entityType.getPrimaryKey();
    }

    public final Object[] getPrimaryKeyValues() {
        List<EntityPropertyMain> keyProperties = this.entityType.getPrimaryKey().getKeyProperties();
        Object[] result = new Object[keyProperties.size()];
        int idx = 0;
        for (EntityPropertyMain keyProperty : keyProperties) {
            result[idx] = this.getProperty(keyProperty);
            ++idx;
        }
        return result;
    }

    public boolean primaryKeyFullySet() {
        List<EntityPropertyMain> keyProperties = this.entityType.getPrimaryKey().getKeyProperties();
        for (EntityPropertyMain keyProperty : keyProperties) {
            Object value = this.getProperty(keyProperty);
            if (value != null) continue;
            return false;
        }
        return true;
    }

    public final Entity setPrimaryKeyValues(Object ... values) {
        int idx = 0;
        for (EntityPropertyMain keyProperty : this.entityType.getPrimaryKey().getKeyProperties()) {
            if (idx >= values.length) {
                throw new IllegalArgumentException("No value given for keyProperty " + idx);
            }
            this.setProperty((Property)keyProperty, values[idx]);
            ++idx;
        }
        return this;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Entity setSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public Entity setEntityType(EntityType entityType) {
        if (this.entityType != null) {
            throw new IllegalArgumentException("the type of this entity is alread yet to " + this.entityType.entityName);
        }
        this.entityType = entityType;
        return this;
    }

    public boolean isSetProperty(Property property) {
        if (property == ModelRegistry.EP_SELFLINK) {
            return true;
        }
        return this.setProperties.contains(property);
    }

    @Override
    public <P> P getProperty(Property<P> property) {
        return this.getProperty(property, true);
    }

    public <P> P getProperty(NavigationPropertyEntity property) throws ServiceFailureException {
        return this.getProperty(property, true);
    }

    public <P> P getProperty(NavigationPropertyEntity npe, boolean autoLoad) throws ServiceFailureException {
        Entity entity = (Entity)this.navProperties.get(npe);
        if (entity == null && autoLoad) {
            try {
                entity = this.service.dao(npe.getEntityType()).find(this, npe);
                this.setProperty((Property)npe, entity);
            }
            catch (StatusCodeException ex) {
                if (ex.getStatusCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return (P)entity;
    }

    public <P> P getProperty(Property<P> property, boolean autoLoad) {
        if (property == null) {
            return null;
        }
        if (property == ModelRegistry.EP_SELFLINK) {
            return (P)this.getSelfLink();
        }
        if (!this.entityType.hasProperty(property)) {
            throw new IllegalArgumentException(this.entityType.entityName + " has no property " + property.getName());
        }
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain epm = (EntityPropertyMain)property;
            return (P)this.entityProperties.get(epm);
        }
        if (property instanceof NavigationPropertyEntity) {
            NavigationPropertyEntity npe = (NavigationPropertyEntity)property;
            try {
                return this.getProperty(npe, autoLoad);
            }
            catch (ServiceFailureException ex) {
                LOGGER.error("Failed to load linked entity {}", (Object)npe, (Object)ex.getMessage());
                throw new RuntimeException(ex);
            }
        }
        if (property instanceof NavigationPropertyEntitySet) {
            NavigationPropertyEntitySet npes = (NavigationPropertyEntitySet)property;
            EntitySet entitySet = (EntitySet)this.navProperties.get(npes);
            if (entitySet == null && autoLoad) {
                entitySet = new EntitySetImpl(npes);
                this.setProperty((Property)npes, entitySet);
            }
            return (P)entitySet;
        }
        return null;
    }

    @Override
    public <P> Entity setProperty(Property<P> property, P value) {
        if (property == ModelRegistry.EP_SELFLINK) {
            this.setSelfLink(String.valueOf(value));
            return this;
        }
        if (!this.entityType.hasProperty(property)) {
            throw new IllegalArgumentException(this.entityType.entityName + " has no property " + property.getName());
        }
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain epm = (EntityPropertyMain)property;
            this.entityProperties.put(epm, value);
            this.setProperties.add(property);
        } else if (property instanceof NavigationProperty) {
            NavigationProperty np = (NavigationProperty)property;
            this.navProperties.put(np, value);
            if (value == null) {
                this.setProperties.remove(property);
            } else {
                this.setProperties.add(property);
            }
        }
        return this;
    }

    public Entity unsetProperty(Property property) {
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain epm = (EntityPropertyMain)property;
            this.entityProperties.remove(epm);
        } else if (property instanceof NavigationProperty) {
            NavigationProperty np = (NavigationProperty)property;
            this.navProperties.remove(np);
        }
        this.setProperties.remove(property);
        return this;
    }

    public Entity addNavigationEntity(NavigationPropertyEntitySet navProperty, Entity linkedEntity) {
        EntitySet entitySet = this.getProperty(navProperty);
        if (entitySet == null) {
            entitySet = new EntitySetImpl(navProperty);
            this.setProperty((Property)navProperty, entitySet);
        }
        entitySet.add(linkedEntity);
        return this;
    }

    public Entity addNavigationEntity(NavigationPropertyEntitySet navProperty, List<Entity> linkedEntities) {
        for (Entity linkedEntity : linkedEntities) {
            this.addNavigationEntity(navProperty, linkedEntity);
        }
        return this;
    }

    public Entity addNavigationEntity(NavigationPropertyEntitySet navProperty, Entity ... linkedEntities) {
        for (Entity linkedEntity : linkedEntities) {
            this.addNavigationEntity(navProperty, linkedEntity);
        }
        return this;
    }

    public boolean hasService() {
        return this.service != null;
    }

    public SensorThingsService getService() {
        return this.service;
    }

    public void setService(SensorThingsService service) {
        this.service = service;
    }

    public Entity withOnlyPk() {
        Entity copy = new Entity(this.entityType);
        List<EntityPropertyMain> pkProps = this.getPrimaryKey().getKeyProperties();
        for (EntityPropertyMain pkProp : pkProps) {
            copy.setProperty((Property)pkProp, this.getProperty(pkProp));
        }
        copy.setService(this.service);
        return copy;
    }

    public Query query(NavigationPropertyEntitySet navigationPropery) {
        if (this.service == null) {
            throw new IllegalArgumentException("Can not query from an entity not associated with a service.");
        }
        return new Query(this.service, this, navigationPropery);
    }

    public Dao dao(NavigationPropertyEntitySet navigationPropery) {
        if (this.service == null) {
            throw new IllegalArgumentException("Can not query from an entity not associated with a service.");
        }
        return new BaseDao(this.service, this, navigationPropery);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        if (!Objects.equals(this.entityType, other.entityType)) {
            return false;
        }
        if (!Objects.equals(this.entityProperties, other.entityProperties)) {
            return false;
        }
        return Objects.equals(this.navProperties, other.navProperties);
    }

    public int hashCode() {
        return Objects.hash(this.entityType, this.entityProperties, this.navProperties);
    }

    public String toString() {
        return "Entity: " + this.entityType + " " + Arrays.toString(this.getPrimaryKeyValues());
    }
}

