/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.json.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.fraunhofer.iosb.ilt.frostclient.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostclient.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostclient.model.ext.TimeValue;
import java.io.IOException;

public class TimeValueDeserializer
extends StdDeserializer<TimeValue> {
    public TimeValueDeserializer() {
        super(TimeValue.class);
    }

    public TimeValue deserialize(JsonParser jp, DeserializationContext dc) throws IOException {
        String node = jp.getValueAsString();
        if (node == null) {
            return null;
        }
        try {
            return new TimeValue(TimeInstant.parse(node));
        }
        catch (IllegalArgumentException e) {
            return new TimeValue(TimeInterval.parse(node));
        }
    }
}

