/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.utils;

import com.fasterxml.jackson.databind.JsonNode;
import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.exception.NotAuthorizedException;
import de.fraunhofer.iosb.ilt.frostclient.exception.NotFoundException;
import de.fraunhofer.iosb.ilt.frostclient.exception.StatusCodeException;
import de.fraunhofer.iosb.ilt.frostclient.json.SimpleJsonMapper;
import de.fraunhofer.iosb.ilt.frostclient.models.CSDLModel;
import de.fraunhofer.iosb.ilt.frostclient.models.DataModel;
import de.fraunhofer.iosb.ilt.frostclient.models.SensorThingsMultiDatastreamV11;
import de.fraunhofer.iosb.ilt.frostclient.models.SensorThingsPlus;
import de.fraunhofer.iosb.ilt.frostclient.models.SensorThingsSensingV11;
import de.fraunhofer.iosb.ilt.frostclient.models.SensorThingsTaskingV11;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final String NAME_NAME = "name";
    private static final String NAME_VALUE = "value";
    private static final String NAME_HEADER_ACCEPT = "Accept";
    private static final String NAME_HEADER_ODATA_VERSION = "OData-Version";
    private static final String NAME_CONFORMANCE = "conformance";
    private static final String NAME_SERVER_SETTINGS = "serverSettings";

    public static void throwIfNotOk(HttpRequestBase request, CloseableHttpResponse response) throws StatusCodeException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 204) {
            throw new StatusCodeException(request.getURI().toString(), statusCode, response.getStatusLine().getReasonPhrase(), "");
        }
        if (statusCode < 200 || statusCode >= 300 || statusCode == 204) {
            String returnContent = null;
            try {
                returnContent = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            }
            catch (IOException exc) {
                LOGGER.warn("Failed to get content from error response.", (Throwable)exc);
            }
            if (statusCode == 401 || statusCode == 403) {
                request.getURI();
                throw new NotAuthorizedException(statusCode, request.getURI().toString(), response.getStatusLine().getReasonPhrase(), returnContent);
            }
            if (statusCode == 404) {
                throw new NotFoundException(request.getURI().toString(), response.getStatusLine().getReasonPhrase(), returnContent);
            }
            throw new StatusCodeException(request.getURI().toString(), statusCode, response.getStatusLine().getReasonPhrase(), returnContent);
        }
    }

    public static void createInsecureHttpClient(SensorThingsService service) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
        NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
        SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts);
        service.getClientBuilder().setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory);
        service.rebuildHttpClient();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<DataModel> detectModels(SensorThingsService service, URL endpoint) {
        HttpGet httpGet;
        ArrayList<DataModel> result = new ArrayList<DataModel>();
        try {
            httpGet = new HttpGet(endpoint.toURI());
            LOGGER.debug("Fetching: {}", (Object)httpGet.getURI());
            httpGet.addHeader(NAME_HEADER_ACCEPT, ContentType.APPLICATION_JSON.getMimeType());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Could not generate context url.", ex);
        }
        try (CloseableHttpResponse response = service.execute((HttpRequestBase)httpGet);){
            HashSet<KnownModels> foundModels;
            block35: {
                Iterator it;
                block36: {
                    Iterator entries;
                    block34: {
                        JsonNode tree;
                        block33: {
                            Utils.throwIfNotOk((HttpRequestBase)httpGet, response);
                            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
                            tree = SimpleJsonMapper.getSimpleObjectMapper().readTree(json);
                            Header[] odataVersion = response.getHeaders(NAME_HEADER_ODATA_VERSION);
                            if (tree.has("@context") && odataVersion.length > 0) {
                                LOGGER.info("Detected OData 4.01.");
                                result.add(new CSDLModel());
                                ArrayList<DataModel> arrayList = result;
                                return arrayList;
                            }
                            foundModels = new HashSet<KnownModels>();
                            if (!tree.has(NAME_SERVER_SETTINGS)) break block33;
                            JsonNode serverSettings = tree.get(NAME_SERVER_SETTINGS);
                            JsonNode conformance = serverSettings.get(NAME_CONFORMANCE);
                            entries = conformance.elements();
                            break block34;
                        }
                        if (!tree.has(NAME_VALUE)) break block35;
                        JsonNode entities = tree.get(NAME_VALUE);
                        it = entities.elements();
                        break block36;
                    }
                    while (entries.hasNext()) {
                        String confClass = ((JsonNode)entries.next()).textValue();
                        if (confClass.startsWith("http://www.opengis.net/spec/iot_sensing/1.1/req/datamodel")) {
                            foundModels.add(KnownModels.STA_SENSING);
                            continue;
                        }
                        if (confClass.startsWith("http://www.opengis.net/spec/iot_sensing/1.1/req/multi-datastream")) {
                            foundModels.add(KnownModels.STA_MULTIDATASTREAM);
                            continue;
                        }
                        if (confClass.startsWith("http://www.opengis.net/spec/iot_sensing/1.1/req/actuator")) {
                            foundModels.add(KnownModels.STA_TASKING);
                            continue;
                        }
                        if (!confClass.startsWith("http://www.opengis.net/spec/sensorthings-staplus/1.0/conf/core")) continue;
                        foundModels.add(KnownModels.STA_PLUS);
                    }
                    break block35;
                }
                block24: while (it.hasNext()) {
                    String entityName;
                    switch (entityName = ((JsonNode)it.next()).get(NAME_NAME).textValue()) {
                        case "Things": {
                            foundModels.add(KnownModels.STA_SENSING);
                            break;
                        }
                        case "MultiDatastreams": {
                            foundModels.add(KnownModels.STA_MULTIDATASTREAM);
                            break;
                        }
                        case "Tasks": {
                            foundModels.add(KnownModels.STA_TASKING);
                            break;
                        }
                        case "Parties": {
                            foundModels.add(KnownModels.STA_PLUS);
                            continue block24;
                        }
                    }
                }
            }
            if (foundModels.contains((Object)KnownModels.STA_SENSING)) {
                LOGGER.info("Detected STA Sensing.");
                result.add(new SensorThingsSensingV11());
            }
            if (foundModels.contains((Object)KnownModels.STA_MULTIDATASTREAM)) {
                LOGGER.info("Detected STA MultiDatastream.");
                result.add(new SensorThingsMultiDatastreamV11());
            }
            if (foundModels.contains((Object)KnownModels.STA_TASKING)) {
                LOGGER.info("Detected STA Tasking.");
                result.add(new SensorThingsTaskingV11());
            }
            if (!foundModels.contains((Object)KnownModels.STA_PLUS)) return result;
            LOGGER.info("Detected STAplus.");
            result.add(new SensorThingsPlus());
            return result;
        }
        catch (IOException ex) {
            LOGGER.error("Failed to parse metadata", (Throwable)ex);
            return result;
        }
        catch (StatusCodeException ex) {
            LOGGER.error("Failed to request metadata", (Throwable)ex);
        }
        return result;
    }

    private static enum KnownModels {
        STA_SENSING,
        STA_MULTIDATASTREAM,
        STA_TASKING,
        STA_PLUS;

    }
}

