/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntitySet;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.MapValue;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.UnitOfMeasurement;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.geojson.GeoJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeReferencesHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TypeReferencesHelper.class.getName());
    public static final TypeReference<BigDecimal> TYPE_REFERENCE_BIGDECIMAL = new TypeReference<BigDecimal>(){};
    public static final TypeReference<Boolean> TYPE_REFERENCE_BOOLEAN = new TypeReference<Boolean>(){};
    public static final TypeReference<Date> TYPE_REFERENCE_DATE = new TypeReference<Date>(){};
    public static final TypeReference<Duration> TYPE_REFERENCE_DURATION = new TypeReference<Duration>(){};
    public static final TypeReference<Entity> TYPE_REFERENCE_ENTITY = new TypeReference<Entity>(){};
    public static final TypeReference<EntitySet> TYPE_REFERENCE_ENTITYSET = new TypeReference<EntitySet>(){};
    public static final TypeReference<GeoJsonObject> TYPE_REFERENCE_GEOJSONOBJECT = new TypeReference<GeoJsonObject>(){};
    public static final TypeReference<Integer> TYPE_REFERENCE_INTEGER = new TypeReference<Integer>(){};
    public static final TypeReference<List<String>> TYPE_REFERENCE_LIST_STRING = new TypeReference<List<String>>(){};
    public static final TypeReference<Long> TYPE_REFERENCE_LONG = new TypeReference<Long>(){};
    public static final TypeReference<List<UnitOfMeasurement>> TYPE_REFERENCE_LIST_UOM = new TypeReference<List<UnitOfMeasurement>>(){};
    public static final TypeReference<Map<String, Object>> TYPE_REFERENCE_MAP = new TypeReference<Map<String, Object>>(){};
    public static final TypeReference<MapValue> TYPE_REFERENCE_MAPVALUE = new TypeReference<MapValue>(){};
    public static final TypeReference<Number> TYPE_REFERENCE_NUMBER = new TypeReference<Number>(){};
    public static final TypeReference<Object> TYPE_REFERENCE_OBJECT = new TypeReference<Object>(){};
    public static final TypeReference<String> TYPE_REFERENCE_STRING = new TypeReference<String>(){};
    public static final TypeReference<TimeInstant> TYPE_REFERENCE_TIMEINSTANT = new TypeReference<TimeInstant>(){};
    public static final TypeReference<TimeInterval> TYPE_REFERENCE_TIMEINTERVAL = new TypeReference<TimeInterval>(){};
    public static final TypeReference<TimeValue> TYPE_REFERENCE_TIMEVALUE = new TypeReference<TimeValue>(){};
    public static final TypeReference<UnitOfMeasurement> TYPE_REFERENCE_UOM = new TypeReference<UnitOfMeasurement>(){};
    public static final TypeReference<UUID> TYPE_REFERENCE_UUID = new TypeReference<UUID>(){};
    private static final Map<String, TypeReference> REFERENCES = new HashMap<String, TypeReference>();

    private TypeReferencesHelper() {
    }

    public static TypeReference getTypeReference(String name) {
        return REFERENCES.get(name.toLowerCase());
    }

    static {
        for (Field field : FieldUtils.getAllFields(TypeReferencesHelper.class)) {
            try {
                TypeReference referenceValue = (TypeReference)FieldUtils.readStaticField((Field)field, (boolean)false);
                String referenceName = field.getName().substring(15).toLowerCase();
                REFERENCES.put(referenceName, referenceValue);
                LOGGER.debug("Registered type: {}", (Object)referenceName);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Failed to initialise: {}", (Object)field, (Object)ex);
            }
            catch (IllegalAccessException ex) {
                LOGGER.trace("Failed to initialise: {}", (Object)field, (Object)ex);
            }
        }
    }
}

