/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.utils;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import de.fraunhofer.iosb.ilt.frostclient.json.SimpleJsonMapper;
import de.fraunhofer.iosb.ilt.frostclient.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.io.IOException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.geojson.GeoJsonObject;

public class ParserUtils {
    private ParserUtils() {
    }

    public static String entityPath(EntityType entityType, Object ... primaryKeyValues) {
        return String.format("%s(%s)", entityType.mainContainer, ParserUtils.formatKeyValuesForUrl(primaryKeyValues));
    }

    public static String relationPath(Entity parent, NavigationProperty relation) {
        if (parent == null) {
            throw new IllegalArgumentException("Can't generate path for null entity.");
        }
        if (!parent.getEntityType().getNavigationProperties().contains(relation)) {
            throw new IllegalArgumentException("Entity of type " + parent.getEntityType() + " has no relation of type " + relation + ".");
        }
        return String.format("%s(%s)/%s", parent.getEntityType().mainContainer, ParserUtils.formatKeyValuesForUrl(parent.getPrimaryKeyValues()), relation.getName());
    }

    public static String formatKeyValuesForUrl(Entity entity) {
        return ParserUtils.formatKeyValuesForUrl(entity.getPrimaryKeyValues());
    }

    public static String formatKeyValuesForUrl(Object ... pkeyValues) {
        if (pkeyValues.length == 1) {
            if (pkeyValues[0] == null) {
                throw new IllegalArgumentException("Primary key value must be non-null");
            }
            return StringHelper.quoteForUrl(pkeyValues[0]);
        }
        throw new NotImplementedException("Multi-valued primary keys are not supported yet.");
    }

    public static Object[] tryToParse(String input) {
        if (input.startsWith("'")) {
            return new Object[]{StringUtils.replace((String)input.substring(1, input.length() - 1), (String)"''", (String)"'")};
        }
        try {
            return new Object[]{Long.valueOf(input)};
        }
        catch (NumberFormatException numberFormatException) {
            return new Object[]{input};
        }
    }

    public static boolean objectToBoolean(Object data, boolean dflt) {
        if (data == null) {
            return dflt;
        }
        if (data instanceof Boolean) {
            Boolean bool = (Boolean)data;
            return bool;
        }
        return Boolean.parseBoolean(data.toString());
    }

    public static <T> JsonDeserializer<T> getDefaultDeserializer(final TypeReference<T> tr) {
        return new JsonDeserializer<T>(){

            public T deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JacksonException {
                return jp.readValueAs(tr);
            }
        };
    }

    public static JsonDeserializer<Object> getLocationDeserializer() {
        return new JsonDeserializer<Object>(){

            public Object deserialize(JsonParser jp, DeserializationContext dc) throws IOException {
                ObjectMapper simpleObjectMapper = SimpleJsonMapper.getSimpleObjectMapper();
                TreeNode valueTree = jp.readValueAsTree();
                try {
                    return simpleObjectMapper.treeToValue(valueTree, GeoJsonObject.class);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    return simpleObjectMapper.treeToValue(valueTree, String.class);
                }
            }
        };
    }

    public static JsonDeserializer<ComplexValue> getComplexTypeDeserializer(TypeComplex type) {
        return new ComplexTypeDeserializer(type);
    }

    public static JsonSerializer<Object> getDefaultSerializer() {
        return new JsonSerializer<Object>(){

            public void serialize(Object t, JsonGenerator jg, SerializerProvider sp) throws IOException {
                jg.writePOJO(t);
            }
        };
    }

    private static class ComplexTypeDeserializer
    extends JsonDeserializer<ComplexValue> {
        private final TypeComplex type;

        public ComplexTypeDeserializer(TypeComplex type) {
            this.type = type;
        }

        public ComplexValue deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
            ComplexValue result = this.type.instantiate();
            JsonToken currentToken = parser.currentToken();
            if (currentToken == JsonToken.VALUE_NULL) {
                return null;
            }
            currentToken = parser.nextToken();
            while (currentToken == JsonToken.FIELD_NAME) {
                String fieldName = parser.getCurrentName();
                parser.nextValue();
                Property property = this.type.getProperty(fieldName);
                if (property == null) {
                    if (!this.type.isOpenType()) {
                        String message = "Unknown field: " + fieldName + " on " + this.type.getName() + " expected one of: " + this.type.getPropertiesByName().keySet();
                        throw new UnrecognizedPropertyException(parser, message, parser.getCurrentLocation(), TypeComplex.class, fieldName, null);
                    }
                    result.setProperty(fieldName, parser.readValueAsTree());
                } else {
                    this.deserializeProperty(parser, ctxt, property, result);
                }
                currentToken = parser.nextToken();
            }
            return result;
        }

        private void deserializeProperty(JsonParser parser, DeserializationContext ctxt, Property property, ComplexValue result) throws IOException {
            if (property instanceof EntityPropertyMain) {
                EntityPropertyMain epm = (EntityPropertyMain)property;
                this.deserializeEntityProperty(parser, ctxt, epm, result);
            } else if (property instanceof NavigationProperty) {
                throw new IllegalArgumentException("NavigationProperties not supported on ComplexTypes.");
            }
        }

        private void deserializeEntityProperty(JsonParser parser, DeserializationContext ctxt, EntityPropertyMain property, ComplexValue result) throws IOException {
            JsonDeserializer deserializer = property.getType().getDeserializer();
            if (deserializer == null) {
                Object value = parser.readValueAs(Object.class);
                result.setProperty(property, value);
            } else {
                Object value = deserializer.deserialize(parser, ctxt);
                result.setProperty(property, value);
            }
        }
    }
}

