/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.query;

import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.exception.ServiceFailureException;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.query.QueryParameter;
import de.fraunhofer.iosb.ilt.frostclient.query.QueryRequest;
import de.fraunhofer.iosb.ilt.frostclient.utils.Utils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query
implements QueryRequest,
QueryParameter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Query.class);
    private final SensorThingsService service;
    private final EntityType entityType;
    private final Entity parent;
    private final NavigationPropertyEntitySet navigationLink;
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();

    public Query(SensorThingsService service, EntityType entityType) {
        this.service = service;
        this.entityType = entityType;
        this.parent = null;
        this.navigationLink = null;
    }

    public Query(SensorThingsService service, Entity parent, NavigationPropertyEntitySet navigationLink) {
        this.service = service;
        this.entityType = navigationLink.getEntityType();
        if (!parent.getEntityType().getNavigationSets().contains(navigationLink)) {
            throw new IllegalArgumentException("Entity " + parent + " has no navigationProperty " + navigationLink);
        }
        this.navigationLink = navigationLink;
        this.parent = parent;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public SensorThingsService getService() {
        return this.service;
    }

    private void removeAllParams(String key) {
        Iterator<NameValuePair> it = this.params.iterator();
        while (it.hasNext()) {
            NameValuePair param = it.next();
            if (!param.getName().equals(key)) continue;
            it.remove();
            break;
        }
    }

    @Override
    public Query filter(String options) {
        this.removeAllParams("$filter");
        if (options.isEmpty()) {
            return this;
        }
        this.params.add((NameValuePair)new BasicNameValuePair("$filter", options));
        return this;
    }

    @Override
    public Query top(int n) {
        this.removeAllParams("$top");
        this.params.add((NameValuePair)new BasicNameValuePair("$top", Integer.toString(n)));
        return this;
    }

    @Override
    public Query orderBy(String clause) {
        this.removeAllParams("$orderby");
        this.params.add((NameValuePair)new BasicNameValuePair("$orderby", clause));
        return this;
    }

    @Override
    public Query skip(int n) {
        this.removeAllParams("$skip");
        this.params.add((NameValuePair)new BasicNameValuePair("$skip", Integer.toString(n)));
        return this;
    }

    @Override
    public Query count() {
        this.removeAllParams("$count");
        this.params.add((NameValuePair)new BasicNameValuePair("$count", "true"));
        return this;
    }

    public Query expand(String expansion) {
        this.removeAllParams("$expand");
        this.params.add((NameValuePair)new BasicNameValuePair("$expand", expansion));
        return this;
    }

    public Query select(String ... fields) {
        this.removeAllParams("$select");
        if (fields == null) {
            return this;
        }
        StringBuilder selectValue = new StringBuilder();
        for (String field : fields) {
            selectValue.append(field).append(",");
        }
        if (selectValue.length() == 0) {
            return this;
        }
        String select = selectValue.substring(0, selectValue.length() - 1);
        if (select.isEmpty()) {
            return this;
        }
        this.params.add((NameValuePair)new BasicNameValuePair("$select", select));
        return this;
    }

    @Override
    public Entity first() throws ServiceFailureException {
        this.top(1);
        List<Entity> asList = this.list().toList();
        if (asList.isEmpty()) {
            return null;
        }
        return asList.get(0);
    }

    @Override
    public EntitySet list() throws ServiceFailureException {
        EntitySet list;
        HttpGet httpGet;
        try {
            URIBuilder uriBuilder = this.parent == null ? new URIBuilder(this.service.getFullPath(this.entityType).toURI()) : new URIBuilder(this.service.getFullPath(this.parent, this.navigationLink).toURI());
            uriBuilder.addParameters(this.params);
            httpGet = new HttpGet(uriBuilder.build());
        }
        catch (URISyntaxException ex) {
            throw new ServiceFailureException("Failed to fetch entities from query.", ex);
        }
        LOGGER.debug("Fetching: {}", (Object)httpGet.getURI());
        httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        try (CloseableHttpResponse response = this.service.execute((HttpRequestBase)httpGet);){
            Utils.throwIfNotOk((HttpRequestBase)httpGet, response);
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            list = this.service.getJsonReader().parseEntitySet(this.entityType, json);
        }
        catch (IOException ex) {
            throw new ServiceFailureException("Failed to fetch entities from query.", ex);
        }
        list.setService(this.service);
        return list;
    }

    public void delete() throws ServiceFailureException {
        HttpDelete httpDelete;
        this.removeAllParams("$top");
        this.removeAllParams("$skip");
        this.removeAllParams("$count");
        this.removeAllParams("$select");
        this.removeAllParams("$expand");
        try {
            URIBuilder uriBuilder = this.parent != null ? new URIBuilder(this.service.getFullPath(this.parent, this.navigationLink).toURI()) : new URIBuilder(this.service.getFullPath(this.entityType).toURI());
            uriBuilder.addParameters(this.params);
            httpDelete = new HttpDelete(uriBuilder.build());
        }
        catch (URISyntaxException ex) {
            throw new ServiceFailureException("Failed to delete from query.", ex);
        }
        LOGGER.debug("Deleting: {}", (Object)httpDelete.getURI());
        httpDelete.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        try (CloseableHttpResponse response = this.service.execute((HttpRequestBase)httpDelete);){
            Utils.throwIfNotOk((HttpRequestBase)httpDelete, response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        catch (IOException ex) {
            throw new ServiceFailureException("Failed to delete from query.", ex);
        }
    }
}

