/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.ext;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.frostclient.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MapValue
implements ComplexValue<MapValue> {
    private final Map<String, Object> content;

    public MapValue() {
        this.content = new LinkedHashMap<String, Object>();
    }

    public MapValue(Map<String, Object> content) {
        this.content = content;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @JsonAnyGetter
    public Map<String, Object> getContent() {
        return this.content;
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.content.entrySet();
    }

    @JsonIgnore
    public Object get(String name) {
        return this.content.get(name);
    }

    public boolean containsKey(String name) {
        return this.content.containsKey(name);
    }

    @JsonAnySetter
    public MapValue put(String name, Object value) {
        this.content.put(name, value);
        return this;
    }

    @Override
    @JsonIgnore
    public <P> P getProperty(Property<P> property) {
        return (P)this.content.get(property.getJsonName());
    }

    @Override
    @JsonIgnore
    public <P> MapValue setProperty(Property<P> property, P value) {
        this.content.put(property.getJsonName(), value);
        return this;
    }

    @Override
    public Object getProperty(String name) {
        return this.content.get(name);
    }

    @Override
    public MapValue setProperty(String name, Object value) {
        this.content.put(name, value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MapValue) {
            MapValue o = (MapValue)obj;
            return this.content.equals(o.content);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        return 79 * hash + Objects.hashCode(this.content);
    }
}

