/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.property.type;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import de.fraunhofer.iosb.ilt.frostclient.model.PropertyType;
import de.fraunhofer.iosb.ilt.frostclient.utils.ParserUtils;
import de.fraunhofer.iosb.ilt.frostclient.utils.TypeReferencesHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypePrimitive
extends PropertyType {
    public static final String EDM_BINARY_NAME = "Edm.Binary";
    public static final String EDM_BOOLEAN_NAME = "Edm.Boolean";
    public static final String EDM_BYTE_NAME = "Edm.Byte";
    public static final String EDM_DATE_NAME = "Edm.Date";
    public static final String EDM_DATETIMEOFFSET_NAME = "Edm.DateTimeOffset";
    public static final String EDM_DECIMAL_NAME = "Edm.Decimal";
    public static final String EDM_DOUBLE_NAME = "Edm.Double";
    public static final String EDM_DURATION_NAME = "Edm.Duration";
    public static final String EDM_GUID_NAME = "Edm.Guid";
    public static final String EDM_INT16_NAME = "Edm.Int16";
    public static final String EDM_INT32_NAME = "Edm.Int32";
    public static final String EDM_INT64_NAME = "Edm.Int64";
    public static final String EDM_SBYTE_NAME = "Edm.SByte";
    public static final String EDM_SINGLE_NAME = "Edm.Single";
    public static final String EDM_STREAM_NAME = "Edm.Stream";
    public static final String EDM_STRING_NAME = "Edm.String";
    public static final String EDM_TIMEOFDAY_NAME = "Edm.TimeOfDay";
    public static final String EDM_GEOGRAPHY_NAME = "Edm.Geography";
    public static final String EDM_GEOGRAPHYPOINT_NAME = "Edm.GeographyPoint";
    public static final String EDM_GEOGRAPHYLINESTRING_NAME = "Edm.GeographyLineString";
    public static final String EDM_GEOGRAPHYPOLYGON_NAME = "Edm.GeographyPolygon";
    public static final String EDM_GEOGRAPHYMULTIPOINT_NAME = "Edm.GeographyMultiPoint";
    public static final String EDM_GEOGRAPHYMULTILINESTRING_NAME = "Edm.GeographyMultiLineString";
    public static final String EDM_GEOGRAPHYMULTIPOLYGON_NAME = "Edm.GeographyMultiPolygon";
    public static final String EDM_GEOGRAPHYCOLLECTION_NAME = "Edm.GeographyCollection";
    public static final String EDM_GEOMETRY_NAME = "Edm.Geometry";
    public static final String EDM_GEOMETRYPOINT_NAME = "Edm.GeometryPoint";
    public static final String EDM_GEOMETRYLINESTRING_NAME = "Edm.GeometryLineString";
    public static final String EDM_GEOMETRYPOLYGON_NAME = "Edm.GeometryPolygon";
    public static final String EDM_GEOMETRYMULTIPOINT_NAME = "Edm.GeometryMultiPoint";
    public static final String EDM_GEOMETRYMULTILINESTRING_NAME = "Edm.GeometryMultiLineString";
    public static final String EDM_GEOMETRYMULTIPOLYGON_NAME = "Edm.GeometryMultiPolygon";
    public static final String EDM_GEOMETRYCOLLECTION_NAME = "Edm.GeometryCollection";
    public static final String EDM_UNTYPED_NAME = "Edm.Untyped";
    public static final TypePrimitive EDM_BINARY = new TypePrimitive("Edm.Binary", "Binary data", TypeReferencesHelper.TYPE_REFERENCE_STRING);
    public static final TypePrimitive EDM_BOOLEAN = new TypePrimitive("Edm.Boolean", "Binary-valued logic", TypeReferencesHelper.TYPE_REFERENCE_BOOLEAN);
    public static final TypePrimitive EDM_BYTE = new TypePrimitive("Edm.Byte", "Unsigned 8-bit integer", TypeReferencesHelper.TYPE_REFERENCE_INTEGER);
    public static final TypePrimitive EDM_DATE = new TypePrimitive("Edm.Date", "Date without a time-zone offset", TypeReferencesHelper.TYPE_REFERENCE_DATE);
    public static final TypePrimitive EDM_DATETIMEOFFSET = new TypePrimitive("Edm.DateTimeOffset", "Date and time with a time-zone offset, no leap seconds", TypeReferencesHelper.TYPE_REFERENCE_TIMEINSTANT);
    public static final TypePrimitive EDM_DECIMAL = new TypePrimitive("Edm.Decimal", "Numeric values with decimal representation", TypeReferencesHelper.TYPE_REFERENCE_BIGDECIMAL);
    public static final TypePrimitive EDM_DOUBLE = new TypePrimitive("Edm.Double", "IEEE 754 binary64 floating-point number (15-17 decimal digits)", TypeReferencesHelper.TYPE_REFERENCE_BIGDECIMAL);
    public static final TypePrimitive EDM_DURATION = new TypePrimitive("Edm.Duration", "Signed duration in days, hours, minutes, and (sub)seconds", TypeReferencesHelper.TYPE_REFERENCE_DURATION);
    public static final TypePrimitive EDM_GUID = new TypePrimitive("Edm.Guid", "16-byte (128-bit) unique identifier", TypeReferencesHelper.TYPE_REFERENCE_UUID);
    public static final TypePrimitive EDM_INT16 = new TypePrimitive("Edm.Int16", "Signed 16-bit integer", TypeReferencesHelper.TYPE_REFERENCE_INTEGER);
    public static final TypePrimitive EDM_INT32 = new TypePrimitive("Edm.Int32", "Signed 32-bit integer", TypeReferencesHelper.TYPE_REFERENCE_INTEGER);
    public static final TypePrimitive EDM_INT64 = new TypePrimitive("Edm.Int64", "Signed 64-bit integer", TypeReferencesHelper.TYPE_REFERENCE_LONG);
    public static final TypePrimitive EDM_SBYTE = new TypePrimitive("Edm.SByte", "Signed 8-bit integer", TypeReferencesHelper.TYPE_REFERENCE_INTEGER);
    public static final TypePrimitive EDM_SINGLE = new TypePrimitive("Edm.Single", "IEEE 754 binary32 floating-point number (6-9 decimal digits)", TypeReferencesHelper.TYPE_REFERENCE_BIGDECIMAL);
    public static final TypePrimitive EDM_STREAM = new TypePrimitive("Edm.Stream", "Binary data stream", TypeReferencesHelper.TYPE_REFERENCE_STRING);
    public static final TypePrimitive EDM_STRING = new TypePrimitive("Edm.String", "Sequence of characters", TypeReferencesHelper.TYPE_REFERENCE_STRING);
    public static final TypePrimitive EDM_TIMEOFDAY = new TypePrimitive("Edm.TimeOfDay", "Clock time 00:00-23:59:59.999999999999", TypeReferencesHelper.TYPE_REFERENCE_DATE);
    public static final TypePrimitive EDM_GEOGRAPHY = new TypePrimitive("Edm.Geography", "Abstract base type for all Geography types", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOGRAPHYPOINT = new TypePrimitive("Edm.GeographyPoint", "A point in a round-earth coordinate system", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOGRAPHYLINESTRING = new TypePrimitive("Edm.GeographyLineString", "Line string in a round-earth coordinate system", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOGRAPHYPOLYGON = new TypePrimitive("Edm.GeographyPolygon", "Polygon in a round-earth coordinate system", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOGRAPHYMULTIPOINT = new TypePrimitive("Edm.GeographyMultiPoint", "Collection of points in a round-earth coordinate system", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOGRAPHYMULTILINESTRING = new TypePrimitive("Edm.GeographyMultiLineString", "Collection of line strings in a round-earth coordinate system", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOGRAPHYMULTIPOLYGON = new TypePrimitive("Edm.GeographyMultiPolygon", "Collection of polygons in a round-earth coordinate system", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOGRAPHYCOLLECTION = new TypePrimitive("Edm.GeographyCollection", "Collection of arbitrary Geography values", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOMETRY = new TypePrimitive("Edm.Geometry", "Abstract base type for all Geometry types", ParserUtils.getLocationDeserializer());
    public static final TypePrimitive EDM_GEOMETRYPOINT = new TypePrimitive("Edm.GeometryPoint", "Point in a flat-earth coordinate system", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOMETRYLINESTRING = new TypePrimitive("Edm.GeometryLineString", "Line string in a flat-earth coordinate system", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOMETRYPOLYGON = new TypePrimitive("Edm.GeometryPolygon", "Polygon in a flat-earth coordinate system", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOMETRYMULTIPOINT = new TypePrimitive("Edm.GeometryMultiPoint", "Collection of points in a flat-earth coordinate system", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOMETRYMULTILINESTRING = new TypePrimitive("Edm.GeometryMultiLineString", "Collection of line strings in a flat-earth coordinate system", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOMETRYMULTIPOLYGON = new TypePrimitive("Edm.GeometryMultiPolygon", "Collection of polygons in a flat-earth coordinate system", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_GEOMETRYCOLLECTION = new TypePrimitive("Edm.GeometryCollection", "Collection of arbitrary Geometry values", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive EDM_UNTYPED = new TypePrimitive("Edm.Untyped", "Can be any valid JSON.", TypeReferencesHelper.TYPE_REFERENCE_OBJECT);
    public static final TypePrimitive STA_ID_LONG = EDM_INT64;
    public static final TypePrimitive STA_ID_STRING = EDM_STRING;
    public static final TypePrimitive STA_ID_UUID = EDM_GUID;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TypePrimitive.class.getName());
    private static final Map<String, TypePrimitive> TYPES = new HashMap<String, TypePrimitive>();

    public static TypePrimitive getType(String name) {
        return TYPES.get(name);
    }

    protected TypePrimitive(String name, String description, TypeReference tr) {
        super(name, description, ParserUtils.getDefaultDeserializer(tr), ParserUtils.getDefaultSerializer());
    }

    public TypePrimitive(String name, String description, JsonDeserializer jd) {
        super(name, description, jd);
    }

    public TypePrimitive(String name, String description, JsonDeserializer jd, JsonSerializer js) {
        super(name, description, jd, js);
    }

    static {
        TYPES.put("LONG", STA_ID_LONG);
        TYPES.put("STRING", STA_ID_STRING);
        TYPES.put("UUID", STA_ID_UUID);
        TYPES.put("TimeInstant", EDM_DATETIMEOFFSET);
        for (Field field : FieldUtils.getAllFields(TypePrimitive.class)) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                TypePrimitive primitive = (TypePrimitive)FieldUtils.readStaticField((Field)field, (boolean)false);
                String name = primitive.getName();
                TYPES.put(name, primitive);
                LOGGER.debug("Registered type: {}", (Object)name);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Failed to initialise: {}", (Object)field, (Object)ex);
            }
            catch (IllegalAccessException ex) {
                LOGGER.trace("Failed to initialise: {}", (Object)field, (Object)ex);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

